/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network.dns.records;

import dorkbox.network.dns.Compression;
import dorkbox.network.dns.DnsInput;
import dorkbox.network.dns.DnsOutput;
import dorkbox.network.dns.Name;
import dorkbox.network.dns.records.DnsRecord;
import dorkbox.network.dns.utils.Options;
import dorkbox.network.dns.utils.Tokenizer;
import java.io.IOException;

public class SOARecord
extends DnsRecord {
    private static final long serialVersionUID = 1049740098229303931L;
    private Name host;
    private Name admin;
    private long serial;
    private long refresh;
    private long retry;
    private long expire;
    private long minimum;

    SOARecord() {
    }

    @Override
    DnsRecord getObject() {
        return new SOARecord();
    }

    @Override
    void rrFromWire(DnsInput in) throws IOException {
        this.host = new Name(in);
        this.admin = new Name(in);
        this.serial = in.readU32();
        this.refresh = in.readU32();
        this.retry = in.readU32();
        this.expire = in.readU32();
        this.minimum = in.readU32();
    }

    @Override
    void rrToWire(DnsOutput out, Compression c, boolean canonical) {
        this.host.toWire(out, c, canonical);
        this.admin.toWire(out, c, canonical);
        out.writeU32(this.serial);
        out.writeU32(this.refresh);
        out.writeU32(this.retry);
        out.writeU32(this.expire);
        out.writeU32(this.minimum);
    }

    @Override
    void rrToString(StringBuilder sb) {
        sb.append(this.host);
        sb.append(" ");
        sb.append(this.admin);
        if (Options.check("multiline")) {
            sb.append(" (\n\t\t\t\t\t");
            sb.append(this.serial);
            sb.append("\t; serial\n\t\t\t\t\t");
            sb.append(this.refresh);
            sb.append("\t; refresh\n\t\t\t\t\t");
            sb.append(this.retry);
            sb.append("\t; retry\n\t\t\t\t\t");
            sb.append(this.expire);
            sb.append("\t; expire\n\t\t\t\t\t");
            sb.append(this.minimum);
            sb.append(" )\t; minimum");
        } else {
            sb.append(" ");
            sb.append(this.serial);
            sb.append(" ");
            sb.append(this.refresh);
            sb.append(" ");
            sb.append(this.retry);
            sb.append(" ");
            sb.append(this.expire);
            sb.append(" ");
            sb.append(this.minimum);
        }
    }

    @Override
    void rdataFromString(Tokenizer st, Name origin) throws IOException {
        this.host = st.getName(origin);
        this.admin = st.getName(origin);
        this.serial = st.getUInt32();
        this.refresh = st.getTTLLike();
        this.retry = st.getTTLLike();
        this.expire = st.getTTLLike();
        this.minimum = st.getTTLLike();
    }

    public SOARecord(Name name, int dclass, long ttl, Name host, Name admin, long serial, long refresh, long retry, long expire, long minimum) {
        super(name, 6, dclass, ttl);
        this.host = SOARecord.checkName("host", host);
        this.admin = SOARecord.checkName("admin", admin);
        this.serial = SOARecord.checkU32("serial", serial);
        this.refresh = SOARecord.checkU32("refresh", refresh);
        this.retry = SOARecord.checkU32("retry", retry);
        this.expire = SOARecord.checkU32("expire", expire);
        this.minimum = SOARecord.checkU32("minimum", minimum);
    }

    public Name getHost() {
        return this.host;
    }

    public Name getAdmin() {
        return this.admin;
    }

    public long getSerial() {
        return this.serial;
    }

    public long getRefresh() {
        return this.refresh;
    }

    public long getRetry() {
        return this.retry;
    }

    public long getExpire() {
        return this.expire;
    }

    public long getMinimum() {
        return this.minimum;
    }
}

