/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network.dns.records;

import dorkbox.network.dns.Compression;
import dorkbox.network.dns.DnsInput;
import dorkbox.network.dns.DnsOutput;
import dorkbox.network.dns.Name;
import dorkbox.network.dns.records.DnsRecord;
import dorkbox.network.dns.utils.Tokenizer;
import java.io.IOException;

public class SRVRecord
extends DnsRecord {
    private static final long serialVersionUID = -3886460132387522052L;
    private int priority;
    private int weight;
    private int port;
    private Name target;

    SRVRecord() {
    }

    @Override
    DnsRecord getObject() {
        return new SRVRecord();
    }

    @Override
    void rrFromWire(DnsInput in) throws IOException {
        this.priority = in.readU16();
        this.weight = in.readU16();
        this.port = in.readU16();
        this.target = new Name(in);
    }

    @Override
    void rrToWire(DnsOutput out, Compression c, boolean canonical) {
        out.writeU16(this.priority);
        out.writeU16(this.weight);
        out.writeU16(this.port);
        this.target.toWire(out, null, canonical);
    }

    @Override
    void rrToString(StringBuilder sb) {
        sb.append(this.priority + " ");
        sb.append(this.weight + " ");
        sb.append(this.port + " ");
        sb.append(this.target);
    }

    @Override
    void rdataFromString(Tokenizer st, Name origin) throws IOException {
        this.priority = st.getUInt16();
        this.weight = st.getUInt16();
        this.port = st.getUInt16();
        this.target = st.getName(origin);
    }

    @Override
    public Name getAdditionalName() {
        return this.target;
    }

    public SRVRecord(Name name, int dclass, long ttl, int priority, int weight, int port, Name target) {
        super(name, 33, dclass, ttl);
        this.priority = SRVRecord.checkU16("priority", priority);
        this.weight = SRVRecord.checkU16("weight", weight);
        this.port = SRVRecord.checkU16("port", port);
        this.target = SRVRecord.checkName("target", target);
    }

    public int getPriority() {
        return this.priority;
    }

    public int getWeight() {
        return this.weight;
    }

    public int getPort() {
        return this.port;
    }

    public Name getTarget() {
        return this.target;
    }
}

