/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network.dns.records;

import dorkbox.network.dns.Compression;
import dorkbox.network.dns.DnsInput;
import dorkbox.network.dns.DnsOutput;
import dorkbox.network.dns.Name;
import dorkbox.network.dns.records.DnsRecord;
import dorkbox.network.dns.utils.Tokenizer;
import java.io.IOException;

abstract class U16NameBase
extends DnsRecord {
    private static final long serialVersionUID = -8315884183112502995L;
    protected int u16Field;
    protected Name nameField;

    protected U16NameBase() {
    }

    protected U16NameBase(Name name, int type, int dclass, long ttl) {
        super(name, type, dclass, ttl);
    }

    protected U16NameBase(Name name, int type, int dclass, long ttl, int u16Field, String u16Description, Name nameField, String nameDescription) {
        super(name, type, dclass, ttl);
        this.u16Field = U16NameBase.checkU16(u16Description, u16Field);
        this.nameField = U16NameBase.checkName(nameDescription, nameField);
    }

    @Override
    void rrFromWire(DnsInput in) throws IOException {
        this.u16Field = in.readU16();
        this.nameField = new Name(in);
    }

    @Override
    void rrToWire(DnsOutput out, Compression c, boolean canonical) {
        out.writeU16(this.u16Field);
        this.nameField.toWire(out, null, canonical);
    }

    @Override
    void rrToString(StringBuilder sb) {
        sb.append(this.u16Field);
        sb.append(" ");
        sb.append(this.nameField);
    }

    @Override
    void rdataFromString(Tokenizer st, Name origin) throws IOException {
        this.u16Field = st.getUInt16();
        this.nameField = st.getName(origin);
    }

    protected int getU16Field() {
        return this.u16Field;
    }

    protected Name getNameField() {
        return this.nameField;
    }
}

