/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network.dns.records;

import dorkbox.network.dns.Compression;
import dorkbox.network.dns.DnsInput;
import dorkbox.network.dns.DnsOutput;
import dorkbox.network.dns.Name;
import dorkbox.network.dns.records.DnsRecord;
import dorkbox.network.dns.utils.Tokenizer;
import java.io.IOException;

public class UNKRecord
extends DnsRecord {
    private static final long serialVersionUID = -4193583311594626915L;
    private byte[] data;

    UNKRecord() {
    }

    @Override
    DnsRecord getObject() {
        return new UNKRecord();
    }

    @Override
    void rrFromWire(DnsInput in) throws IOException {
        this.data = in.readByteArray();
    }

    @Override
    void rrToWire(DnsOutput out, Compression c, boolean canonical) {
        out.writeByteArray(this.data);
    }

    @Override
    void rrToString(StringBuilder sb) {
        sb.append(UNKRecord.unknownToString(this.data));
    }

    @Override
    void rdataFromString(Tokenizer st, Name origin) throws IOException {
        throw st.exception("invalid unknown RR encoding");
    }

    public byte[] getData() {
        return this.data;
    }
}

