/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network.dns.records;

import dorkbox.network.dns.Compression;
import dorkbox.network.dns.DnsInput;
import dorkbox.network.dns.DnsOutput;
import dorkbox.network.dns.Name;
import dorkbox.network.dns.exceptions.TextParseException;
import dorkbox.network.dns.records.DnsRecord;
import dorkbox.network.dns.utils.Tokenizer;
import java.io.IOException;

public class URIRecord
extends DnsRecord {
    private static final long serialVersionUID = 7955422413971804232L;
    private int priority;
    private int weight;
    private byte[] target;

    URIRecord() {
        this.target = new byte[0];
    }

    @Override
    DnsRecord getObject() {
        return new URIRecord();
    }

    @Override
    void rrFromWire(DnsInput in) throws IOException {
        this.priority = in.readU16();
        this.weight = in.readU16();
        this.target = in.readByteArray();
    }

    @Override
    void rrToWire(DnsOutput out, Compression c, boolean canonical) {
        out.writeU16(this.priority);
        out.writeU16(this.weight);
        out.writeByteArray(this.target);
    }

    @Override
    void rrToString(StringBuilder sb) {
        sb.append(this.priority + " ");
        sb.append(this.weight + " ");
        sb.append(URIRecord.byteArrayToString(this.target, true));
    }

    @Override
    void rdataFromString(Tokenizer st, Name origin) throws IOException {
        this.priority = st.getUInt16();
        this.weight = st.getUInt16();
        try {
            this.target = URIRecord.byteArrayFromString(st.getString());
        }
        catch (TextParseException e) {
            throw st.exception(e.getMessage());
        }
    }

    public URIRecord(Name name, int dclass, long ttl, int priority, int weight, String target) {
        super(name, 256, dclass, ttl);
        this.priority = URIRecord.checkU16("priority", priority);
        this.weight = URIRecord.checkU16("weight", weight);
        try {
            this.target = URIRecord.byteArrayFromString(target);
        }
        catch (TextParseException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public int getPriority() {
        return this.priority;
    }

    public int getWeight() {
        return this.weight;
    }

    public String getTarget() {
        return URIRecord.byteArrayToString(this.target, false);
    }
}

