/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network.dns.records;

import dorkbox.network.dns.Compression;
import dorkbox.network.dns.DnsInput;
import dorkbox.network.dns.DnsOutput;
import dorkbox.network.dns.Name;
import dorkbox.network.dns.records.DnsRecord;
import dorkbox.network.dns.utils.Tokenizer;
import java.io.IOException;

public class X25Record
extends DnsRecord {
    private static final long serialVersionUID = 4267576252335579764L;
    private byte[] address;

    X25Record() {
    }

    @Override
    DnsRecord getObject() {
        return new X25Record();
    }

    @Override
    void rrFromWire(DnsInput in) throws IOException {
        this.address = in.readCountedString();
    }

    @Override
    void rrToWire(DnsOutput out, Compression c, boolean canonical) {
        out.writeCountedString(this.address);
    }

    @Override
    void rrToString(StringBuilder sb) {
        sb.append(X25Record.byteArrayToString(this.address, true));
    }

    @Override
    void rdataFromString(Tokenizer st, Name origin) throws IOException {
        String addr = st.getString();
        this.address = X25Record.checkAndConvertAddress(addr);
        if (this.address == null) {
            throw st.exception("invalid PSDN address " + addr);
        }
    }

    public X25Record(Name name, int dclass, long ttl, String address) {
        super(name, 19, dclass, ttl);
        this.address = X25Record.checkAndConvertAddress(address);
        if (this.address == null) {
            throw new IllegalArgumentException("invalid PSDN address " + address);
        }
    }

    private static byte[] checkAndConvertAddress(String address) {
        int length = address.length();
        byte[] out = new byte[length];
        for (int i = 0; i < length; ++i) {
            char c = address.charAt(i);
            if (!Character.isDigit(c)) {
                return null;
            }
            out[i] = (byte)c;
        }
        return out;
    }

    public String getAddress() {
        return X25Record.byteArrayToString(this.address, false);
    }
}

