/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network.dns.resolver;

import dorkbox.network.dns.DatagramDnsQueryEncoder;
import dorkbox.network.dns.DatagramDnsResponseDecoder;
import dorkbox.network.dns.DnsQuestion;
import dorkbox.network.dns.DnsResponse;
import dorkbox.network.dns.resolver.BiDnsQueryLifecycleObserverFactory;
import dorkbox.network.dns.resolver.DnsNameResolverListResolverContext;
import dorkbox.network.dns.resolver.DnsNameResolverResponseHandler;
import dorkbox.network.dns.resolver.DnsNameResolverSingleResolverContext;
import dorkbox.network.dns.resolver.DnsQueryContext;
import dorkbox.network.dns.resolver.DnsQueryContextManager;
import dorkbox.network.dns.resolver.DnsQueryLifecycleObserverFactory;
import dorkbox.network.dns.resolver.NoopDnsQueryLifecycleObserverFactory;
import dorkbox.network.dns.resolver.TraceDnsQueryLifeCycleObserverFactory;
import dorkbox.network.dns.resolver.addressProvider.DnsServerAddressStream;
import dorkbox.network.dns.resolver.addressProvider.DnsServerAddressStreamProvider;
import dorkbox.network.dns.resolver.addressProvider.DnsServerAddresses;
import dorkbox.network.dns.resolver.addressProvider.UnixResolverDnsServerAddressStreamProvider;
import dorkbox.network.dns.resolver.cache.DnsCache;
import dorkbox.network.dns.resolver.cache.DnsCacheEntry;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.AddressedEnvelope;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFactory;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.FixedRecvByteBufAllocator;
import io.netty.channel.RecvByteBufAllocator;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.InternetProtocolFamily;
import io.netty.resolver.HostsFileEntriesResolver;
import io.netty.resolver.InetNameResolver;
import io.netty.resolver.ResolvedAddressTypes;
import io.netty.util.NetUtil;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.FastThreadLocal;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;
import io.netty.util.internal.EmptyArrays;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DnsNameResolver
extends InetNameResolver {
    static final Logger logger;
    private static final String LOCALHOST = "localhost";
    private static final InetAddress LOCALHOST_ADDRESS;
    private static final int[] IPV4_ONLY_RESOLVED_RECORD_TYPES;
    private static final InternetProtocolFamily[] IPV4_ONLY_RESOLVED_PROTOCOL_FAMILIES;
    private static final int[] IPV4_PREFERRED_RESOLVED_RECORD_TYPES;
    private static final InternetProtocolFamily[] IPV4_PREFERRED_RESOLVED_PROTOCOL_FAMILIES;
    private static final int[] IPV6_ONLY_RESOLVED_RECORD_TYPES;
    private static final InternetProtocolFamily[] IPV6_ONLY_RESOLVED_PROTOCOL_FAMILIES;
    private static final int[] IPV6_PREFERRED_RESOLVED_RECORD_TYPES;
    private static final InternetProtocolFamily[] IPV6_PREFERRED_RESOLVED_PROTOCOL_FAMILIES;
    public static final ResolvedAddressTypes DEFAULT_RESOLVE_ADDRESS_TYPES;
    static final String[] DEFAULT_SEARCH_DOMAINS;
    private static final int DEFAULT_NDOTS;
    private static final DatagramDnsResponseDecoder DNS_DECODER;
    private final DatagramDnsQueryEncoder DNS_ENCODER;
    final Future<Channel> channelFuture;
    final DatagramChannel ch;
    final DnsQueryContextManager queryContextManager = new DnsQueryContextManager();
    private final DnsCache resolveCache;
    private final DnsCache authoritativeDnsServerCache;
    private final long queryTimeoutMillis;
    private final int maxQueriesPerResolve;
    private final ResolvedAddressTypes resolvedAddressTypes;
    private final InternetProtocolFamily[] resolvedInternetProtocolFamilies;
    private final boolean recursionDesired;
    private final int maxPayloadSize;
    private final HostsFileEntriesResolver hostsFileEntriesResolver;
    private final DnsServerAddressStreamProvider dnsServerAddressStreamProvider;
    private final FastThreadLocal<DnsServerAddressStream> nameServerAddrStream = new FastThreadLocal<DnsServerAddressStream>(){

        protected DnsServerAddressStream initialValue() throws Exception {
            return DnsNameResolver.this.dnsServerAddressStreamProvider.nameServerAddressStream("");
        }
    };
    private final String[] searchDomains;
    private final int ndots;
    private final boolean supportsAAAARecords;
    private final boolean supportsARecords;
    private final InternetProtocolFamily preferredAddressType;
    private final int[] resolveRecordTypes;
    private final boolean decodeIdn;
    private final DnsQueryLifecycleObserverFactory dnsQueryLifecycleObserverFactory;

    public DnsNameResolver(EventLoop eventLoop, ChannelFactory<? extends DatagramChannel> channelFactory, final DnsCache resolveCache, DnsCache authoritativeDnsServerCache, DnsQueryLifecycleObserverFactory dnsQueryLifecycleObserverFactory, long queryTimeoutMillis, ResolvedAddressTypes resolvedAddressTypes, boolean recursionDesired, int maxQueriesPerResolve, boolean traceEnabled, int maxPayloadSize, HostsFileEntriesResolver hostsFileEntriesResolver, DnsServerAddressStreamProvider dnsServerAddressStreamProvider, String[] searchDomains, int ndots, boolean decodeIdn) {
        super((EventExecutor)eventLoop);
        this.queryTimeoutMillis = ObjectUtil.checkPositive((long)queryTimeoutMillis, (String)"queryTimeoutMillis");
        this.resolvedAddressTypes = resolvedAddressTypes != null ? resolvedAddressTypes : DEFAULT_RESOLVE_ADDRESS_TYPES;
        this.recursionDesired = recursionDesired;
        this.maxQueriesPerResolve = ObjectUtil.checkPositive((int)maxQueriesPerResolve, (String)"maxQueriesPerResolve");
        this.maxPayloadSize = ObjectUtil.checkPositive((int)maxPayloadSize, (String)"maxPayloadSize");
        this.hostsFileEntriesResolver = (HostsFileEntriesResolver)ObjectUtil.checkNotNull((Object)hostsFileEntriesResolver, (String)"hostsFileEntriesResolver");
        this.dnsServerAddressStreamProvider = (DnsServerAddressStreamProvider)ObjectUtil.checkNotNull((Object)dnsServerAddressStreamProvider, (String)"dnsServerAddressStreamProvider");
        this.resolveCache = (DnsCache)ObjectUtil.checkNotNull((Object)resolveCache, (String)"resolveCache");
        this.authoritativeDnsServerCache = (DnsCache)ObjectUtil.checkNotNull((Object)authoritativeDnsServerCache, (String)"authoritativeDnsServerCache");
        this.dnsQueryLifecycleObserverFactory = traceEnabled ? (dnsQueryLifecycleObserverFactory instanceof NoopDnsQueryLifecycleObserverFactory ? new TraceDnsQueryLifeCycleObserverFactory() : new BiDnsQueryLifecycleObserverFactory(new TraceDnsQueryLifeCycleObserverFactory(), dnsQueryLifecycleObserverFactory)) : (DnsQueryLifecycleObserverFactory)ObjectUtil.checkNotNull((Object)dnsQueryLifecycleObserverFactory, (String)"dnsQueryLifecycleObserverFactory");
        this.searchDomains = searchDomains != null ? (String[])searchDomains.clone() : DEFAULT_SEARCH_DOMAINS;
        this.ndots = ndots >= 0 ? ndots : DEFAULT_NDOTS;
        this.decodeIdn = decodeIdn;
        switch (this.resolvedAddressTypes) {
            case IPV4_ONLY: {
                this.supportsAAAARecords = false;
                this.supportsARecords = true;
                this.resolveRecordTypes = IPV4_ONLY_RESOLVED_RECORD_TYPES;
                this.resolvedInternetProtocolFamilies = IPV4_ONLY_RESOLVED_PROTOCOL_FAMILIES;
                this.preferredAddressType = InternetProtocolFamily.IPv4;
                break;
            }
            case IPV4_PREFERRED: {
                this.supportsAAAARecords = true;
                this.supportsARecords = true;
                this.resolveRecordTypes = IPV4_PREFERRED_RESOLVED_RECORD_TYPES;
                this.resolvedInternetProtocolFamilies = IPV4_PREFERRED_RESOLVED_PROTOCOL_FAMILIES;
                this.preferredAddressType = InternetProtocolFamily.IPv4;
                break;
            }
            case IPV6_ONLY: {
                this.supportsAAAARecords = true;
                this.supportsARecords = false;
                this.resolveRecordTypes = IPV6_ONLY_RESOLVED_RECORD_TYPES;
                this.resolvedInternetProtocolFamilies = IPV6_ONLY_RESOLVED_PROTOCOL_FAMILIES;
                this.preferredAddressType = InternetProtocolFamily.IPv6;
                break;
            }
            case IPV6_PREFERRED: {
                this.supportsAAAARecords = true;
                this.supportsARecords = true;
                this.resolveRecordTypes = IPV6_PREFERRED_RESOLVED_RECORD_TYPES;
                this.resolvedInternetProtocolFamilies = IPV6_PREFERRED_RESOLVED_PROTOCOL_FAMILIES;
                this.preferredAddressType = InternetProtocolFamily.IPv6;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown ResolvedAddressTypes " + resolvedAddressTypes);
            }
        }
        Bootstrap b = new Bootstrap();
        b.group((EventLoopGroup)this.executor());
        b.channelFactory(channelFactory);
        b.option(ChannelOption.DATAGRAM_CHANNEL_ACTIVE_ON_REGISTRATION, (Object)true);
        this.DNS_ENCODER = new DatagramDnsQueryEncoder(maxPayloadSize);
        Promise channelActivePromise = this.executor().newPromise();
        final DnsNameResolverResponseHandler responseHandler = new DnsNameResolverResponseHandler(this, (Promise<Channel>)channelActivePromise);
        b.handler((ChannelHandler)new ChannelInitializer<DatagramChannel>(){

            protected void initChannel(DatagramChannel ch) throws Exception {
                ch.pipeline().addLast(new ChannelHandler[]{DNS_DECODER, DnsNameResolver.this.DNS_ENCODER, responseHandler});
            }
        });
        this.channelFuture = channelActivePromise;
        this.ch = (DatagramChannel)b.register().channel();
        this.ch.config().setRecvByteBufAllocator((RecvByteBufAllocator)new FixedRecvByteBufAllocator(maxPayloadSize));
        this.ch.closeFuture().addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                resolveCache.clear();
            }
        });
    }

    protected EventLoop executor() {
        return (EventLoop)super.executor();
    }

    protected void doResolve(String inetHost, Promise<InetAddress> promise) throws Exception {
        this.doResolve(inetHost, promise, this.resolveCache);
    }

    protected void doResolveAll(String inetHost, Promise<List<InetAddress>> promise) throws Exception {
        this.doResolveAll(inetHost, promise, this.resolveCache);
    }

    public void close() {
        if (this.ch.isOpen()) {
            this.ch.close();
        }
    }

    protected void doResolveAll(String inetHost, Promise<List<InetAddress>> promise, DnsCache resolveCache) throws Exception {
        if (inetHost == null || inetHost.isEmpty()) {
            promise.setSuccess(Collections.singletonList(this.loopbackAddress()));
            return;
        }
        byte[] bytes = NetUtil.createByteArrayFromIpAddressString((String)inetHost);
        if (bytes != null) {
            promise.setSuccess(Collections.singletonList(InetAddress.getByAddress(bytes)));
            return;
        }
        String hostname = DnsQuestion.hostNameAsciiFix(inetHost);
        InetAddress hostsFileEntry = this.resolveHostsFileEntry(hostname);
        if (hostsFileEntry != null) {
            promise.setSuccess(Collections.singletonList(hostsFileEntry));
            return;
        }
        if (!this.doResolveAllCached(hostname, promise, resolveCache)) {
            this.doResolveAllUncached(hostname, promise, resolveCache);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doResolveAllCached(String hostname, Promise<List<InetAddress>> promise, DnsCache resolveCache) {
        List<DnsCacheEntry> cachedEntries = resolveCache.get(hostname);
        if (cachedEntries == null || cachedEntries.isEmpty()) {
            return false;
        }
        ArrayList<InetAddress> result = null;
        Throwable cause = null;
        List<DnsCacheEntry> list = cachedEntries;
        synchronized (list) {
            int numEntries = cachedEntries.size();
            assert (numEntries > 0);
            if (cachedEntries.get(0).cause() != null) {
                cause = cachedEntries.get(0).cause();
            } else {
                for (InternetProtocolFamily f : this.resolvedInternetProtocolFamilies) {
                    for (int i = 0; i < numEntries; ++i) {
                        DnsCacheEntry e = cachedEntries.get(i);
                        if (!f.addressType().isInstance(e.address())) continue;
                        if (result == null) {
                            result = new ArrayList<InetAddress>(numEntries);
                        }
                        result.add(e.address());
                    }
                }
            }
        }
        if (result != null) {
            DnsNameResolver.trySuccess(promise, result);
            return true;
        }
        if (cause != null) {
            DnsNameResolver.tryFailure(promise, cause);
            return true;
        }
        return false;
    }

    private void doResolveAllUncached(String hostname, Promise<List<InetAddress>> promise, DnsCache resolveCache) {
        DnsServerAddressStream nameServerAddrs = this.dnsServerAddressStreamProvider.nameServerAddressStream(hostname);
        DnsNameResolverListResolverContext context = new DnsNameResolverListResolverContext(this, hostname, resolveCache, nameServerAddrs);
        context.resolve(promise);
    }

    protected void doResolve(String inetHost, Promise<InetAddress> promise, DnsCache resolveCache) throws Exception {
        if (inetHost == null || inetHost.isEmpty()) {
            promise.setSuccess((Object)this.loopbackAddress());
            return;
        }
        byte[] bytes = NetUtil.createByteArrayFromIpAddressString((String)inetHost);
        if (bytes != null) {
            promise.setSuccess((Object)InetAddress.getByAddress(bytes));
            return;
        }
        String hostname = DnsQuestion.hostNameAsciiFix(inetHost);
        InetAddress hostsFileEntry = this.resolveHostsFileEntry(hostname);
        if (hostsFileEntry != null) {
            promise.setSuccess((Object)hostsFileEntry);
            return;
        }
        if (!this.doResolveCached(hostname, promise, resolveCache)) {
            this.doResolveUncached(hostname, promise, resolveCache);
        }
    }

    private InetAddress resolveHostsFileEntry(String hostname) {
        if (this.hostsFileEntriesResolver == null) {
            return null;
        }
        InetAddress address = this.hostsFileEntriesResolver.address(hostname, this.resolvedAddressTypes);
        if (address == null && PlatformDependent.isWindows() && LOCALHOST.equalsIgnoreCase(hostname)) {
            return LOCALHOST_ADDRESS;
        }
        return address;
    }

    private InetAddress loopbackAddress() {
        return this.preferredAddressType().localhost();
    }

    final InternetProtocolFamily preferredAddressType() {
        return this.preferredAddressType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doResolveCached(String hostname, Promise<InetAddress> promise, DnsCache resolveCache) {
        List<DnsCacheEntry> cachedEntries = resolveCache.get(hostname);
        if (cachedEntries == null || cachedEntries.isEmpty()) {
            return false;
        }
        InetAddress address = null;
        Throwable cause = null;
        List<DnsCacheEntry> list = cachedEntries;
        synchronized (list) {
            int numEntries = cachedEntries.size();
            assert (numEntries > 0);
            if (cachedEntries.get(0).cause() != null) {
                cause = cachedEntries.get(0).cause();
            } else {
                block3: for (InternetProtocolFamily f : this.resolvedInternetProtocolFamilies) {
                    for (int i = 0; i < numEntries; ++i) {
                        DnsCacheEntry e = cachedEntries.get(i);
                        if (!f.addressType().isInstance(e.address())) continue;
                        address = e.address();
                        continue block3;
                    }
                }
            }
        }
        if (address != null) {
            DnsNameResolver.trySuccess(promise, address);
            return true;
        }
        if (cause != null) {
            DnsNameResolver.tryFailure(promise, cause);
            return true;
        }
        return false;
    }

    static <T> void trySuccess(Promise<T> promise, T result) {
        if (!promise.trySuccess(result)) {
            logger.warn("Failed to notify success ({}) to a promise: {}", result, promise);
        }
    }

    private static void tryFailure(Promise<?> promise, Throwable cause) {
        if (!promise.tryFailure(cause)) {
            logger.warn("Failed to notify failure to a promise: {}", promise, (Object)cause);
        }
    }

    private void doResolveUncached(String hostname, Promise<InetAddress> promise, DnsCache resolveCache) {
        new DnsNameResolverSingleResolverContext(this, hostname, resolveCache, this.dnsServerAddressStreamProvider.nameServerAddressStream(hostname)).resolve(promise);
    }

    int dnsRedirectPort(InetAddress server) {
        return 53;
    }

    final DnsQueryLifecycleObserverFactory dnsQueryLifecycleObserverFactory() {
        return this.dnsQueryLifecycleObserverFactory;
    }

    protected DnsServerAddressStream uncachedRedirectDnsServerStream(List<InetSocketAddress> nameServers) {
        return DnsServerAddresses.sequential(nameServers).stream();
    }

    public DnsCache resolveCache() {
        return this.resolveCache;
    }

    public DnsCache authoritativeDnsServerCache() {
        return this.authoritativeDnsServerCache;
    }

    public long queryTimeoutMillis() {
        return this.queryTimeoutMillis;
    }

    public ResolvedAddressTypes resolvedAddressTypes() {
        return this.resolvedAddressTypes;
    }

    InternetProtocolFamily[] resolvedInternetProtocolFamiliesUnsafe() {
        return this.resolvedInternetProtocolFamilies;
    }

    final String[] searchDomains() {
        return this.searchDomains;
    }

    final int ndots() {
        return this.ndots;
    }

    final boolean supportsAAAARecords() {
        return this.supportsAAAARecords;
    }

    final boolean supportsARecords() {
        return this.supportsARecords;
    }

    final int[] resolveRecordTypes() {
        return this.resolveRecordTypes;
    }

    final boolean isDecodeIdn() {
        return this.decodeIdn;
    }

    public int maxQueriesPerResolve() {
        return this.maxQueriesPerResolve;
    }

    public int maxPayloadSize() {
        return this.maxPayloadSize;
    }

    public HostsFileEntriesResolver hostsFileEntriesResolver() {
        return this.hostsFileEntriesResolver;
    }

    public boolean isRecursionDesired() {
        return this.recursionDesired;
    }

    public final Future<InetAddress> resolve(String inetHost, Promise<InetAddress> promise) {
        ObjectUtil.checkNotNull(promise, (String)"promise");
        try {
            this.doResolve(inetHost, promise, this.resolveCache);
            return promise;
        }
        catch (Exception e) {
            return promise.setFailure((Throwable)e);
        }
    }

    public final Future<List<InetAddress>> resolveAll(String inetHost, Promise<List<InetAddress>> promise) {
        ObjectUtil.checkNotNull(promise, (String)"promise");
        try {
            this.doResolveAll(inetHost, promise, this.resolveCache);
            return promise;
        }
        catch (Exception e) {
            return promise.setFailure((Throwable)e);
        }
    }

    public Future<AddressedEnvelope<DnsResponse, InetSocketAddress>> query(DnsQuestion question) {
        return this.query(this.nextNameServerAddress(), question);
    }

    private InetSocketAddress nextNameServerAddress() {
        return ((DnsServerAddressStream)this.nameServerAddrStream.get()).next();
    }

    public Future<AddressedEnvelope<DnsResponse, InetSocketAddress>> query(InetSocketAddress nameServerAddr, DnsQuestion question) {
        return this.query0(nameServerAddr, question, (Promise<AddressedEnvelope<DnsResponse, InetSocketAddress>>)this.ch.eventLoop().newPromise());
    }

    final Future<AddressedEnvelope<DnsResponse, InetSocketAddress>> query0(InetSocketAddress nameServerAddr, DnsQuestion question, Promise<AddressedEnvelope<DnsResponse, InetSocketAddress>> promise) {
        return this.query0(nameServerAddr, question, this.ch.newPromise(), promise);
    }

    final Future<AddressedEnvelope<DnsResponse, InetSocketAddress>> query0(InetSocketAddress nameServerAddr, DnsQuestion question, ChannelPromise writePromise, Promise<AddressedEnvelope<DnsResponse, InetSocketAddress>> promise) {
        assert (!writePromise.isVoid());
        Promise<AddressedEnvelope<DnsResponse, InetSocketAddress>> castPromise = DnsNameResolver.cast((Promise)ObjectUtil.checkNotNull(promise, (String)"promise"));
        try {
            new DnsQueryContext(this, nameServerAddr, question, castPromise).query(writePromise);
            return castPromise;
        }
        catch (Exception e) {
            return castPromise.setFailure((Throwable)e);
        }
    }

    private static Promise<AddressedEnvelope<DnsResponse, InetSocketAddress>> cast(Promise<?> promise) {
        return promise;
    }

    public Future<AddressedEnvelope<DnsResponse, InetSocketAddress>> query(DnsQuestion question, Promise<AddressedEnvelope<DnsResponse, InetSocketAddress>> promise) {
        return this.query(this.nextNameServerAddress(), question, promise);
    }

    public Future<AddressedEnvelope<DnsResponse, InetSocketAddress>> query(InetSocketAddress nameServerAddr, DnsQuestion question, Promise<AddressedEnvelope<DnsResponse, InetSocketAddress>> promise) {
        return this.query0(nameServerAddr, question, null, promise);
    }

    static {
        int ndots;
        String[] searchDomains;
        logger = LoggerFactory.getLogger(DnsNameResolver.class);
        IPV4_ONLY_RESOLVED_RECORD_TYPES = new int[]{1};
        IPV4_ONLY_RESOLVED_PROTOCOL_FAMILIES = new InternetProtocolFamily[]{InternetProtocolFamily.IPv4};
        IPV4_PREFERRED_RESOLVED_RECORD_TYPES = new int[]{1, 28};
        IPV4_PREFERRED_RESOLVED_PROTOCOL_FAMILIES = new InternetProtocolFamily[]{InternetProtocolFamily.IPv4, InternetProtocolFamily.IPv6};
        IPV6_ONLY_RESOLVED_RECORD_TYPES = new int[]{28};
        IPV6_ONLY_RESOLVED_PROTOCOL_FAMILIES = new InternetProtocolFamily[]{InternetProtocolFamily.IPv6};
        IPV6_PREFERRED_RESOLVED_RECORD_TYPES = new int[]{28, 1};
        IPV6_PREFERRED_RESOLVED_PROTOCOL_FAMILIES = new InternetProtocolFamily[]{InternetProtocolFamily.IPv6, InternetProtocolFamily.IPv4};
        DNS_DECODER = new DatagramDnsResponseDecoder();
        if (NetUtil.isIpV4StackPreferred()) {
            DEFAULT_RESOLVE_ADDRESS_TYPES = ResolvedAddressTypes.IPV4_ONLY;
            LOCALHOST_ADDRESS = NetUtil.LOCALHOST4;
        } else if (NetUtil.isIpV6AddressesPreferred()) {
            DEFAULT_RESOLVE_ADDRESS_TYPES = ResolvedAddressTypes.IPV6_PREFERRED;
            LOCALHOST_ADDRESS = NetUtil.LOCALHOST6;
        } else {
            DEFAULT_RESOLVE_ADDRESS_TYPES = ResolvedAddressTypes.IPV4_PREFERRED;
            LOCALHOST_ADDRESS = NetUtil.LOCALHOST4;
        }
        try {
            Class<?> configClass = Class.forName("sun.net.dns.ResolverConfiguration");
            Method open = configClass.getMethod("open", new Class[0]);
            Method nameservers = configClass.getMethod("searchlist", new Class[0]);
            Object instance = open.invoke(null, new Object[0]);
            List list = (List)nameservers.invoke(instance, new Object[0]);
            searchDomains = list.toArray(new String[list.size()]);
        }
        catch (Exception ignore) {
            searchDomains = EmptyArrays.EMPTY_STRINGS;
        }
        DEFAULT_SEARCH_DOMAINS = searchDomains;
        try {
            ndots = UnixResolverDnsServerAddressStreamProvider.parseEtcResolverFirstNdots();
        }
        catch (Exception ignore) {
            ndots = 1;
        }
        DEFAULT_NDOTS = ndots;
    }
}

