/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network.dns.resolver;

import dorkbox.network.dns.DnsQuestion;
import dorkbox.network.dns.DnsResponse;
import dorkbox.network.dns.records.AAAARecord;
import dorkbox.network.dns.records.ARecord;
import dorkbox.network.dns.records.CNAMERecord;
import dorkbox.network.dns.records.DnsMessage;
import dorkbox.network.dns.records.DnsRecord;
import dorkbox.network.dns.records.NSRecord;
import dorkbox.network.dns.resolver.DnsNameResolver;
import dorkbox.network.dns.resolver.DnsQueryLifecycleObserver;
import dorkbox.network.dns.resolver.NoopDnsQueryLifecycleObserver;
import dorkbox.network.dns.resolver.addressProvider.DnsServerAddressStream;
import dorkbox.network.dns.resolver.addressProvider.DnsServerAddresses;
import dorkbox.network.dns.resolver.cache.DnsCache;
import dorkbox.network.dns.resolver.cache.DnsCacheEntry;
import io.netty.channel.AddressedEnvelope;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelPromise;
import io.netty.channel.socket.InternetProtocolFamily;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.StringUtil;
import io.netty.util.internal.ThrowableUtil;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

abstract class DnsNameResolverContext<T> {
    private static final FutureListener<AddressedEnvelope<DnsResponse, InetSocketAddress>> RELEASE_RESPONSE = new FutureListener<AddressedEnvelope<DnsResponse, InetSocketAddress>>(){

        public void operationComplete(Future<AddressedEnvelope<DnsResponse, InetSocketAddress>> future) {
            if (future.isSuccess()) {
                ((AddressedEnvelope)future.getNow()).release();
            }
        }
    };
    private static final RuntimeException NXDOMAIN_QUERY_FAILED_EXCEPTION = (RuntimeException)ThrowableUtil.unknownStackTrace((Throwable)new RuntimeException("No answer found and NXDOMAIN response code returned"), DnsNameResolverContext.class, (String)"onResponse(..)");
    private static final RuntimeException CNAME_NOT_FOUND_QUERY_FAILED_EXCEPTION = (RuntimeException)ThrowableUtil.unknownStackTrace((Throwable)new RuntimeException("No matching CNAME record found"), DnsNameResolverContext.class, (String)"onResponseCNAME(..)");
    private static final RuntimeException NO_MATCHING_RECORD_QUERY_FAILED_EXCEPTION = (RuntimeException)ThrowableUtil.unknownStackTrace((Throwable)new RuntimeException("No matching record type found"), DnsNameResolverContext.class, (String)"onResponseAorAAAA(..)");
    private static final RuntimeException UNRECOGNIZED_TYPE_QUERY_FAILED_EXCEPTION = (RuntimeException)ThrowableUtil.unknownStackTrace((Throwable)new RuntimeException("Response type was unrecognized"), DnsNameResolverContext.class, (String)"onResponse(..)");
    private static final RuntimeException NAME_SERVERS_EXHAUSTED_EXCEPTION = (RuntimeException)ThrowableUtil.unknownStackTrace((Throwable)new RuntimeException("No name servers returned an answer"), DnsNameResolverContext.class, (String)"tryToFinishResolve(..)");
    private final DnsNameResolver parent;
    private final DnsServerAddressStream nameServerAddrs;
    private final String hostname;
    private final DnsCache resolveCache;
    private final int maxAllowedQueries;
    private final InternetProtocolFamily[] resolvedInternetProtocolFamilies;
    private final Set<Future<AddressedEnvelope<DnsResponse, InetSocketAddress>>> queriesInProgress = Collections.newSetFromMap(new IdentityHashMap());
    private List<DnsCacheEntry> resolvedEntries;
    private int allowedQueries;
    private boolean triedCNAME;

    DnsNameResolverContext(DnsNameResolver parent, String hostname, DnsCache resolveCache, DnsServerAddressStream nameServerAddrs) {
        this.parent = parent;
        this.hostname = hostname;
        this.resolveCache = resolveCache;
        this.nameServerAddrs = (DnsServerAddressStream)ObjectUtil.checkNotNull((Object)nameServerAddrs, (String)"nameServerAddrs");
        this.maxAllowedQueries = parent.maxQueriesPerResolve();
        this.resolvedInternetProtocolFamilies = parent.resolvedInternetProtocolFamiliesUnsafe();
        this.allowedQueries = this.maxAllowedQueries;
    }

    void resolve(final Promise<T> promise) {
        if (this.parent.searchDomains().length == 0 || this.parent.ndots() == 0 || StringUtil.endsWith((CharSequence)this.hostname, (char)'.')) {
            this.internalResolve(promise);
        } else {
            int dots = 0;
            for (int idx = this.hostname.length() - 1; idx >= 0; --idx) {
                if (this.hostname.charAt(idx) != '.' || ++dots < this.parent.ndots()) continue;
                this.internalResolve(promise);
                return;
            }
            this.doSearchDomainQuery(0, new FutureListener<T>(){
                private int count = 1;

                public void operationComplete(Future<T> future) throws Exception {
                    if (future.isSuccess()) {
                        promise.trySuccess(future.getNow());
                    } else if (this.count < DnsNameResolverContext.this.parent.searchDomains().length) {
                        DnsNameResolverContext.this.doSearchDomainQuery(this.count++, this);
                    } else {
                        promise.tryFailure((Throwable)new SearchDomainUnknownHostException(future.cause(), DnsNameResolverContext.this.hostname));
                    }
                }
            });
        }
    }

    private void doSearchDomainQuery(int count, FutureListener<T> listener) {
        DnsNameResolverContext<T> nextContext = this.newResolverContext(this.parent, this.hostname + '.' + this.parent.searchDomains()[count], this.resolveCache, this.nameServerAddrs);
        Promise nextPromise = this.parent.executor().newPromise();
        nextPromise.addListener(listener);
        super.internalResolve(nextPromise);
    }

    private void internalResolve(Promise<T> promise) {
        DnsServerAddressStream nameServerAddressStream = this.getNameServers(this.hostname);
        int[] recordTypes = this.parent.resolveRecordTypes();
        assert (recordTypes.length > 0);
        int end = recordTypes.length - 1;
        for (int i = 0; i < end; ++i) {
            if (this.resolveQuery(this.hostname, recordTypes[i], nameServerAddressStream.duplicate(), promise)) continue;
            return;
        }
        this.resolveQuery(this.hostname, recordTypes[end], nameServerAddressStream, promise);
    }

    private void addNameServerToCache(AuthoritativeNameServer name, InetAddress resolved, long ttl) {
        if (!name.isRootServer()) {
            this.parent.authoritativeDnsServerCache().cache(name.domainName(), resolved, ttl, this.parent.ch.eventLoop());
        }
    }

    private DnsServerAddressStream getNameServersFromCache(String hostname) {
        List<DnsCacheEntry> entries;
        int idx;
        int len = hostname.length();
        if (len == 0) {
            return null;
        }
        if (hostname.charAt(len - 1) != '.') {
            hostname = hostname + ".";
        }
        if ((idx = hostname.indexOf(46)) == hostname.length() - 1) {
            return null;
        }
        do {
            int idx2;
            if ((idx2 = (hostname = hostname.substring(idx + 1)).indexOf(46)) <= 0 || idx2 == hostname.length() - 1) {
                return null;
            }
            idx = idx2;
        } while ((entries = this.parent.authoritativeDnsServerCache().get(hostname)) == null || entries.isEmpty());
        return DnsServerAddresses.sequential(new DnsCacheIterable(entries)).stream();
    }

    private void resolveQuery(DnsServerAddressStream nameServerAddrStream, int nameServerAddrStreamIndex, DnsQuestion question, Promise<T> promise) {
        this.resolveQuery(nameServerAddrStream, nameServerAddrStreamIndex, question, this.parent.dnsQueryLifecycleObserverFactory().newDnsQueryLifecycleObserver(question), promise);
    }

    private void resolveQuery(final DnsServerAddressStream nameServerAddrStream, final int nameServerAddrStreamIndex, final DnsQuestion question, final DnsQueryLifecycleObserver queryLifecycleObserver, final Promise<T> promise) {
        if (nameServerAddrStreamIndex >= nameServerAddrStream.size() || this.allowedQueries == 0 || promise.isCancelled()) {
            this.tryToFinishResolve(nameServerAddrStream, nameServerAddrStreamIndex, question, queryLifecycleObserver, promise);
            return;
        }
        --this.allowedQueries;
        InetSocketAddress nameServerAddr = nameServerAddrStream.next();
        ChannelPromise writePromise = this.parent.ch.newPromise();
        Future<AddressedEnvelope<DnsResponse, InetSocketAddress>> f = this.parent.query0(nameServerAddr, question, writePromise, (Promise<AddressedEnvelope<DnsResponse, InetSocketAddress>>)this.parent.ch.eventLoop().newPromise());
        this.queriesInProgress.add(f);
        queryLifecycleObserver.queryWritten(nameServerAddr, (ChannelFuture)writePromise);
        f.addListener((GenericFutureListener)new FutureListener<AddressedEnvelope<DnsResponse, InetSocketAddress>>(){

            public void operationComplete(Future<AddressedEnvelope<DnsResponse, InetSocketAddress>> future) {
                DnsNameResolverContext.this.queriesInProgress.remove(future);
                if (promise.isDone() || future.isCancelled()) {
                    queryLifecycleObserver.queryCancelled(DnsNameResolverContext.this.allowedQueries);
                    return;
                }
                AddressedEnvelope envelope = (AddressedEnvelope)future.getNow();
                try {
                    if (future.isSuccess()) {
                        DnsNameResolverContext.this.onResponse(nameServerAddrStream, nameServerAddrStreamIndex, question, (AddressedEnvelope<DnsResponse, InetSocketAddress>)envelope, queryLifecycleObserver, promise);
                    } else {
                        queryLifecycleObserver.queryFailed(future.cause());
                        question.retain();
                        DnsNameResolverContext.this.resolveQuery(nameServerAddrStream, nameServerAddrStreamIndex + 1, question, promise);
                    }
                }
                finally {
                    DnsNameResolverContext.this.tryToFinishResolve(nameServerAddrStream, nameServerAddrStreamIndex, question, NoopDnsQueryLifecycleObserver.INSTANCE, promise);
                }
            }
        });
    }

    void onResponse(DnsServerAddressStream nameServerAddrStream, int nameServerAddrStreamIndex, DnsQuestion question, AddressedEnvelope<DnsResponse, InetSocketAddress> envelope, DnsQueryLifecycleObserver queryLifecycleObserver, Promise<T> promise) {
        DnsResponse res = (DnsResponse)envelope.content();
        int code = res.getHeader().getRcode();
        if (code == 0) {
            if (this.handleRedirect(question, envelope, queryLifecycleObserver, promise)) {
                return;
            }
            int type = question.getQuestion().getType();
            if (type == 1 || type == 28) {
                this.onResponseAorAAAA(type, question, envelope, queryLifecycleObserver, promise);
            } else if (type == 5) {
                this.onResponseCNAME(question, envelope, queryLifecycleObserver, promise);
            } else {
                queryLifecycleObserver.queryFailed(UNRECOGNIZED_TYPE_QUERY_FAILED_EXCEPTION);
            }
            return;
        }
        if (code != 3) {
            this.resolveQuery(nameServerAddrStream, nameServerAddrStreamIndex + 1, question, queryLifecycleObserver.queryNoAnswer(code), promise);
        } else {
            queryLifecycleObserver.queryFailed(NXDOMAIN_QUERY_FAILED_EXCEPTION);
        }
    }

    private boolean handleRedirect(DnsQuestion question, AddressedEnvelope<DnsResponse, InetSocketAddress> envelope, DnsQueryLifecycleObserver queryLifecycleObserver, Promise<T> promise) {
        AuthoritativeNameServerList serverNames;
        DnsResponse res = (DnsResponse)envelope.content();
        DnsRecord[] answerArray = res.getSectionArray(1);
        if (answerArray.length == 0 && (serverNames = DnsNameResolverContext.extractAuthoritativeNameServers(question.getQuestion().getName().toString(), res)) != null) {
            ArrayList<InetSocketAddress> nameServers = new ArrayList<InetSocketAddress>(serverNames.size());
            DnsRecord[] additionalArray = res.getSectionArray(3);
            for (int i = 0; i < additionalArray.length; ++i) {
                InetAddress resolved;
                String recordName;
                AuthoritativeNameServer authoritativeNameServer;
                DnsRecord r = additionalArray[i];
                if (r.getType() == 1 && !this.parent.supportsARecords() || r.getType() == 28 && !this.parent.supportsAAAARecords() || (authoritativeNameServer = serverNames.remove(recordName = r.getName().toString())) == null || (resolved = this.parseAddress(r, recordName)) == null) continue;
                nameServers.add(new InetSocketAddress(resolved, this.parent.dnsRedirectPort(resolved)));
                this.addNameServerToCache(authoritativeNameServer, resolved, r.getTTL());
            }
            if (!nameServers.isEmpty()) {
                this.resolveQuery(this.parent.uncachedRedirectDnsServerStream(nameServers), 0, question, queryLifecycleObserver.queryRedirected(Collections.unmodifiableList(nameServers)), promise);
                return true;
            }
        }
        return false;
    }

    private static AuthoritativeNameServerList extractAuthoritativeNameServers(String questionName, DnsResponse res) {
        DnsRecord[] authority = res.getSectionArray(2);
        if (authority.length == 0) {
            return null;
        }
        System.err.println("TYODO");
        AuthoritativeNameServerList serverNames = new AuthoritativeNameServerList(questionName);
        for (int i = 0; i < authority.length; ++i) {
            DnsRecord dnsRecord = authority[i];
            serverNames.add(dnsRecord);
        }
        return serverNames;
    }

    private void onResponseAorAAAA(int qType, DnsMessage question, AddressedEnvelope<DnsResponse, InetSocketAddress> envelope, DnsQueryLifecycleObserver queryLifecycleObserver, Promise<T> promise) {
        DnsResponse response = (DnsResponse)envelope.content();
        Map<String, String> cnames = DnsNameResolverContext.buildAliasMap(response);
        DnsRecord[] answerArray = response.getSectionArray(1);
        boolean found = false;
        for (int i = 0; i < answerArray.length; ++i) {
            Object resolved;
            DnsRecord r = answerArray[i];
            int type = r.getType();
            if (type != 1 && type != 28) continue;
            String questionName = question.getQuestion().getName().toString();
            String recordName = r.getName().toString();
            if (!recordName.equals(questionName)) {
                resolved = questionName;
                while (!recordName.equals(resolved = cnames.get(resolved)) && resolved != null) {
                }
                if (resolved == null) continue;
            }
            if ((resolved = this.parseAddress(r, this.hostname)) == null) continue;
            if (this.resolvedEntries == null) {
                this.resolvedEntries = new ArrayList<DnsCacheEntry>(8);
            }
            DnsCacheEntry e = new DnsCacheEntry(this.hostname, (InetAddress)resolved);
            this.resolveCache.cache(this.hostname, (InetAddress)resolved, r.getTTL(), this.parent.ch.eventLoop());
            this.resolvedEntries.add(e);
            found = true;
        }
        if (found) {
            queryLifecycleObserver.querySucceed();
            return;
        }
        if (cnames.isEmpty()) {
            queryLifecycleObserver.queryFailed(NO_MATCHING_RECORD_QUERY_FAILED_EXCEPTION);
        } else {
            this.onResponseCNAME(question, envelope, cnames, queryLifecycleObserver, promise);
        }
    }

    private InetAddress parseAddress(DnsRecord record, String name) {
        int type = record.getType();
        if (type == 1) {
            ARecord aRecord = (ARecord)record;
            return aRecord.getAddress();
        }
        if (type == 28) {
            AAAARecord aaaaRecord = (AAAARecord)record;
            return aaaaRecord.getAddress();
        }
        return null;
    }

    private void onResponseCNAME(DnsMessage question, AddressedEnvelope<DnsResponse, InetSocketAddress> envelope, DnsQueryLifecycleObserver queryLifecycleObserver, Promise<T> promise) {
        this.onResponseCNAME(question, envelope, DnsNameResolverContext.buildAliasMap((DnsMessage)envelope.content()), queryLifecycleObserver, promise);
    }

    private void onResponseCNAME(DnsMessage question, AddressedEnvelope<DnsResponse, InetSocketAddress> response, Map<String, String> cnames, DnsQueryLifecycleObserver queryLifecycleObserver, Promise<T> promise) {
        String next;
        String resolved = question.getQuestion().getName().toString();
        boolean found = false;
        while (!cnames.isEmpty() && (next = cnames.remove(resolved)) != null) {
            found = true;
            resolved = next;
        }
        if (found) {
            this.followCname(resolved, queryLifecycleObserver, promise);
        } else {
            queryLifecycleObserver.queryFailed(CNAME_NOT_FOUND_QUERY_FAILED_EXCEPTION);
        }
    }

    private static Map<String, String> buildAliasMap(DnsMessage response) {
        DnsRecord[] answerArray = response.getSectionArray(1);
        Map<String, String> cnames = null;
        int length = answerArray.length;
        for (int i = 0; i < length; ++i) {
            DnsRecord record = answerArray[i];
            int type = record.getType();
            if (type != 5) continue;
            System.err.println("CHECK ME ME! we don't have bytebuf content in this fashion anymore");
            CNAMERecord re = (CNAMERecord)record;
            String domainName = re.getAlias().toString();
            if (domainName == null) continue;
            if (cnames == null) {
                cnames = new HashMap<String, String>(Math.min(8, length));
            }
            cnames.put(record.getName().toString().toLowerCase(Locale.US), domainName.toLowerCase(Locale.US));
        }
        return cnames != null ? cnames : Collections.emptyMap();
    }

    void tryToFinishResolve(DnsServerAddressStream nameServerAddrStream, int nameServerAddrStreamIndex, DnsQuestion question, DnsQueryLifecycleObserver queryLifecycleObserver, Promise<T> promise) {
        if (!this.queriesInProgress.isEmpty()) {
            queryLifecycleObserver.queryCancelled(this.allowedQueries);
            if (this.gotPreferredAddress()) {
                this.finishResolve(promise, question);
            }
            return;
        }
        if (this.resolvedEntries == null) {
            if (nameServerAddrStreamIndex < nameServerAddrStream.size()) {
                question.retain();
                if (queryLifecycleObserver == NoopDnsQueryLifecycleObserver.INSTANCE) {
                    this.resolveQuery(nameServerAddrStream, nameServerAddrStreamIndex + 1, question, promise);
                } else {
                    this.resolveQuery(nameServerAddrStream, nameServerAddrStreamIndex + 1, question, queryLifecycleObserver, promise);
                }
                return;
            }
            queryLifecycleObserver.queryFailed(NAME_SERVERS_EXHAUSTED_EXCEPTION);
            if (!this.triedCNAME) {
                this.triedCNAME = true;
                this.resolveQuery(this.hostname, 5, this.getNameServers(this.hostname), promise);
                return;
            }
        } else {
            queryLifecycleObserver.queryCancelled(this.allowedQueries);
        }
        this.finishResolve(promise, question);
    }

    private boolean gotPreferredAddress() {
        if (this.resolvedEntries == null) {
            return false;
        }
        int size = this.resolvedEntries.size();
        Class inetAddressType = this.parent.preferredAddressType().addressType();
        for (int i = 0; i < size; ++i) {
            InetAddress address = this.resolvedEntries.get(i).address();
            if (!inetAddressType.isInstance(address)) continue;
            return true;
        }
        return false;
    }

    private void finishResolve(Promise<T> promise, DnsQuestion question) {
        question.release();
        if (!this.queriesInProgress.isEmpty()) {
            InternetProtocolFamily[] i = this.queriesInProgress.iterator();
            while (i.hasNext()) {
                Future f = (Future)i.next();
                i.remove();
                if (f.cancel(false)) continue;
                f.addListener(RELEASE_RESPONSE);
            }
        }
        if (this.resolvedEntries != null) {
            for (InternetProtocolFamily f : this.resolvedInternetProtocolFamilies) {
                if (!this.finishResolve(f.addressType(), this.resolvedEntries, promise)) continue;
                return;
            }
        }
        int tries = this.maxAllowedQueries - this.allowedQueries;
        StringBuilder buf = new StringBuilder(64);
        buf.append("failed to resolve '").append(this.hostname).append('\'');
        if (tries > 1) {
            if (tries < this.maxAllowedQueries) {
                buf.append(" after ").append(tries).append(" queries ");
            } else {
                buf.append(". Exceeded max queries per resolve ").append(this.maxAllowedQueries).append(' ');
            }
        }
        UnknownHostException cause = new UnknownHostException(buf.toString());
        cause.setStackTrace(new StackTraceElement[0]);
        this.resolveCache.cache(this.hostname, cause, this.parent.ch.eventLoop());
        promise.tryFailure((Throwable)cause);
    }

    abstract boolean finishResolve(Class<? extends InetAddress> var1, List<DnsCacheEntry> var2, Promise<T> var3);

    abstract DnsNameResolverContext<T> newResolverContext(DnsNameResolver var1, String var2, DnsCache var3, DnsServerAddressStream var4);

    private DnsServerAddressStream getNameServers(String hostname) {
        DnsServerAddressStream stream = this.getNameServersFromCache(hostname);
        return stream == null ? this.nameServerAddrs : stream;
    }

    private void followCname(String cname, DnsQueryLifecycleObserver queryLifecycleObserver, Promise<T> promise) {
        DnsServerAddressStream stream = DnsServerAddresses.singleton(this.getNameServers(cname).next()).stream();
        DnsQuestion cnameQuestion = null;
        try {
            if (this.parent.supportsARecords()) {
                cnameQuestion = DnsQuestion.newResolveQuestion(this.hostname, 1, this.parent.isRecursionDesired());
            }
            if (this.parent.supportsAAAARecords()) {
                cnameQuestion = DnsQuestion.newResolveQuestion(this.hostname, 28, this.parent.isRecursionDesired());
            }
        }
        catch (Throwable cause) {
            queryLifecycleObserver.queryFailed(cause);
            PlatformDependent.throwException((Throwable)cause);
        }
        if (cnameQuestion != null) {
            this.resolveQuery(stream, 0, cnameQuestion, queryLifecycleObserver.queryCNAMEd(cnameQuestion), promise);
        }
    }

    private boolean resolveQuery(String hostname, int type, DnsServerAddressStream dnsServerAddressStream, Promise<T> promise) {
        DnsQuestion message = DnsQuestion.newResolveQuestion(hostname, type, this.parent.isRecursionDesired());
        if (message == null) {
            return false;
        }
        this.resolveQuery(dnsServerAddressStream, 0, message, promise);
        return true;
    }

    static final class AuthoritativeNameServer {
        final int dots;
        final String nsName;
        final String domainName;
        AuthoritativeNameServer next;
        boolean removed;

        AuthoritativeNameServer(int dots, String domainName, String nsName) {
            this.dots = dots;
            this.nsName = nsName;
            this.domainName = domainName;
        }

        boolean isRootServer() {
            return this.dots == 1;
        }

        String domainName() {
            return this.domainName;
        }
    }

    private static final class AuthoritativeNameServerList {
        private final String questionName;
        private AuthoritativeNameServer head;
        private int count;

        AuthoritativeNameServerList(String questionName) {
            this.questionName = questionName.toLowerCase(Locale.US);
        }

        void add(DnsRecord record) {
            if (record.getType() != 2) {
                return;
            }
            String recordName = record.getName().toString();
            if (this.questionName.length() < recordName.length()) {
                return;
            }
            int dots = 0;
            int a = recordName.length() - 1;
            int b = this.questionName.length() - 1;
            while (a >= 0) {
                char c = recordName.charAt(a);
                if (this.questionName.charAt(b) != c) {
                    return;
                }
                if (c == '.') {
                    ++dots;
                }
                --a;
                --b;
            }
            if (this.head != null && this.head.dots > dots) {
                return;
            }
            System.err.println("DOUBLE CHECK me! we do things differently now!");
            NSRecord re = (NSRecord)record;
            String domainName = re.getAdditionalName().toString();
            if (domainName == null) {
                return;
            }
            if (this.head == null || this.head.dots < dots) {
                this.count = 1;
                this.head = new AuthoritativeNameServer(dots, recordName, domainName);
            } else if (this.head.dots == dots) {
                AuthoritativeNameServer serverName = this.head;
                while (serverName.next != null) {
                    serverName = serverName.next;
                }
                serverName.next = new AuthoritativeNameServer(dots, recordName, domainName);
                ++this.count;
            }
        }

        AuthoritativeNameServer remove(String nsName) {
            AuthoritativeNameServer serverName = this.head;
            while (serverName != null) {
                if (!serverName.removed && serverName.nsName.equalsIgnoreCase(nsName)) {
                    serverName.removed = true;
                    return serverName;
                }
                serverName = serverName.next;
            }
            return null;
        }

        int size() {
            return this.count;
        }
    }

    private final class DnsCacheIterable
    implements Iterable<InetSocketAddress> {
        private final List<DnsCacheEntry> entries;

        DnsCacheIterable(List<DnsCacheEntry> entries) {
            this.entries = entries;
        }

        @Override
        public Iterator<InetSocketAddress> iterator() {
            return new Iterator<InetSocketAddress>(){
                Iterator<DnsCacheEntry> entryIterator;
                {
                    this.entryIterator = DnsCacheIterable.this.entries.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.entryIterator.hasNext();
                }

                @Override
                public InetSocketAddress next() {
                    InetAddress address = this.entryIterator.next().address();
                    return new InetSocketAddress(address, DnsNameResolverContext.this.parent.dnsRedirectPort(address));
                }

                @Override
                public void remove() {
                    this.entryIterator.remove();
                }
            };
        }
    }

    private static final class SearchDomainUnknownHostException
    extends UnknownHostException {
        SearchDomainUnknownHostException(Throwable cause, String originalHostname) {
            super("Search domain query failed. Original hostname: '" + originalHostname + "' " + cause.getMessage());
            this.setStackTrace(cause.getStackTrace());
        }

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    }
}

