/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network.dns.resolver;

import dorkbox.network.dns.DnsQuestion;
import dorkbox.network.dns.records.DnsMessage;
import io.netty.util.internal.EmptyArrays;
import io.netty.util.internal.ObjectUtil;
import java.net.InetSocketAddress;

public final class DnsNameResolverException
extends RuntimeException {
    private static final long serialVersionUID = -8826717909627131850L;
    private final InetSocketAddress remoteAddress;
    private final DnsQuestion question;

    public DnsNameResolverException(InetSocketAddress remoteAddress, DnsQuestion question, String message) {
        super(message);
        this.remoteAddress = DnsNameResolverException.validateRemoteAddress(remoteAddress);
        this.question = DnsNameResolverException.validateQuestion(question);
    }

    private static InetSocketAddress validateRemoteAddress(InetSocketAddress remoteAddress) {
        return (InetSocketAddress)ObjectUtil.checkNotNull((Object)remoteAddress, (String)"remoteAddress");
    }

    private static DnsQuestion validateQuestion(DnsQuestion question) {
        return (DnsQuestion)ObjectUtil.checkNotNull((Object)question, (String)"question");
    }

    public DnsNameResolverException(InetSocketAddress remoteAddress, DnsQuestion question, String message, Throwable cause) {
        super(message, cause);
        this.remoteAddress = DnsNameResolverException.validateRemoteAddress(remoteAddress);
        this.question = DnsNameResolverException.validateQuestion(question);
    }

    public InetSocketAddress remoteAddress() {
        return this.remoteAddress;
    }

    public DnsMessage question() {
        return this.question;
    }

    @Override
    public Throwable fillInStackTrace() {
        this.setStackTrace(EmptyArrays.EMPTY_STACK_TRACE);
        return this;
    }
}

