/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network.dns.resolver;

import dorkbox.network.dns.resolver.DnsNameResolver;
import dorkbox.network.dns.resolver.DnsNameResolverContext;
import dorkbox.network.dns.resolver.addressProvider.DnsServerAddressStream;
import dorkbox.network.dns.resolver.cache.DnsCache;
import dorkbox.network.dns.resolver.cache.DnsCacheEntry;
import io.netty.util.concurrent.Promise;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;

final class DnsNameResolverListResolverContext
extends DnsNameResolverContext<List<InetAddress>> {
    DnsNameResolverListResolverContext(DnsNameResolver parent, String hostname, DnsCache resolveCache, DnsServerAddressStream nameServerAddrs) {
        super(parent, hostname, resolveCache, nameServerAddrs);
    }

    @Override
    DnsNameResolverContext<List<InetAddress>> newResolverContext(DnsNameResolver parent, String hostname, DnsCache resolveCache, DnsServerAddressStream nameServerAddrs) {
        return new DnsNameResolverListResolverContext(parent, hostname, resolveCache, nameServerAddrs);
    }

    @Override
    boolean finishResolve(Class<? extends InetAddress> addressType, List<DnsCacheEntry> resolvedEntries, Promise<List<InetAddress>> promise) {
        ArrayList<InetAddress> result = null;
        int numEntries = resolvedEntries.size();
        for (int i = 0; i < numEntries; ++i) {
            InetAddress a = resolvedEntries.get(i).address();
            if (!addressType.isInstance(a)) continue;
            if (result == null) {
                result = new ArrayList<InetAddress>(numEntries);
            }
            result.add(a);
        }
        if (result != null) {
            promise.trySuccess(result);
            return true;
        }
        return false;
    }
}

