/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network.dns.resolver;

import dorkbox.network.dns.DnsQuestion;
import dorkbox.network.dns.DnsResponse;
import dorkbox.network.dns.records.DnsRecord;
import dorkbox.network.dns.resolver.DnsNameResolver;
import dorkbox.network.dns.resolver.DnsNameResolverException;
import io.netty.channel.AddressedEnvelope;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelPromise;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;
import io.netty.util.concurrent.ScheduledFuture;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.InetSocketAddress;
import java.util.concurrent.TimeUnit;

final class DnsQueryContext {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(DnsQueryContext.class);
    private final DnsNameResolver parent;
    private final Promise<AddressedEnvelope<DnsResponse, InetSocketAddress>> promise;
    private final int id;
    private final DnsQuestion question;
    private final InetSocketAddress nameServerAddr;
    private volatile ScheduledFuture<?> timeoutFuture;

    DnsQueryContext(DnsNameResolver parent, InetSocketAddress nameServerAddr, DnsQuestion question, Promise<AddressedEnvelope<DnsResponse, InetSocketAddress>> promise) {
        this.parent = (DnsNameResolver)((Object)ObjectUtil.checkNotNull((Object)((Object)parent), (String)"parent"));
        this.nameServerAddr = (InetSocketAddress)ObjectUtil.checkNotNull((Object)nameServerAddr, (String)"nameServerAddr");
        this.question = (DnsQuestion)ObjectUtil.checkNotNull((Object)question, (String)"question");
        this.promise = (Promise)ObjectUtil.checkNotNull(promise, (String)"promise");
        this.id = parent.queryContextManager.add(this);
        question.init(this.id, nameServerAddr);
    }

    void query(ChannelPromise writePromise) {
        DnsQuestion question = this.question();
        InetSocketAddress nameServerAddr = this.nameServerAddr();
        if (logger.isDebugEnabled()) {
            logger.debug("{} WRITE: [{}: {}], {}", new Object[]{this.parent.ch, this.id, nameServerAddr, question});
        }
        this.sendQuery(question, writePromise);
    }

    InetSocketAddress nameServerAddr() {
        return this.nameServerAddr;
    }

    DnsQuestion question() {
        return this.question;
    }

    private void sendQuery(final DnsQuestion query, final ChannelPromise writePromise) {
        if (this.parent.channelFuture.isDone()) {
            this.writeQuery(query, writePromise);
        } else {
            this.parent.channelFuture.addListener((GenericFutureListener)new GenericFutureListener<Future<? super Channel>>(){

                public void operationComplete(Future<? super Channel> future) throws Exception {
                    if (future.isSuccess()) {
                        DnsQueryContext.this.writeQuery(query, writePromise);
                    } else {
                        Throwable cause = future.cause();
                        DnsQueryContext.this.promise.tryFailure(cause);
                        writePromise.setFailure(cause);
                    }
                }
            });
        }
    }

    private void writeQuery(DnsQuestion query, ChannelPromise writePromise) {
        final ChannelFuture writeFuture = this.parent.ch.writeAndFlush((Object)query, writePromise);
        if (writeFuture.isDone()) {
            this.onQueryWriteCompletion(writeFuture);
        } else {
            writeFuture.addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    DnsQueryContext.this.onQueryWriteCompletion(writeFuture);
                }
            });
        }
    }

    private void onQueryWriteCompletion(ChannelFuture writeFuture) {
        if (!writeFuture.isSuccess()) {
            writeFuture.cause().printStackTrace();
            this.setFailure("failed to send a query", writeFuture.cause());
            return;
        }
        final long queryTimeoutMillis = this.parent.queryTimeoutMillis();
        if (queryTimeoutMillis > 0L) {
            this.timeoutFuture = this.parent.ch.eventLoop().schedule(new Runnable(){

                @Override
                public void run() {
                    if (DnsQueryContext.this.promise.isDone()) {
                        return;
                    }
                    DnsQueryContext.this.setFailure("query timed out after " + queryTimeoutMillis + " milliseconds", null);
                }
            }, queryTimeoutMillis, TimeUnit.MILLISECONDS);
        }
    }

    private void setFailure(String message, Throwable cause) {
        InetSocketAddress nameServerAddr = this.nameServerAddr();
        this.parent.queryContextManager.remove(nameServerAddr, this.id);
        StringBuilder buf = new StringBuilder(message.length() + 64);
        buf.append('[').append(nameServerAddr).append("] ").append(message).append(" (no stack trace available)");
        DnsNameResolverException e = cause != null ? new DnsNameResolverException(nameServerAddr, this.question(), buf.toString(), cause) : new DnsNameResolverException(nameServerAddr, this.question(), buf.toString());
        this.promise.tryFailure((Throwable)e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void finish(AddressedEnvelope<DnsResponse, InetSocketAddress> envelope) {
        DnsResponse response = (DnsResponse)envelope.content();
        try {
            DnsRecord[] sectionArray = response.getSectionArray(0);
            if (sectionArray.length != 1) {
                logger.warn("Received a DNS response with invalid number of questions: {}", envelope);
                return;
            }
            DnsRecord[] questionArray = this.question.getSectionArray(0);
            if (questionArray.length != 1) {
                logger.warn("Received a DNS response with invalid number of query questions: {}", envelope);
                return;
            }
            if (!questionArray[0].equals(sectionArray[0])) {
                logger.warn("Received a mismatching DNS response: {}", envelope);
                return;
            }
            this.setSuccess(envelope);
        }
        finally {
            if (this.question.isResolveQuestion()) {
                response.release();
            }
        }
    }

    private void setSuccess(AddressedEnvelope<DnsResponse, InetSocketAddress> envelope) {
        Promise<AddressedEnvelope<DnsResponse, InetSocketAddress>> promise;
        this.parent.queryContextManager.remove(this.nameServerAddr(), this.id);
        ScheduledFuture<?> timeoutFuture = this.timeoutFuture;
        if (timeoutFuture != null) {
            timeoutFuture.cancel(false);
        }
        if ((promise = this.promise).setUncancellable()) {
            AddressedEnvelope castResponse = envelope.retain();
            if (!promise.trySuccess((Object)castResponse)) {
                envelope.release();
            }
            envelope.release();
        }
    }
}

