/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network.dns.resolver;

import dorkbox.network.dns.records.DnsMessage;
import dorkbox.network.dns.resolver.DnsQueryLifecycleObserver;
import io.netty.channel.ChannelFuture;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.logging.InternalLogLevel;
import io.netty.util.internal.logging.InternalLogger;
import java.net.InetSocketAddress;
import java.util.List;

final class TraceDnsQueryLifecycleObserver
implements DnsQueryLifecycleObserver {
    private final InternalLogger logger;
    private final InternalLogLevel level;
    private final DnsMessage question;
    private InetSocketAddress dnsServerAddress;

    TraceDnsQueryLifecycleObserver(DnsMessage question, InternalLogger logger, InternalLogLevel level) {
        this.question = (DnsMessage)ObjectUtil.checkNotNull((Object)question, (String)"question");
        this.logger = (InternalLogger)ObjectUtil.checkNotNull((Object)logger, (String)"logger");
        this.level = (InternalLogLevel)ObjectUtil.checkNotNull((Object)level, (String)"level");
    }

    @Override
    public void queryWritten(InetSocketAddress dnsServerAddress, ChannelFuture future) {
        this.dnsServerAddress = dnsServerAddress;
    }

    @Override
    public void queryCancelled(int queriesRemaining) {
        if (this.dnsServerAddress != null) {
            this.logger.log(this.level, "from {} : {} cancelled with {} queries remaining", new Object[]{this.dnsServerAddress, this.question, queriesRemaining});
        } else {
            this.logger.log(this.level, "{} query never written and cancelled with {} queries remaining", (Object)this.question, (Object)queriesRemaining);
        }
    }

    @Override
    public DnsQueryLifecycleObserver queryRedirected(List<InetSocketAddress> nameServers) {
        this.logger.log(this.level, "from {} : {} redirected", (Object)this.dnsServerAddress, (Object)this.question);
        return this;
    }

    @Override
    public DnsQueryLifecycleObserver queryCNAMEd(DnsMessage cnameQuestion) {
        this.logger.log(this.level, "from {} : {} CNAME question {}", new Object[]{this.dnsServerAddress, this.question, cnameQuestion});
        return this;
    }

    @Override
    public DnsQueryLifecycleObserver queryNoAnswer(int code) {
        this.logger.log(this.level, "from {} : {} no answer {}", new Object[]{this.dnsServerAddress, this.question, code});
        return this;
    }

    @Override
    public void queryFailed(Throwable cause) {
        if (this.dnsServerAddress != null) {
            this.logger.log(this.level, "from {} : {} failure", new Object[]{this.dnsServerAddress, this.question, cause});
        } else {
            this.logger.log(this.level, "{} query never written and failed", (Object)this.question, (Object)cause);
        }
    }

    @Override
    public void querySucceed() {
    }
}

