/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network.dns.serverHandlers;

import dorkbox.network.dns.records.DnsMessage;
import dorkbox.util.NamedThreadFactory;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.oio.OioEventLoopGroup;
import io.netty.channel.socket.DatagramPacket;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.channel.socket.oio.OioDatagramChannel;
import io.netty.util.internal.PlatformDependent;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.ThreadFactory;

@ChannelHandler.Sharable
public class DNSMessageDecoder
extends ChannelInboundHandlerAdapter {
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        block8: {
            if (msg instanceof DatagramPacket) {
                OioEventLoopGroup group;
                ByteBuf content = (ByteBuf)((DatagramPacket)msg).content();
                if (content.readableBytes() == 0) {
                    System.err.println("NO CONTENT ");
                    ctx.fireChannelRead(msg);
                    return;
                }
                DnsMessage msg1 = new DnsMessage(content);
                Bootstrap dnsBootstrap = new Bootstrap();
                SecurityManager s = System.getSecurityManager();
                ThreadGroup nettyGroup = new ThreadGroup(s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup(), "DnsClient (Netty)");
                if (PlatformDependent.isAndroid()) {
                    group = new OioEventLoopGroup(0, (ThreadFactory)new NamedThreadFactory("DnsClient-boss-UDP", nettyGroup));
                    dnsBootstrap.channel(OioDatagramChannel.class);
                } else {
                    group = new NioEventLoopGroup(2, (ThreadFactory)new NamedThreadFactory("DnsClient-boss-UDP", nettyGroup));
                    dnsBootstrap.channel(NioDatagramChannel.class);
                }
                dnsBootstrap.group((EventLoopGroup)group);
                dnsBootstrap.option(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT);
                ChannelFuture future = dnsBootstrap.connect((SocketAddress)new InetSocketAddress("8.8.8.8", 53));
                try {
                    future.await();
                    if (future.isSuccess()) {
                        System.err.println("CONNECTED");
                        break block8;
                    }
                    System.err.println("CANNOT CONNECT!");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                ctx.fireChannelRead(msg);
            }
        }
    }
}

