/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network.pipeline;

import com.esotericsoftware.kryo.KryoException;
import com.esotericsoftware.kryo.io.Input;
import io.netty.buffer.ByteBuf;
import java.io.InputStream;

public class ByteBufInput
extends Input {
    private char[] inputChars = new char[32];
    private ByteBuf byteBuf;
    private int startIndex;

    public ByteBufInput() {
    }

    public ByteBufInput(ByteBuf buffer) {
        this.setBuffer(buffer);
    }

    public final void setBuffer(ByteBuf byteBuf) {
        this.byteBuf = byteBuf;
        this.startIndex = byteBuf != null ? byteBuf.readerIndex() : 0;
    }

    public ByteBuf getByteBuf() {
        return this.byteBuf;
    }

    @Deprecated
    public void setBuffer(byte[] bytes) {
        throw new RuntimeException("Cannot access this method!");
    }

    @Deprecated
    public void setBuffer(byte[] bytes, int offset, int count) {
        throw new RuntimeException("Cannot access this method!");
    }

    @Deprecated
    public byte[] getBuffer() {
        throw new RuntimeException("Cannot access this method!");
    }

    @Deprecated
    public InputStream getInputStream() {
        throw new RuntimeException("Cannot access this method!");
    }

    @Deprecated
    public void setInputStream(InputStream inputStream) {
        throw new RuntimeException("Cannot access this method!");
    }

    public long total() {
        return this.byteBuf.readerIndex() - this.startIndex;
    }

    public int position() {
        return this.byteBuf.readerIndex();
    }

    @Deprecated
    public void setPosition(int position) {
        throw new RuntimeException("Cannot access this method!");
    }

    public int limit() {
        return this.byteBuf.writerIndex();
    }

    @Deprecated
    public void setLimit(int limit) {
        throw new RuntimeException("Cannot access this method!");
    }

    public void rewind() {
        this.byteBuf.readerIndex(this.startIndex);
    }

    public void skip(int count) throws KryoException {
        this.byteBuf.skipBytes(count);
    }

    @Deprecated
    protected int fill(byte[] buffer, int offset, int count) throws KryoException {
        throw new RuntimeException("Cannot access this method!");
    }

    public int read() throws KryoException {
        return this.byteBuf.readByte() & 0xFF;
    }

    public int read(byte[] bytes) throws KryoException {
        int start = this.byteBuf.readerIndex();
        this.byteBuf.readBytes(bytes);
        int end = this.byteBuf.readerIndex();
        return end - start;
    }

    public int read(byte[] bytes, int offset, int count) throws KryoException {
        if (bytes == null) {
            throw new IllegalArgumentException("bytes cannot be null.");
        }
        int start = this.byteBuf.readerIndex();
        this.byteBuf.readBytes(bytes, offset, count);
        int end = this.byteBuf.readerIndex();
        return end - start;
    }

    public long skip(long count) throws KryoException {
        int skip;
        for (long remaining = count; remaining > 0L; remaining -= (long)skip) {
            skip = Math.max(Integer.MAX_VALUE, (int)remaining);
            this.skip(skip);
        }
        return count;
    }

    @Deprecated
    public void close() throws KryoException {
    }

    public byte readByte() throws KryoException {
        return this.byteBuf.readByte();
    }

    public int readByteUnsigned() throws KryoException {
        return this.byteBuf.readUnsignedByte();
    }

    public byte[] readBytes(int length) throws KryoException {
        byte[] bytes = new byte[length];
        this.readBytes(bytes, 0, length);
        return bytes;
    }

    public void readBytes(byte[] bytes) throws KryoException {
        this.readBytes(bytes, 0, bytes.length);
    }

    public void readBytes(byte[] bytes, int offset, int count) throws KryoException {
        if (bytes == null) {
            throw new IllegalArgumentException("bytes cannot be null.");
        }
        this.byteBuf.readBytes(bytes, offset, count);
    }

    public int readInt() throws KryoException {
        return this.byteBuf.readInt();
    }

    public int readInt(boolean optimizePositive) throws KryoException {
        return this.readVarInt(optimizePositive);
    }

    public int readVarInt(boolean optimizePositive) throws KryoException {
        ByteBuf buffer = this.byteBuf;
        byte b = buffer.readByte();
        int result = b & 0x7F;
        if ((b & 0x80) != 0) {
            b = buffer.readByte();
            result |= (b & 0x7F) << 7;
            if ((b & 0x80) != 0) {
                b = buffer.readByte();
                result |= (b & 0x7F) << 14;
                if ((b & 0x80) != 0) {
                    b = buffer.readByte();
                    result |= (b & 0x7F) << 21;
                    if ((b & 0x80) != 0) {
                        b = buffer.readByte();
                        result |= (b & 0x7F) << 28;
                    }
                }
            }
        }
        return optimizePositive ? result : result >>> 1 ^ -(result & 1);
    }

    public boolean canReadInt() throws KryoException {
        ByteBuf buffer = this.byteBuf;
        int limit = buffer.writerIndex();
        if (limit - buffer.readerIndex() >= 5) {
            return true;
        }
        if ((buffer.readByte() & 0x80) == 0) {
            return true;
        }
        if (buffer.readerIndex() == limit) {
            return false;
        }
        if ((buffer.readByte() & 0x80) == 0) {
            return true;
        }
        if (buffer.readerIndex() == limit) {
            return false;
        }
        if ((buffer.readByte() & 0x80) == 0) {
            return true;
        }
        if (buffer.readerIndex() == limit) {
            return false;
        }
        if ((buffer.readByte() & 0x80) == 0) {
            return true;
        }
        return buffer.readerIndex() != limit;
    }

    public boolean canReadLong() throws KryoException {
        ByteBuf buffer = this.byteBuf;
        int limit = buffer.writerIndex();
        if (limit - buffer.readerIndex() >= 9) {
            return true;
        }
        if ((buffer.readByte() & 0x80) == 0) {
            return true;
        }
        if (buffer.readerIndex() == limit) {
            return false;
        }
        if ((buffer.readByte() & 0x80) == 0) {
            return true;
        }
        if (buffer.readerIndex() == limit) {
            return false;
        }
        if ((buffer.readByte() & 0x80) == 0) {
            return true;
        }
        if (buffer.readerIndex() == limit) {
            return false;
        }
        if ((buffer.readByte() & 0x80) == 0) {
            return true;
        }
        if (buffer.readerIndex() == limit) {
            return false;
        }
        if ((buffer.readByte() & 0x80) == 0) {
            return true;
        }
        if (buffer.readerIndex() == limit) {
            return false;
        }
        if ((buffer.readByte() & 0x80) == 0) {
            return true;
        }
        if (buffer.readerIndex() == limit) {
            return false;
        }
        if ((buffer.readByte() & 0x80) == 0) {
            return true;
        }
        if (buffer.readerIndex() == limit) {
            return false;
        }
        if ((buffer.readByte() & 0x80) == 0) {
            return true;
        }
        return buffer.readerIndex() != limit;
    }

    public String readString() {
        ByteBuf buffer = this.byteBuf;
        byte b = buffer.readByte();
        if ((b & 0x80) == 0) {
            return this.readAscii();
        }
        int charCount = this.readUtf8Length(b);
        switch (charCount) {
            case 0: {
                return null;
            }
            case 1: {
                return "";
            }
        }
        if (this.inputChars.length < --charCount) {
            this.inputChars = new char[charCount];
        }
        this.readUtf8(charCount);
        return new String(this.inputChars, 0, charCount);
    }

    private int readUtf8Length(int b) {
        int result = b & 0x3F;
        if ((b & 0x40) != 0) {
            ByteBuf buffer = this.byteBuf;
            b = buffer.readByte();
            result |= (b & 0x7F) << 6;
            if ((b & 0x80) != 0) {
                b = buffer.readByte();
                result |= (b & 0x7F) << 13;
                if ((b & 0x80) != 0) {
                    b = buffer.readByte();
                    result |= (b & 0x7F) << 20;
                    if ((b & 0x80) != 0) {
                        b = buffer.readByte();
                        result |= (b & 0x7F) << 27;
                    }
                }
            }
        }
        return result;
    }

    private void readUtf8(int charCount) {
        ByteBuf buffer = this.byteBuf;
        char[] chars = this.inputChars;
        int charIndex = 0;
        int count = charCount;
        while (charIndex < count) {
            byte b = buffer.readByte();
            if (b < 0) {
                buffer.readerIndex(buffer.readerIndex() - 1);
                break;
            }
            chars[charIndex++] = (char)b;
        }
        if (charIndex < charCount) {
            this.readUtf8_slow(charCount, charIndex);
        }
    }

    private void readUtf8_slow(int charCount, int charIndex) {
        ByteBuf buffer = this.byteBuf;
        char[] chars = this.inputChars;
        while (charIndex < charCount) {
            int b = buffer.readByte() & 0xFF;
            switch (b >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    chars[charIndex] = (char)b;
                    break;
                }
                case 12: 
                case 13: {
                    chars[charIndex] = (char)((b & 0x1F) << 6 | buffer.readByte() & 0x3F);
                    break;
                }
                case 14: {
                    chars[charIndex] = (char)((b & 0xF) << 12 | (buffer.readByte() & 0x3F) << 6 | buffer.readByte() & 0x3F);
                }
            }
            ++charIndex;
        }
    }

    private String readAscii() {
        byte b;
        ByteBuf buffer = this.byteBuf;
        int start = buffer.readerIndex() - 1;
        while (((b = buffer.readByte()) & 0x80) == 0) {
        }
        int i = buffer.readerIndex() - 1;
        buffer.setByte(i, buffer.getByte(i) & 0x7F);
        int capp = buffer.readerIndex() - start;
        byte[] ba = new byte[capp];
        buffer.getBytes(start, ba);
        String value = new String(ba, 0, 0, capp);
        buffer.setByte(i, buffer.getByte(i) | 0x80);
        return value;
    }

    public StringBuilder readStringBuilder() {
        ByteBuf buffer = this.byteBuf;
        byte b = buffer.readByte();
        if ((b & 0x80) == 0) {
            return new StringBuilder(this.readAscii());
        }
        int charCount = this.readUtf8Length(b);
        switch (charCount) {
            case 0: {
                return null;
            }
            case 1: {
                return new StringBuilder("");
            }
        }
        if (this.inputChars.length < --charCount) {
            this.inputChars = new char[charCount];
        }
        this.readUtf8(charCount);
        StringBuilder builder = new StringBuilder(charCount);
        builder.append(this.inputChars, 0, charCount);
        return builder;
    }

    public float readFloat() throws KryoException {
        return Float.intBitsToFloat(this.readInt());
    }

    public float readFloat(float precision, boolean optimizePositive) throws KryoException {
        return (float)this.readInt(optimizePositive) / precision;
    }

    public short readShort() throws KryoException {
        return this.byteBuf.readShort();
    }

    public int readShortUnsigned() throws KryoException {
        return this.byteBuf.readUnsignedShort();
    }

    public long readLong() throws KryoException {
        return this.byteBuf.readLong();
    }

    public long readLong(boolean optimizePositive) throws KryoException {
        ByteBuf buffer = this.byteBuf;
        byte b = buffer.readByte();
        long result = b & 0x7F;
        if ((b & 0x80) != 0) {
            b = buffer.readByte();
            result |= (long)((b & 0x7F) << 7);
            if ((b & 0x80) != 0) {
                b = buffer.readByte();
                result |= (long)((b & 0x7F) << 14);
                if ((b & 0x80) != 0) {
                    b = buffer.readByte();
                    result |= (long)((b & 0x7F) << 21);
                    if ((b & 0x80) != 0) {
                        b = buffer.readByte();
                        result |= (long)(b & 0x7F) << 28;
                        if ((b & 0x80) != 0) {
                            b = buffer.readByte();
                            result |= (long)(b & 0x7F) << 35;
                            if ((b & 0x80) != 0) {
                                b = buffer.readByte();
                                result |= (long)(b & 0x7F) << 42;
                                if ((b & 0x80) != 0) {
                                    b = buffer.readByte();
                                    result |= (long)(b & 0x7F) << 49;
                                    if ((b & 0x80) != 0) {
                                        b = buffer.readByte();
                                        result |= (long)b << 56;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        if (!optimizePositive) {
            result = result >>> 1 ^ -(result & 1L);
        }
        return result;
    }

    public boolean readBoolean() throws KryoException {
        return this.byteBuf.readBoolean();
    }

    public char readChar() throws KryoException {
        return this.byteBuf.readChar();
    }

    public double readDouble() throws KryoException {
        return Double.longBitsToDouble(this.readLong());
    }

    public double readDouble(double precision, boolean optimizePositive) throws KryoException {
        return (double)this.readLong(optimizePositive) / precision;
    }
}

