/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network.pipeline;

import com.esotericsoftware.kryo.KryoException;
import com.esotericsoftware.kryo.io.Output;
import io.netty.buffer.ByteBuf;
import java.io.OutputStream;

public class ByteBufOutput
extends Output {
    private ByteBuf byteBuf;
    private int startIndex;

    public ByteBufOutput() {
    }

    public ByteBufOutput(ByteBuf buffer) {
        this.setBuffer(buffer);
    }

    public final void setBuffer(ByteBuf byteBuf) {
        this.byteBuf = byteBuf;
        if (byteBuf != null) {
            this.byteBuf.readerIndex(0);
            this.startIndex = byteBuf.writerIndex();
        } else {
            this.startIndex = 0;
        }
    }

    public ByteBuf getByteBuf() {
        return this.byteBuf;
    }

    @Deprecated
    public OutputStream getOutputStream() {
        throw new RuntimeException("Cannot access this method!");
    }

    @Deprecated
    public void setOutputStream(OutputStream outputStream) {
        throw new RuntimeException("Cannot access this method!");
    }

    @Deprecated
    public void setBuffer(byte[] buffer) {
        throw new RuntimeException("Cannot access this method!");
    }

    @Deprecated
    public void setBuffer(byte[] buffer, int maxBufferSize) {
        throw new RuntimeException("Cannot access this method!");
    }

    @Deprecated
    public byte[] getBuffer() {
        throw new RuntimeException("Cannot access this method!");
    }

    @Deprecated
    public byte[] toBytes() {
        throw new RuntimeException("Cannot access this method!");
    }

    public int position() {
        return this.byteBuf.writerIndex();
    }

    @Deprecated
    public void setPosition(int position) {
        throw new RuntimeException("Cannot access this method!");
    }

    public long total() {
        return this.byteBuf.writerIndex() - this.startIndex;
    }

    public void clear() {
        this.byteBuf.readerIndex(0);
        this.byteBuf.writerIndex(this.startIndex);
    }

    @Deprecated
    public void flush() throws KryoException {
    }

    @Deprecated
    public void close() throws KryoException {
    }

    public void write(int value) throws KryoException {
        this.byteBuf.writeByte(value);
    }

    public void write(byte[] bytes) throws KryoException {
        if (bytes == null) {
            throw new IllegalArgumentException("bytes cannot be null.");
        }
        this.writeBytes(bytes, 0, bytes.length);
    }

    public void write(byte[] bytes, int offset, int length) throws KryoException {
        this.writeBytes(bytes, offset, length);
    }

    public void writeByte(byte value) throws KryoException {
        this.byteBuf.writeByte((int)value);
    }

    public void writeByte(int value) throws KryoException {
        this.byteBuf.writeByte((int)((byte)value));
    }

    public void writeBytes(byte[] bytes) throws KryoException {
        if (bytes == null) {
            throw new IllegalArgumentException("bytes cannot be null.");
        }
        this.writeBytes(bytes, 0, bytes.length);
    }

    public void writeBytes(byte[] bytes, int offset, int count) throws KryoException {
        if (bytes == null) {
            throw new IllegalArgumentException("bytes cannot be null.");
        }
        this.byteBuf.writeBytes(bytes, offset, count);
    }

    public void writeInt(int value) throws KryoException {
        this.byteBuf.writeInt(value);
    }

    public int writeInt(int value, boolean optimizePositive) throws KryoException {
        return this.writeVarInt(value, optimizePositive);
    }

    public int writeVarInt(int value, boolean optimizePositive) throws KryoException {
        ByteBuf buffer = this.byteBuf;
        if (!optimizePositive) {
            value = value << 1 ^ value >> 31;
        }
        if (value >>> 7 == 0) {
            buffer.writeByte((int)((byte)value));
            return 1;
        }
        if (value >>> 14 == 0) {
            buffer.writeByte((int)((byte)(value & 0x7F | 0x80)));
            buffer.writeByte((int)((byte)(value >>> 7)));
            return 2;
        }
        if (value >>> 21 == 0) {
            buffer.writeByte((int)((byte)(value & 0x7F | 0x80)));
            buffer.writeByte((int)((byte)(value >>> 7 | 0x80)));
            buffer.writeByte((int)((byte)(value >>> 14)));
            return 3;
        }
        if (value >>> 28 == 0) {
            buffer.writeByte((int)((byte)(value & 0x7F | 0x80)));
            buffer.writeByte((int)((byte)(value >>> 7 | 0x80)));
            buffer.writeByte((int)((byte)(value >>> 14 | 0x80)));
            buffer.writeByte((int)((byte)(value >>> 21)));
            return 4;
        }
        buffer.writeByte((int)((byte)(value & 0x7F | 0x80)));
        buffer.writeByte((int)((byte)(value >>> 7 | 0x80)));
        buffer.writeByte((int)((byte)(value >>> 14 | 0x80)));
        buffer.writeByte((int)((byte)(value >>> 21 | 0x80)));
        buffer.writeByte((int)((byte)(value >>> 28)));
        return 5;
    }

    public void writeString(String value) throws KryoException {
        char c;
        int charIndex;
        ByteBuf buffer;
        if (value == null) {
            this.writeByte(128);
            return;
        }
        int charCount = value.length();
        if (charCount == 0) {
            this.writeByte(129);
            return;
        }
        boolean ascii = false;
        if (charCount > 1 && charCount < 64) {
            ascii = true;
            for (int i = 0; i < charCount; ++i) {
                char c2 = value.charAt(i);
                if (c2 <= '\u007f') continue;
                ascii = false;
                break;
            }
        }
        if ((buffer = this.byteBuf).writableBytes() < charCount) {
            buffer.capacity(buffer.capacity() + charCount + 1);
        }
        if (!ascii) {
            this.writeUtf8Length(charCount + 1);
        }
        for (charIndex = 0; charIndex < charCount && (c = value.charAt(charIndex)) <= '\u007f'; ++charIndex) {
            buffer.writeByte((int)((byte)c));
        }
        if (charIndex < charCount) {
            this.writeString_slow(value, charCount, charIndex);
        } else if (ascii) {
            int i = buffer.writerIndex() - 1;
            buffer.setByte(i, buffer.getByte(i) | 0x80);
        }
    }

    public void writeString(CharSequence value) throws KryoException {
        char c;
        int charIndex;
        if (value == null) {
            this.writeByte(128);
            return;
        }
        int charCount = value.length();
        if (charCount == 0) {
            this.writeByte(129);
            return;
        }
        this.writeUtf8Length(charCount + 1);
        ByteBuf buffer = this.byteBuf;
        if (buffer.writableBytes() < charCount) {
            buffer.capacity(buffer.capacity() + charCount + 1);
        }
        for (charIndex = 0; charIndex < charCount && (c = value.charAt(charIndex)) <= '\u007f'; ++charIndex) {
            buffer.writeByte((int)((byte)c));
        }
        if (charIndex < charCount) {
            this.writeString_slow(value, charCount, charIndex);
        }
    }

    public void writeAscii(String value) throws KryoException {
        if (value == null) {
            this.writeByte(128);
            return;
        }
        int charCount = value.length();
        if (charCount == 0) {
            this.writeByte(129);
            return;
        }
        ByteBuf buffer = this.byteBuf;
        if (buffer.writableBytes() < charCount) {
            buffer.capacity(buffer.capacity() + charCount + 1);
        }
        for (int charIndex = 0; charIndex < charCount; ++charIndex) {
            char c = value.charAt(charIndex);
            buffer.writeByte((int)((byte)c));
        }
        int i = buffer.writerIndex() - 1;
        buffer.setByte(i, buffer.getByte(i) | 0x80);
    }

    private void writeUtf8Length(int value) {
        if (value >>> 6 == 0) {
            this.byteBuf.writeByte((int)((byte)(value | 0x80)));
        } else if (value >>> 13 == 0) {
            ByteBuf buffer = this.byteBuf;
            buffer.writeByte((int)((byte)(value | 0x40 | 0x80)));
            buffer.writeByte((int)((byte)(value >>> 6)));
        } else if (value >>> 20 == 0) {
            ByteBuf buffer = this.byteBuf;
            buffer.writeByte((int)((byte)(value | 0x40 | 0x80)));
            buffer.writeByte((int)((byte)(value >>> 6 | 0x80)));
            buffer.writeByte((int)((byte)(value >>> 13)));
        } else if (value >>> 27 == 0) {
            ByteBuf buffer = this.byteBuf;
            buffer.writeByte((int)((byte)(value | 0x40 | 0x80)));
            buffer.writeByte((int)((byte)(value >>> 6 | 0x80)));
            buffer.writeByte((int)((byte)(value >>> 13 | 0x80)));
            buffer.writeByte((int)((byte)(value >>> 20)));
        } else {
            ByteBuf buffer = this.byteBuf;
            buffer.writeByte((int)((byte)(value | 0x40 | 0x80)));
            buffer.writeByte((int)((byte)(value >>> 6 | 0x80)));
            buffer.writeByte((int)((byte)(value >>> 13 | 0x80)));
            buffer.writeByte((int)((byte)(value >>> 20 | 0x80)));
            buffer.writeByte((int)((byte)(value >>> 27)));
        }
    }

    private void writeString_slow(CharSequence value, int charCount, int charIndex) {
        ByteBuf buffer = this.byteBuf;
        while (charIndex < charCount) {
            char c = value.charAt(charIndex);
            if (c <= '\u007f') {
                buffer.writeByte((int)((byte)c));
            } else if (c > '\u07ff') {
                buffer.writeByte((int)((byte)(0xE0 | c >> 12 & 0xF)));
                buffer.writeByte((int)((byte)(0x80 | c >> 6 & 0x3F)));
                buffer.writeByte((int)((byte)(0x80 | c & 0x3F)));
            } else {
                buffer.writeByte((int)((byte)(0xC0 | c >> 6 & 0x1F)));
                buffer.writeByte((int)((byte)(0x80 | c & 0x3F)));
            }
            ++charIndex;
        }
    }

    public void writeFloat(float value) throws KryoException {
        this.writeInt(Float.floatToIntBits(value));
    }

    public int writeFloat(float value, float precision, boolean optimizePositive) throws KryoException {
        return this.writeInt((int)(value * precision), optimizePositive);
    }

    public void writeShort(int value) throws KryoException {
        this.byteBuf.writeShort(value);
    }

    public void writeLong(long value) throws KryoException {
        this.byteBuf.writeLong(value);
    }

    public int writeLong(long value, boolean optimizePositive) throws KryoException {
        return this.writeVarLong(value, optimizePositive);
    }

    public int writeVarLong(long value, boolean optimizePositive) throws KryoException {
        if (!optimizePositive) {
            value = value << 1 ^ value >> 63;
        }
        if (value >>> 7 == 0L) {
            this.byteBuf.writeByte((int)((byte)value));
            return 1;
        }
        if (value >>> 14 == 0L) {
            ByteBuf buffer = this.byteBuf;
            buffer.writeByte((int)((byte)(value & 0x7FL | 0x80L)));
            buffer.writeByte((int)((byte)(value >>> 7)));
            return 2;
        }
        if (value >>> 21 == 0L) {
            ByteBuf buffer = this.byteBuf;
            buffer.writeByte((int)((byte)(value & 0x7FL | 0x80L)));
            buffer.writeByte((int)((byte)(value >>> 7 | 0x80L)));
            buffer.writeByte((int)((byte)(value >>> 14)));
            return 3;
        }
        if (value >>> 28 == 0L) {
            ByteBuf buffer = this.byteBuf;
            buffer.writeByte((int)((byte)(value & 0x7FL | 0x80L)));
            buffer.writeByte((int)((byte)(value >>> 7 | 0x80L)));
            buffer.writeByte((int)((byte)(value >>> 14 | 0x80L)));
            buffer.writeByte((int)((byte)(value >>> 21)));
            return 4;
        }
        if (value >>> 35 == 0L) {
            ByteBuf buffer = this.byteBuf;
            buffer.writeByte((int)((byte)(value & 0x7FL | 0x80L)));
            buffer.writeByte((int)((byte)(value >>> 7 | 0x80L)));
            buffer.writeByte((int)((byte)(value >>> 14 | 0x80L)));
            buffer.writeByte((int)((byte)(value >>> 21 | 0x80L)));
            buffer.writeByte((int)((byte)(value >>> 28)));
            return 5;
        }
        if (value >>> 42 == 0L) {
            ByteBuf buffer = this.byteBuf;
            buffer.writeByte((int)((byte)(value & 0x7FL | 0x80L)));
            buffer.writeByte((int)((byte)(value >>> 7 | 0x80L)));
            buffer.writeByte((int)((byte)(value >>> 14 | 0x80L)));
            buffer.writeByte((int)((byte)(value >>> 21 | 0x80L)));
            buffer.writeByte((int)((byte)(value >>> 28 | 0x80L)));
            buffer.writeByte((int)((byte)(value >>> 35)));
            return 6;
        }
        if (value >>> 49 == 0L) {
            ByteBuf buffer = this.byteBuf;
            buffer.writeByte((int)((byte)(value & 0x7FL | 0x80L)));
            buffer.writeByte((int)((byte)(value >>> 7 | 0x80L)));
            buffer.writeByte((int)((byte)(value >>> 14 | 0x80L)));
            buffer.writeByte((int)((byte)(value >>> 21 | 0x80L)));
            buffer.writeByte((int)((byte)(value >>> 28 | 0x80L)));
            buffer.writeByte((int)((byte)(value >>> 35 | 0x80L)));
            buffer.writeByte((int)((byte)(value >>> 42)));
            return 7;
        }
        if (value >>> 56 == 0L) {
            ByteBuf buffer = this.byteBuf;
            buffer.writeByte((int)((byte)(value & 0x7FL | 0x80L)));
            buffer.writeByte((int)((byte)(value >>> 7 | 0x80L)));
            buffer.writeByte((int)((byte)(value >>> 14 | 0x80L)));
            buffer.writeByte((int)((byte)(value >>> 21 | 0x80L)));
            buffer.writeByte((int)((byte)(value >>> 28 | 0x80L)));
            buffer.writeByte((int)((byte)(value >>> 35 | 0x80L)));
            buffer.writeByte((int)((byte)(value >>> 42 | 0x80L)));
            buffer.writeByte((int)((byte)(value >>> 49)));
            return 8;
        }
        ByteBuf buffer = this.byteBuf;
        buffer.writeByte((int)((byte)(value & 0x7FL | 0x80L)));
        buffer.writeByte((int)((byte)(value >>> 7 | 0x80L)));
        buffer.writeByte((int)((byte)(value >>> 14 | 0x80L)));
        buffer.writeByte((int)((byte)(value >>> 21 | 0x80L)));
        buffer.writeByte((int)((byte)(value >>> 28 | 0x80L)));
        buffer.writeByte((int)((byte)(value >>> 35 | 0x80L)));
        buffer.writeByte((int)((byte)(value >>> 42 | 0x80L)));
        buffer.writeByte((int)((byte)(value >>> 49 | 0x80L)));
        buffer.writeByte((int)((byte)(value >>> 56)));
        return 9;
    }

    public void writeBoolean(boolean value) throws KryoException {
        this.byteBuf.writeBoolean(value);
    }

    public void writeChar(char value) throws KryoException {
        this.byteBuf.writeChar((int)value);
    }

    public void writeDouble(double value) throws KryoException {
        this.writeLong(Double.doubleToLongBits(value));
    }

    public int writeDouble(double value, double precision, boolean optimizePositive) throws KryoException {
        return this.writeLong((long)(value * precision), optimizePositive);
    }

    public static int intLength(int value, boolean optimizePositive) {
        if (!optimizePositive) {
            value = value << 1 ^ value >> 31;
        }
        if (value >>> 7 == 0) {
            return 1;
        }
        if (value >>> 14 == 0) {
            return 2;
        }
        if (value >>> 21 == 0) {
            return 3;
        }
        if (value >>> 28 == 0) {
            return 4;
        }
        return 5;
    }

    public static int longLength(long value, boolean optimizePositive) {
        if (!optimizePositive) {
            value = value << 1 ^ value >> 63;
        }
        if (value >>> 7 == 0L) {
            return 1;
        }
        if (value >>> 14 == 0L) {
            return 2;
        }
        if (value >>> 21 == 0L) {
            return 3;
        }
        if (value >>> 28 == 0L) {
            return 4;
        }
        if (value >>> 35 == 0L) {
            return 5;
        }
        if (value >>> 42 == 0L) {
            return 6;
        }
        if (value >>> 49 == 0L) {
            return 7;
        }
        if (value >>> 56 == 0L) {
            return 8;
        }
        return 9;
    }
}

