/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network.pipeline;

import dorkbox.network.util.CryptoSerializationManager;
import dorkbox.util.bytes.OptimizeUtilsByteBuf;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.io.IOException;
import java.util.List;

public class KryoDecoder
extends ByteToMessageDecoder {
    private final CryptoSerializationManager serializationManager;

    public KryoDecoder(CryptoSerializationManager serializationManager) {
        this.serializationManager = serializationManager;
    }

    protected Object readObject(CryptoSerializationManager serializationManager, ChannelHandlerContext context, ByteBuf in, int length) throws IOException {
        return serializationManager.read(in, length);
    }

    protected void decode(ChannelHandlerContext context, ByteBuf in, List<Object> out) throws Exception {
        int lengthLength = OptimizeUtilsByteBuf.canReadInt(in);
        int readableBytes = in.readableBytes();
        if (lengthLength == 0 || readableBytes < 2 || readableBytes < lengthLength) {
            return;
        }
        int writerIndex = in.writerIndex();
        in.markReaderIndex();
        int length = OptimizeUtilsByteBuf.readInt(in, true);
        readableBytes = in.readableBytes();
        if (length == 0) {
            context.fireExceptionCaught((Throwable)new IllegalStateException("KryoDecoder had a read length of 0"));
            return;
        }
        CryptoSerializationManager serializationManager = this.serializationManager;
        if (length > readableBytes) {
            in.resetReaderIndex();
        } else if (readableBytes > length) {
            int objectCount = 1;
            int endOfObjectPosition = in.readerIndex() + length;
            in.readerIndex(endOfObjectPosition);
            while (readableBytes > 0 && OptimizeUtilsByteBuf.canReadInt(in) > 0 && (length = OptimizeUtilsByteBuf.readInt(in, true)) > 0 && (endOfObjectPosition = in.readerIndex() + length) <= writerIndex) {
                in.readerIndex(endOfObjectPosition);
                readableBytes = in.readableBytes();
                ++objectCount;
            }
            in.resetReaderIndex();
            for (int i = 0; i < objectCount; ++i) {
                length = OptimizeUtilsByteBuf.readInt(in, true);
                try {
                    Object object = this.readObject(serializationManager, context, in, length);
                    out.add(object);
                    continue;
                }
                catch (Exception ex) {
                    context.fireExceptionCaught((Throwable)new IOException("Unable to deserialize object!", ex));
                }
            }
        } else {
            try {
                Object object = this.readObject(serializationManager, context, in, length);
                out.add(object);
            }
            catch (Exception ex) {
                context.fireExceptionCaught((Throwable)new IOException("Unable to deserialize object!", ex));
            }
        }
    }
}

