/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network.pipeline;

import dorkbox.network.util.CryptoSerializationManager;
import dorkbox.util.bytes.OptimizeUtilsByteBuf;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import java.io.IOException;

@ChannelHandler.Sharable
public class KryoEncoder
extends MessageToByteEncoder<Object> {
    private static final int reservedLengthIndex = 5;
    private final CryptoSerializationManager serializationManager;

    public KryoEncoder(CryptoSerializationManager serializationManager) {
        super(false);
        this.serializationManager = serializationManager;
    }

    protected void writeObject(CryptoSerializationManager kryoWrapper, ChannelHandlerContext context, Object msg, ByteBuf buffer) throws IOException {
        kryoWrapper.write(buffer, msg);
    }

    protected void encode(ChannelHandlerContext context, Object msg, ByteBuf out) throws Exception {
        int startIndex = out.writerIndex() + 5;
        if (msg != null) {
            out.writerIndex(startIndex);
            try {
                this.writeObject(this.serializationManager, context, msg, out);
                int index = out.writerIndex();
                int length = index - startIndex;
                int lengthOfTheLength = OptimizeUtilsByteBuf.intLength(length, true);
                int indexForLength = startIndex - lengthOfTheLength;
                out.writerIndex(indexForLength);
                OptimizeUtilsByteBuf.writeInt(out, length, true);
                out.setIndex(indexForLength, index);
            }
            catch (Exception ex) {
                context.fireExceptionCaught((Throwable)new IOException("Unable to serialize object of type: " + msg.getClass().getName(), ex));
            }
        }
    }
}

