/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network.pipeline;

import dorkbox.network.connection.ConnectionImpl;
import dorkbox.network.pipeline.LocalRmiClassEncoder;
import dorkbox.network.pipeline.RmiFieldCache;
import dorkbox.network.rmi.RemoteObject;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageDecoder;
import java.lang.reflect.Field;
import java.util.List;

public class LocalRmiDecoder
extends MessageToMessageDecoder<Object> {
    private static final RmiFieldCache fieldCache = RmiFieldCache.INSTANCE();

    protected void decode(ChannelHandlerContext context, Object msg, List<Object> out) throws Exception {
        if (msg instanceof LocalRmiClassEncoder) {
            LocalRmiClassEncoder encoded = (LocalRmiClassEncoder)msg;
            Object messageObject = encoded.rmiObject;
            int[] rmiFieldIds = encoded.rmiFieldIds;
            Class<?> messageClass = messageObject.getClass();
            ConnectionImpl connection = (ConnectionImpl)context.pipeline().last();
            Object localRmiObject = null;
            Field[] rmiFields = fieldCache.get(messageClass);
            for (int i = 0; i < rmiFields.length; ++i) {
                Field field = rmiFields[i];
                int registeredId = rmiFieldIds[i];
                if (registeredId == 0) continue;
                try {
                    localRmiObject = field.get(messageObject);
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                if (localRmiObject == null) {
                    throw new RuntimeException("Unable to get RMI interface object for RMI implementation");
                }
                Class<?> iface = connection.getEndPoint().getSerialization().getRmiIface(localRmiObject.getClass());
                if (iface == null) {
                    throw new RuntimeException("Unable to get interface for RMI implementation");
                }
                RemoteObject remoteObject = connection.getProxyObject(registeredId, iface);
                field.set(messageObject, remoteObject);
            }
            out.add(messageObject);
        } else {
            out.add(msg);
        }
    }
}

