/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network.pipeline;

import dorkbox.network.connection.ConnectionImpl;
import dorkbox.network.connection.EndPointBase;
import dorkbox.network.pipeline.LocalRmiClassEncoder;
import dorkbox.network.pipeline.RmiFieldCache;
import dorkbox.network.rmi.Rmi;
import dorkbox.util.FastThreadLocal;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageEncoder;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;

@ChannelHandler.Sharable
public class LocalRmiEncoder
extends MessageToMessageEncoder<Object> {
    private static final Map<Class<?>, Boolean> transformObjectCache = new ConcurrentHashMap(EndPointBase.DEFAULT_THREAD_POOL_SIZE);
    private static final RmiFieldCache fieldCache = RmiFieldCache.INSTANCE();
    private final FastThreadLocal<Map<Object, Integer>> objectThreadLocals = new FastThreadLocal<Map<Object, Integer>>(){

        @Override
        public Map<Object, Integer> initialValue() {
            return new WeakHashMap<Object, Integer>(8);
        }
    };

    protected void encode(ChannelHandlerContext context, Object msg, List<Object> out) throws Exception {
        Class<?> implClass = msg.getClass();
        Boolean needsTransform = transformObjectCache.get(implClass);
        if (needsTransform == null) {
            boolean hasRmi;
            boolean bl = hasRmi = implClass.getAnnotation(Rmi.class) != null;
            if (hasRmi) {
                ConnectionImpl connection = (ConnectionImpl)context.pipeline().last();
                out.add(this.replaceFieldObjects(connection, msg, implClass));
            } else {
                transformObjectCache.put(implClass, Boolean.FALSE);
                out.add(msg);
            }
        } else if (needsTransform.booleanValue()) {
            ConnectionImpl connection = (ConnectionImpl)context.pipeline().last();
            out.add(this.replaceFieldObjects(connection, msg, implClass));
        } else {
            out.add(msg);
        }
    }

    private Object replaceFieldObjects(ConnectionImpl connection, Object object, Class<?> implClass) {
        Field[] rmiFields = fieldCache.get(implClass);
        int length = rmiFields.length;
        Object rmiObject = null;
        int[] rmiFieldIds = new int[length];
        for (int i = 0; i < length; ++i) {
            Map<Object, Integer> localWeakCache;
            Integer id;
            Field field = rmiFields[i];
            try {
                rmiObject = field.get(object);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            if (rmiObject == null) {
                rmiFieldIds[i] = 0;
            }
            if ((id = (localWeakCache = this.objectThreadLocals.get()).get(rmiObject)) == null) {
                int registeredId;
                rmiFieldIds[i] = registeredId = connection.getRegisteredId(rmiObject);
                localWeakCache.put(rmiObject, registeredId);
                continue;
            }
            rmiFieldIds[i] = id;
        }
        LocalRmiClassEncoder localRmiClassEncoder = new LocalRmiClassEncoder();
        localRmiClassEncoder.rmiObject = object;
        localRmiClassEncoder.rmiFieldIds = rmiFieldIds;
        return localRmiClassEncoder;
    }
}

