/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network.pipeline;

import com.esotericsoftware.kryo.util.IdentityMap;
import dorkbox.network.rmi.Rmi;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

class RmiFieldCache {
    private volatile IdentityMap<Class<?>, Field[]> fieldCache = new IdentityMap();
    private static final AtomicReferenceFieldUpdater<RmiFieldCache, IdentityMap> rmiFieldsREF = AtomicReferenceFieldUpdater.newUpdater(RmiFieldCache.class, IdentityMap.class, "fieldCache");
    private static final RmiFieldCache INSTANCE = new RmiFieldCache();

    public static synchronized RmiFieldCache INSTANCE() {
        return INSTANCE;
    }

    private RmiFieldCache() {
    }

    Field[] get(Class<?> clazz) {
        IdentityMap identityMap = rmiFieldsREF.get(this);
        Field[] rmiFields = (Field[])identityMap.get(clazz);
        if (rmiFields != null) {
            return rmiFields;
        }
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Field field : clazz.getDeclaredFields()) {
            if (field.getAnnotation(Rmi.class) == null) continue;
            fields.add(field);
        }
        rmiFields = new Field[fields.size()];
        fields.toArray(rmiFields);
        this.fieldCache.put(clazz, (Object)rmiFields);
        return rmiFields;
    }
}

