/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network.pipeline.udp;

import dorkbox.network.connection.CryptoSerializationManager;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.socket.DatagramPacket;
import io.netty.handler.codec.MessageToMessageDecoder;
import java.io.IOException;
import java.util.List;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class KryoDecoderUdp
extends MessageToMessageDecoder<DatagramPacket> {
    private final dorkbox.network.util.CryptoSerializationManager serializationManager;

    public KryoDecoderUdp(dorkbox.network.util.CryptoSerializationManager serializationManager) {
        this.serializationManager = serializationManager;
    }

    protected void decode(ChannelHandlerContext ctx, DatagramPacket msg, List<Object> out) throws Exception {
        ByteBuf data;
        if (msg != null && (data = (ByteBuf)msg.content()) != null) {
            if (CryptoSerializationManager.isEncrypted(data)) {
                String message = "Encrypted UDP packet received before registration complete.";
                LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error(message);
                throw new IOException(message);
            }
            try {
                Object read = this.serializationManager.read(data, data.writerIndex());
                out.add(read);
            }
            catch (IOException e) {
                String message = "Unable to deserialize object";
                LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error(message, (Throwable)e);
                throw new IOException(message, e);
            }
        }
    }
}

