/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network.pipeline.udp;

import dorkbox.network.connection.ConnectionImpl;
import dorkbox.network.util.CryptoSerializationManager;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.socket.DatagramPacket;
import io.netty.handler.codec.MessageToMessageDecoder;
import java.io.IOException;
import java.util.List;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class KryoDecoderUdpCrypto
extends MessageToMessageDecoder<DatagramPacket> {
    private final CryptoSerializationManager serializationManager;

    public KryoDecoderUdpCrypto(CryptoSerializationManager serializationManager) {
        this.serializationManager = serializationManager;
    }

    public void decode(ChannelHandlerContext ctx, DatagramPacket in, List<Object> out) throws Exception {
        ChannelHandler last = ctx.pipeline().last();
        try {
            ByteBuf data = (ByteBuf)in.content();
            Object object = this.serializationManager.readWithCrypto((ConnectionImpl)last, data, data.readableBytes());
            out.add(object);
        }
        catch (IOException e) {
            String message = "Unable to deserialize object";
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error(message, (Throwable)e);
            throw new IOException(message, e);
        }
    }
}

