/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network.pipeline.udp;

import dorkbox.network.connection.EndPointBase;
import dorkbox.network.util.CryptoSerializationManager;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.socket.DatagramPacket;
import io.netty.handler.codec.MessageToMessageEncoder;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.List;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class KryoEncoderUdp
extends MessageToMessageEncoder<Object> {
    private static final int maxSize = EndPointBase.udpMaxSize;
    private final CryptoSerializationManager serializationManager;

    public KryoEncoderUdp(CryptoSerializationManager serializationManager) {
        this.serializationManager = serializationManager;
    }

    void writeObject(CryptoSerializationManager serializationManager, ChannelHandlerContext context, Object msg, ByteBuf buffer) throws IOException {
        serializationManager.write(buffer, msg);
    }

    protected void encode(ChannelHandlerContext ctx, Object msg, List<Object> out) throws Exception {
        if (msg != null) {
            try {
                ByteBuf outBuffer = Unpooled.buffer((int)maxSize);
                this.writeObject(this.serializationManager, ctx, msg, outBuffer);
                if (outBuffer.readableBytes() > maxSize) {
                    String message = "Object is TOO BIG FOR UDP! " + msg.toString() + " (Max " + maxSize + ", was " + outBuffer.readableBytes() + ")";
                    LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error(message);
                    throw new IOException(message);
                }
                DatagramPacket packet = new DatagramPacket(outBuffer, (InetSocketAddress)ctx.channel().remoteAddress());
                out.add(packet);
            }
            catch (Exception e) {
                String message = "Unable to serialize object of type: " + msg.getClass().getName();
                LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error(message, (Throwable)e);
                throw new IOException(message, e);
            }
        }
    }
}

