/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network.rmi;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.util.IdentityMap;
import com.esotericsoftware.kryo.util.Util;
import com.esotericsoftware.reflectasm.MethodAccess;
import dorkbox.network.connection.Connection;
import dorkbox.network.connection.EndPointBase;
import dorkbox.network.connection.KryoExtra;
import dorkbox.network.rmi.AsmCachedMethod;
import dorkbox.network.util.CryptoSerializationManager;
import dorkbox.network.util.RmiSerializationManager;
import dorkbox.util.ClassHelper;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachedMethod {
    private static final Logger logger = LoggerFactory.getLogger(CachedMethod.class);
    private static final Comparator<Method> METHOD_COMPARATOR = new Comparator<Method>(){

        @Override
        public int compare(Method o1, Method o2) {
            Class<?>[] argTypes2;
            String o2Name;
            String o1Name = o1.getName();
            int diff = o1Name.compareTo(o2Name = o2.getName());
            if (diff != 0) {
                return diff;
            }
            Class<?>[] argTypes1 = o1.getParameterTypes();
            if (argTypes1.length > (argTypes2 = o2.getParameterTypes()).length) {
                return 1;
            }
            if (argTypes1.length < argTypes2.length) {
                return -1;
            }
            for (int i = 0; i < argTypes1.length; ++i) {
                diff = argTypes1[i].getName().compareTo(argTypes2[i].getName());
                if (diff == 0) continue;
                return diff;
            }
            throw new RuntimeException("Two methods with same signature! ('" + o1Name + "', '" + o2Name + "'");
        }
    };
    private static final Map<Class<?>, CachedMethod[]> methodCache = new ConcurrentHashMap(EndPointBase.DEFAULT_THREAD_POOL_SIZE);
    public Method method;
    public int methodClassID;
    public int methodIndex;
    public transient Method origMethod;
    public Serializer[] serializers;

    static CachedMethod[] getMethods(Kryo kryo, Class<?> type, int classId) {
        CachedMethod[] cachedMethods = methodCache.get(type);
        if (cachedMethods != null) {
            return cachedMethods;
        }
        cachedMethods = CachedMethod.getCachedMethods(kryo, type, classId);
        methodCache.put(type, cachedMethods);
        return cachedMethods;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static CachedMethod[] getMethods(RmiSerializationManager serializationManager, Class<?> type, int classId) {
        CachedMethod[] cachedMethods = methodCache.get(type);
        if (cachedMethods != null) {
            return cachedMethods;
        }
        KryoExtra kryo = serializationManager.takeKryo();
        try {
            cachedMethods = CachedMethod.getCachedMethods(kryo, type, classId);
            methodCache.put(type, cachedMethods);
        }
        finally {
            serializationManager.returnKryo(kryo);
        }
        return cachedMethods;
    }

    private static CachedMethod[] getCachedMethods(Kryo kryo, Class<?> type, int classId) {
        CryptoSerializationManager serialization = ((KryoExtra)kryo).getSerializationManager();
        Class<?> interfaceClass = serialization.getRmiIface(classId);
        ArrayList<Method> methods = interfaceClass == null ? CachedMethod.getMethods(type) : CachedMethod.getMethods(interfaceClass);
        int size = methods.size();
        CachedMethod[] cachedMethods = new CachedMethod[size];
        IdentityMap<Method, Method> overriddenMethods = interfaceClass == null ? null : CachedMethod.getOverriddenMethods(type, methods);
        boolean asmEnabled = kryo.getFieldSerializerConfig().isUseAsm();
        MethodAccess methodAccess = null;
        if (asmEnabled && type != Object.class && !Util.isAndroid && Modifier.isPublic(type.getModifiers()) && (methodAccess = MethodAccess.get(type)).getMethodNames().length == 0 && methodAccess.getParameterTypes().length == 0 && methodAccess.getReturnTypes().length == 0) {
            methodAccess = null;
        }
        for (int i = 0; i < size; ++i) {
            CachedMethod cachedMethod;
            Class[] parameterTypes;
            Class<?> declaringClass;
            Method method;
            Method origMethod;
            block9: {
                Method overriddenMethod;
                method = origMethod = methods.get(i);
                declaringClass = method.getDeclaringClass();
                MethodAccess localMethodAccess = methodAccess;
                Class[] asmParameterTypes = parameterTypes = method.getParameterTypes();
                if (overriddenMethods != null && (overriddenMethod = (Method)overriddenMethods.remove((Object)method)) != null) {
                    method = overriddenMethod;
                    Class<?> overrideType = declaringClass;
                    if (asmEnabled && !Util.isAndroid && Modifier.isPublic(overrideType.getModifiers())) {
                        localMethodAccess = MethodAccess.get(overrideType);
                        asmParameterTypes = method.getParameterTypes();
                    }
                }
                cachedMethod = null;
                if (localMethodAccess != null) {
                    try {
                        int index = localMethodAccess.getIndex(method.getName(), asmParameterTypes);
                        AsmCachedMethod asmCachedMethod = new AsmCachedMethod();
                        asmCachedMethod.methodAccessIndex = index;
                        asmCachedMethod.methodAccess = localMethodAccess;
                        cachedMethod = asmCachedMethod;
                    }
                    catch (Exception e) {
                        if (!logger.isTraceEnabled()) break block9;
                        logger.trace("Unable to use ReflectAsm for {}.{}", new Object[]{declaringClass, method.getName(), e});
                    }
                }
            }
            if (cachedMethod == null) {
                cachedMethod = new CachedMethod();
            }
            cachedMethod.method = method;
            cachedMethod.origMethod = origMethod;
            Class<?> impl = serialization.getRmiImpl(declaringClass);
            cachedMethod.methodClassID = impl != null ? kryo.getRegistration(impl).getId() : kryo.getRegistration(declaringClass).getId();
            cachedMethod.methodIndex = i;
            cachedMethod.serializers = new Serializer[parameterTypes.length];
            int nn = parameterTypes.length;
            for (int ii = 0; ii < nn; ++ii) {
                if (!kryo.isFinal(parameterTypes[ii])) continue;
                cachedMethod.serializers[ii] = kryo.getSerializer(parameterTypes[ii]);
            }
            cachedMethods[i] = cachedMethod;
        }
        return cachedMethods;
    }

    private static IdentityMap<Method, Method> getOverriddenMethods(Class<?> type, ArrayList<Method> origMethods) {
        ArrayList<Method> implMethods = CachedMethod.getMethods(type);
        IdentityMap overrideMap = new IdentityMap(implMethods.size());
        block0: for (Method origMethod : origMethods) {
            String name = origMethod.getName();
            Class<?>[] origTypes = origMethod.getParameterTypes();
            int origLength = origTypes.length + 1;
            for (Method implMethod : implMethods) {
                Class<?> shouldBeConnectionType;
                String checkName = implMethod.getName();
                Class<?>[] checkTypes = implMethod.getParameterTypes();
                int checkLength = checkTypes.length;
                if (origLength != checkLength || !name.equals(checkName) || !ClassHelper.hasInterface(Connection.class, shouldBeConnectionType = checkTypes[0])) continue;
                if (checkLength == 1) {
                    overrideMap.put((Object)origMethod, (Object)implMethod);
                    continue block0;
                }
                for (int k = 1; k < checkLength; ++k) {
                    if (origTypes[k - 1] != checkTypes[k]) continue;
                    overrideMap.put((Object)origMethod, (Object)implMethod);
                    continue block0;
                }
            }
        }
        return overrideMap;
    }

    private static ArrayList<Method> getMethods(Class<?> type) {
        ArrayList allMethods = new ArrayList();
        Class<?> nextClass = type;
        while (nextClass != null) {
            Collections.addAll(allMethods, nextClass.getDeclaredMethods());
            if ((nextClass = nextClass.getSuperclass()) != Object.class) continue;
        }
        ArrayList<Method> methods = new ArrayList<Method>(Math.max(1, allMethods.size()));
        int n = allMethods.size();
        for (int i = 0; i < n; ++i) {
            Method method = (Method)allMethods.get(i);
            int modifiers = method.getModifiers();
            if (Modifier.isStatic(modifiers) || Modifier.isPrivate(modifiers) || method.isSynthetic()) continue;
            methods.add(method);
        }
        Collections.sort(methods, METHOD_COMPARATOR);
        return methods;
    }

    public Object invoke(Connection connection, Object target, Object[] args) throws IllegalAccessException, InvocationTargetException {
        if (this.method == this.origMethod) {
            return this.method.invoke(target, args);
        }
        int length = args.length;
        Object[] newArgs = new Object[length + 1];
        newArgs[0] = connection;
        System.arraycopy(args, 0, newArgs, 1, length);
        return this.method.invoke(target, newArgs);
    }
}

