/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network.rmi;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import dorkbox.network.connection.KryoExtra;
import dorkbox.network.rmi.RmiProxyHandler;
import java.lang.reflect.Proxy;
import org.slf4j.Logger;

public class InvocationHandlerSerializer
extends Serializer<Object> {
    private final Logger logger;

    public InvocationHandlerSerializer(Logger logger) {
        this.logger = logger;
    }

    public void write(Kryo kryo, Output output, Object object) {
        RmiProxyHandler handler = (RmiProxyHandler)Proxy.getInvocationHandler(object);
        output.writeInt(handler.objectID, true);
    }

    public Object read(Kryo kryo, Input input, Class<Object> type) {
        int objectID = input.readInt(true);
        KryoExtra kryoExtra = (KryoExtra)kryo;
        Object object = kryoExtra.connection.getImplementationObject(objectID);
        if (object == null) {
            this.logger.error("Unknown object ID in RMI ObjectSpace: {}", (Object)objectID);
        }
        return object;
    }
}

