/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network.rmi;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.KryoException;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import dorkbox.network.rmi.CachedMethod;
import dorkbox.network.rmi.InvokeMethod;

public class InvokeMethodSerializer
extends Serializer<InvokeMethod> {
    public void write(Kryo kryo, Output output, InvokeMethod object) {
        output.writeInt(object.objectID, true);
        output.writeInt(object.cachedMethod.methodClassID, true);
        output.writeByte(object.cachedMethod.methodIndex);
        Serializer[] serializers = object.cachedMethod.serializers;
        int length = serializers.length;
        Object[] args = object.args;
        for (int i = 0; i < length; ++i) {
            Serializer serializer = serializers[i];
            if (serializer != null) {
                kryo.writeObjectOrNull(output, args[i], serializer);
                continue;
            }
            kryo.writeClassAndObject(output, args[i]);
        }
        output.writeByte(object.responseData);
    }

    public InvokeMethod read(Kryo kryo, Input input, Class<InvokeMethod> type) {
        CachedMethod cachedMethod;
        InvokeMethod invokeMethod = new InvokeMethod();
        invokeMethod.objectID = input.readInt(true);
        int methodClassID = input.readInt(true);
        Class methodClass = kryo.getRegistration(methodClassID).getType();
        byte methodIndex = input.readByte();
        try {
            invokeMethod.cachedMethod = cachedMethod = CachedMethod.getMethods(kryo, methodClass, methodClassID)[methodIndex];
        }
        catch (IndexOutOfBoundsException ex) {
            throw new KryoException("Invalid method index " + methodIndex + " for class: " + methodClass.getName());
        }
        Serializer[] serializers = cachedMethod.serializers;
        Class<?>[] parameterTypes = cachedMethod.method.getParameterTypes();
        Object[] args = new Object[serializers.length];
        invokeMethod.args = args;
        int n = args.length;
        for (int i = 0; i < n; ++i) {
            Serializer serializer = serializers[i];
            args[i] = serializer != null ? kryo.readObjectOrNull(input, parameterTypes[i], serializer) : kryo.readClassAndObject(input);
        }
        invokeMethod.responseData = input.readByte();
        return invokeMethod;
    }
}

