/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network.rmi;

import com.esotericsoftware.kryo.util.IntMap;
import dorkbox.network.connection.Connection;
import dorkbox.network.connection.ConnectionImpl;
import dorkbox.network.connection.Listener;
import dorkbox.network.rmi.CachedMethod;
import dorkbox.network.rmi.InvokeMethod;
import dorkbox.network.rmi.InvokeMethodResult;
import dorkbox.network.rmi.RemoteObject;
import dorkbox.network.rmi.RmiProxyHandler;
import dorkbox.util.collections.ObjectIntMap;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;

public final class RmiBridge {
    public static final int INVALID_RMI = 0;
    static final int returnValueMask = 128;
    static final int returnExceptionMask = 64;
    static final int responseIdMask = 63;
    private static final int MAX_RMI_VALUE = 16380;
    private final Logger logger;
    private final AtomicInteger rmiObjectIdCounter;
    private final ReentrantReadWriteLock objectLock = new ReentrantReadWriteLock();
    private final IntMap<Object> idToObject = new IntMap();
    private final ObjectIntMap<Object> objectToID = new ObjectIntMap();
    private final Executor executor;
    private final Listener.OnMessageReceived<ConnectionImpl, InvokeMethod> invokeListener = new Listener.OnMessageReceived<ConnectionImpl, InvokeMethod>(){

        @Override
        public void received(final ConnectionImpl connection, final InvokeMethod invokeMethod) {
            int objectID = invokeMethod.objectID;
            final Object target = connection.getImplementationObject(objectID);
            if (target == null) {
                Logger logger2 = RmiBridge.this.logger;
                if (logger2.isWarnEnabled()) {
                    logger2.warn("Ignoring remote invocation request for unknown object ID: {}", (Object)objectID);
                }
                return;
            }
            Executor executor2 = RmiBridge.this.executor;
            if (executor2 == null) {
                try {
                    RmiBridge.this.invoke(connection, target, invokeMethod);
                }
                catch (IOException e) {
                    RmiBridge.this.logger.error("Unable to invoke method.", (Throwable)e);
                }
            } else {
                executor2.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            RmiBridge.this.invoke(connection, target, invokeMethod);
                        }
                        catch (IOException e) {
                            RmiBridge.this.logger.error("Unable to invoke method.", (Throwable)e);
                        }
                    }
                });
            }
        }
    };

    public static boolean isGlobal(int objectId) {
        return (objectId & 1) != 0;
    }

    public RmiBridge(Logger logger, Executor executor, boolean isGlobal) {
        this.logger = logger;
        this.executor = executor;
        this.rmiObjectIdCounter = isGlobal ? new AtomicInteger(1) : new AtomicInteger(2);
    }

    public Listener getListener() {
        return this.invokeListener;
    }

    protected void invoke(Connection connection, Object target, InvokeMethod invokeMethod) throws IOException {
        Object result;
        byte responseData;
        CachedMethod cachedMethod = invokeMethod.cachedMethod;
        Logger logger2 = this.logger;
        if (logger2.isTraceEnabled()) {
            String argString = "";
            if (invokeMethod.args != null) {
                argString = Arrays.deepToString(invokeMethod.args);
                argString = argString.substring(1, argString.length() - 1);
            }
            StringBuilder stringBuilder = new StringBuilder(128);
            stringBuilder.append(connection.toString()).append(" received: ").append(target.getClass().getSimpleName());
            stringBuilder.append(":").append(invokeMethod.objectID);
            stringBuilder.append("#").append(cachedMethod.method.getName());
            stringBuilder.append("(").append(argString).append(")");
            if (cachedMethod.origMethod != null) {
                stringBuilder.append(" [Connection method override]");
            }
            logger2.trace(stringBuilder.toString());
        }
        boolean transmitReturnVal = ((responseData = invokeMethod.responseData) & 0x80) == 128;
        boolean transmitExceptions = (responseData & 0x40) == 64;
        int responseID = responseData & 0x3F;
        try {
            result = cachedMethod.invoke(connection, target, invokeMethod.args);
        }
        catch (Exception ex) {
            if (transmitExceptions) {
                Throwable cause = ex.getCause();
                if (cause == null) {
                    cause = ex;
                } else {
                    cause.initCause(null);
                }
                result = cause;
            }
            throw new IOException("Error invoking method: " + cachedMethod.method.getDeclaringClass().getName() + "." + cachedMethod.method.getName(), ex);
        }
        if (responseID == 0) {
            return;
        }
        InvokeMethodResult invokeMethodResult = new InvokeMethodResult();
        invokeMethodResult.objectID = invokeMethod.objectID;
        invokeMethodResult.responseID = (byte)responseID;
        invokeMethodResult.result = !transmitReturnVal && !invokeMethod.cachedMethod.method.getReturnType().isPrimitive() ? null : result;
        connection.send().TCP(invokeMethodResult).flush();
    }

    public int nextObjectId() {
        int value = this.rmiObjectIdCounter.getAndAdd(2);
        if (value > 16380) {
            this.rmiObjectIdCounter.set(16380);
            this.logger.error("RMI next value has exceeded maximum limits in RmiBridge!");
        }
        return value;
    }

    public void register(int objectID, Object object) {
        if (objectID == Integer.MAX_VALUE) {
            throw new IllegalArgumentException("objectID cannot be Integer.MAX_VALUE.");
        }
        if (object == null) {
            throw new IllegalArgumentException("object cannot be null.");
        }
        ReentrantReadWriteLock.WriteLock writeLock = this.objectLock.writeLock();
        writeLock.lock();
        this.idToObject.put(objectID, object);
        this.objectToID.put(object, objectID);
        writeLock.unlock();
        Logger logger2 = this.logger;
        if (logger2.isTraceEnabled()) {
            logger2.trace("Object <proxy #{}> registered with ObjectSpace with .toString() = '{}'", (Object)objectID, object);
        }
    }

    public void remove(int objectID) {
        ReentrantReadWriteLock.WriteLock writeLock = this.objectLock.writeLock();
        writeLock.lock();
        Object object = this.idToObject.remove(objectID);
        if (object != null) {
            this.objectToID.remove(object, 0);
        }
        writeLock.unlock();
        Logger logger2 = this.logger;
        if (logger2.isTraceEnabled()) {
            logger2.trace("Object <proxy #{}> removed from ObjectSpace with .toString() = '{}'", (Object)objectID, object);
        }
    }

    public void remove(Object object) {
        ReentrantReadWriteLock.WriteLock writeLock = this.objectLock.writeLock();
        writeLock.lock();
        if (!this.idToObject.containsValue(object, true)) {
            writeLock.unlock();
            return;
        }
        int objectID = this.idToObject.findKey(object, true, -1);
        this.idToObject.remove(objectID);
        this.objectToID.remove(object, 0);
        writeLock.unlock();
        Logger logger2 = this.logger;
        if (logger2.isTraceEnabled()) {
            logger2.trace("Object {} removed from ObjectSpace: {}", (Object)objectID, object);
        }
    }

    public Object getRegisteredObject(int objectID) {
        ReentrantReadWriteLock.ReadLock readLock = this.objectLock.readLock();
        readLock.lock();
        Object object = this.idToObject.get(objectID);
        readLock.unlock();
        return object;
    }

    public <T> int getRegisteredId(T object) {
        ReentrantReadWriteLock.ReadLock readLock = this.objectLock.readLock();
        readLock.lock();
        int id = this.objectToID.get(object, Integer.MAX_VALUE);
        readLock.unlock();
        return id;
    }

    public RemoteObject createProxyObject(Connection connection, int objectID, Class<?> iface) {
        if (connection == null) {
            throw new IllegalArgumentException("connection cannot be null.");
        }
        if (iface == null) {
            throw new IllegalArgumentException("iface cannot be null.");
        }
        Class[] temp = new Class[]{RemoteObject.class, iface};
        return (RemoteObject)Proxy.newProxyInstance(RmiBridge.class.getClassLoader(), temp, (InvocationHandler)new RmiProxyHandler(connection, objectID));
    }
}

