/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network.store;

import dorkbox.util.OS;
import dorkbox.util.SerializationManager;
import dorkbox.util.exceptions.SecurityException;
import dorkbox.util.storage.Storage;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.reflect.Reflection;

public abstract class SettingsStore {
    public abstract void init(SerializationManager var1, Storage var2);

    private static String getCallingClass() {
        if (OS.javaVersion < 8) {
            Class callerClass = Reflection.getCallerClass((int)4);
            if (callerClass == null) {
                return null;
            }
            return callerClass.getName();
        }
        StackTraceElement[] cause = Thread.currentThread().getStackTrace();
        if (cause == null || cause.length < 4) {
            return null;
        }
        StackTraceElement stackTraceElement = cause[4];
        if (stackTraceElement == null) {
            return null;
        }
        return stackTraceElement.getClassName();
    }

    protected static void checkAccess(Class<?> callingClass) throws SecurityException {
        String callerClass = SettingsStore.getCallingClass();
        if (callerClass == null || !callerClass.equals(callingClass.getName())) {
            String message = "Security violation by: " + (callerClass == null ? "???" : callerClass);
            Logger logger = LoggerFactory.getLogger(SettingsStore.class);
            logger.error(message);
            throw new SecurityException(message);
        }
    }

    protected static void checkAccess(Class<?> callingClass1, Class<?> callingClass2) throws SecurityException {
        String callerClass = SettingsStore.getCallingClass();
        boolean ok = false;
        if (callerClass != null) {
            boolean bl = ok = callerClass.equals(callingClass1.getName()) || callerClass.equals(callingClass2.getName());
        }
        if (!ok) {
            String message = "Security violation by: " + (callerClass == null ? "???" : callerClass);
            Logger logger = LoggerFactory.getLogger(SettingsStore.class);
            logger.error(message);
            throw new SecurityException(message);
        }
    }

    protected static void checkAccess(Class<?> callingClass1, Class<?> callingClass2, Class<?> callingClass3) throws SecurityException {
        String callerClass = SettingsStore.getCallingClass();
        boolean ok = false;
        if (callerClass != null) {
            boolean bl = ok = callerClass.equals(callingClass1.getName()) || callerClass.equals(callingClass2.getName()) || callerClass.equals(callingClass3.getName());
        }
        if (!ok) {
            String message = "Security violation by: " + (callerClass == null ? "???" : callerClass);
            Logger logger = LoggerFactory.getLogger(SettingsStore.class);
            logger.error(message);
            throw new SecurityException(message);
        }
    }

    protected static void checkAccess(Class<?> ... callingClasses) throws SecurityException {
        String callerClass = SettingsStore.getCallingClass();
        boolean ok = false;
        if (callerClass != null) {
            for (Class<?> clazz : callingClasses) {
                if (!callerClass.equals(clazz.getName())) continue;
                ok = true;
                break;
            }
        }
        if (!ok) {
            String message = "Security violation by: " + (callerClass == null ? "???" : callerClass);
            Logger logger = LoggerFactory.getLogger(SettingsStore.class);
            logger.error(message);
            throw new SecurityException(message);
        }
    }

    protected static boolean checkAccessNoExit(Class<?> callingClass) {
        String callerClass = SettingsStore.getCallingClass();
        if (callerClass == null || !callerClass.equals(callingClass.getName())) {
            String message = "Security violation by: " + (callerClass == null ? "???" : callerClass);
            Logger logger = LoggerFactory.getLogger(SettingsStore.class);
            logger.error(message);
            return false;
        }
        return true;
    }

    protected static boolean checkAccessNoExit(Class<?> callingClass1, Class<?> callingClass2) {
        String callerClass = SettingsStore.getCallingClass();
        boolean ok = false;
        if (callerClass != null) {
            boolean bl = ok = callerClass.equals(callingClass1.getName()) || callerClass.equals(callingClass2.getName());
        }
        if (!ok) {
            String message = "Security violation by: " + (callerClass == null ? "???" : callerClass);
            Logger logger = LoggerFactory.getLogger(SettingsStore.class);
            logger.error(message);
            return false;
        }
        return true;
    }

    protected static boolean checkAccessNoExit(Class<?> callingClass1, Class<?> callingClass2, Class<?> callingClass3) {
        String callerClass = SettingsStore.getCallingClass();
        boolean ok = false;
        if (callerClass != null) {
            boolean bl = ok = callerClass.equals(callingClass1.getName()) || callerClass.equals(callingClass2.getName()) || callerClass.equals(callingClass3.getName());
        }
        if (!ok) {
            String message = "Security violation by: " + (callerClass == null ? "???" : callerClass);
            Logger logger = LoggerFactory.getLogger(SettingsStore.class);
            logger.error(message);
            return false;
        }
        return true;
    }

    protected static boolean checkAccessNoExit(Class<?> ... callingClasses) {
        String callerClass = SettingsStore.getCallingClass();
        boolean ok = false;
        if (callerClass != null) {
            for (Class<?> clazz : callingClasses) {
                if (!callerClass.equals(clazz.getName())) continue;
                ok = true;
                break;
            }
        }
        if (!ok) {
            String message = "Security violation by: " + (callerClass == null ? "???" : callerClass);
            Logger logger = LoggerFactory.getLogger(SettingsStore.class);
            logger.error(message);
            return false;
        }
        return true;
    }

    public abstract ECPrivateKeyParameters getPrivateKey() throws SecurityException;

    public abstract void savePrivateKey(ECPrivateKeyParameters var1) throws SecurityException;

    public abstract ECPublicKeyParameters getPublicKey() throws SecurityException;

    public abstract void savePublicKey(ECPublicKeyParameters var1) throws SecurityException;

    public abstract byte[] getSalt();

    public abstract ECPublicKeyParameters getRegisteredServerKey(byte[] var1) throws SecurityException;

    public abstract void addRegisteredServerKey(byte[] var1, ECPublicKeyParameters var2) throws SecurityException;

    public abstract boolean removeRegisteredServerKey(byte[] var1) throws SecurityException;

    public abstract void close();
}

