/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.util;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;

public final class ClassHelper {
    public static Class<?> getGenericParameterAsClassForSuperClass(Class<?> clazz, int genericParameterToGet) {
        Class<?> classToCheck;
        for (classToCheck = clazz; classToCheck != Object.class; classToCheck = classToCheck.getSuperclass()) {
            Type[] actualTypeArguments;
            Type superClassGeneric = classToCheck.getGenericSuperclass();
            if (!(superClassGeneric instanceof ParameterizedType) || (actualTypeArguments = ((ParameterizedType)superClassGeneric).getActualTypeArguments()).length <= genericParameterToGet) continue;
            Class<?> rawTypeAsClass = ClassHelper.getRawTypeAsClass(actualTypeArguments[genericParameterToGet]);
            return rawTypeAsClass;
        }
        for (classToCheck = clazz; classToCheck != Object.class; classToCheck = classToCheck.getSuperclass()) {
            Type[] genericInterfaces;
            for (Type genericInterface : genericInterfaces = classToCheck.getGenericInterfaces()) {
                Type[] actualTypeArguments;
                if (!(genericInterface instanceof ParameterizedType) || (actualTypeArguments = ((ParameterizedType)genericInterface).getActualTypeArguments()).length <= genericParameterToGet) continue;
                Class<?> rawTypeAsClass = ClassHelper.getRawTypeAsClass(actualTypeArguments[genericParameterToGet]);
                return rawTypeAsClass;
            }
        }
        return null;
    }

    public static Class<?> getRawTypeAsClass(Type type) {
        Type[] bounds;
        if (type instanceof Class) {
            Class class1 = (Class)type;
            return class1;
        }
        if (type instanceof GenericArrayType) {
            Type type2 = ((GenericArrayType)type).getGenericComponentType();
            Class<?> rawType = ClassHelper.getRawTypeAsClass(type2);
            return Array.newInstance(rawType, 0).getClass();
        }
        if (type instanceof ParameterizedType) {
            return (Class)((ParameterizedType)type).getRawType();
        }
        if (type instanceof TypeVariable && (bounds = ((TypeVariable)type).getBounds()).length > 0) {
            return ClassHelper.getRawTypeAsClass(bounds[0]);
        }
        throw new RuntimeException("Unknown/messed up type parameter . Can't figure it out... Quit being complex!");
    }

    public static boolean hasInterface(Class<?> clazzItMustHave, Class<?> clazz) {
        Class<?>[] interfaces;
        if (clazzItMustHave == clazz) {
            return true;
        }
        for (Class<?> iface : interfaces = clazz.getInterfaces()) {
            if (iface != clazzItMustHave) continue;
            return true;
        }
        for (Class<?> iface : interfaces) {
            boolean b = ClassHelper.hasInterface(clazzItMustHave, iface);
            if (!b) continue;
            return b;
        }
        for (Class<?> superClass = clazz.getSuperclass(); superClass != null && superClass != Object.class; superClass = superClass.getSuperclass()) {
            if (!ClassHelper.hasInterface(clazzItMustHave, superClass)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasParentClass(Class<?> parentClazz, Class<?> clazz) {
        Class<?> superClass = clazz.getSuperclass();
        if (parentClazz == superClass) {
            return true;
        }
        if (superClass != null && superClass != Object.class) {
            return ClassHelper.hasParentClass(parentClazz, superClass);
        }
        return false;
    }

    private ClassHelper() {
    }
}

