/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.util;

import dorkbox.util.OS;
import io.netty.util.internal.PlatformDependent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.rmi.server.ExportException;

public class NativeLoader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadLibrary(String sourceFileName, String destinationPrefix, Class<?> classLoaderClass, String version) throws Exception {
        try {
            String suffix = OS.isLinux() ? ".so" : (OS.isWindows() ? ".dll" : ".dylib");
            String outputFileName = destinationPrefix + "." + version + suffix;
            File file = new File(OS.TEMP_DIR, outputFileName);
            if (!file.canRead()) {
                ClassLoader loader = PlatformDependent.getClassLoader(classLoaderClass);
                URL url = loader.getResource(sourceFileName);
                InputStream inputStream = url.openStream();
                FileOutputStream outStream = null;
                try {
                    int read;
                    outStream = new FileOutputStream(file);
                    byte[] buffer = new byte[4096];
                    while ((read = inputStream.read(buffer)) > 0) {
                        ((OutputStream)outStream).write(buffer, 0, read);
                    }
                    outStream.flush();
                    ((OutputStream)outStream).close();
                    outStream = null;
                }
                finally {
                    try {
                        inputStream.close();
                    }
                    catch (Exception exception) {}
                    try {
                        if (outStream != null) {
                            ((OutputStream)outStream).close();
                        }
                    }
                    catch (Exception exception) {}
                }
            }
            System.load(file.getAbsolutePath());
        }
        catch (Exception e) {
            throw new ExportException("Error extracting library: " + sourceFileName, e);
        }
    }

    private NativeLoader() {
    }
}

