/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.util.bytes;

import io.netty.buffer.ByteBuf;

public class OptimizeUtilsByteBuf {
    public static int intLength(int value, boolean optimizePositive) {
        if (!optimizePositive) {
            value = value << 1 ^ value >> 31;
        }
        if (value >>> 7 == 0) {
            return 1;
        }
        if (value >>> 14 == 0) {
            return 2;
        }
        if (value >>> 21 == 0) {
            return 3;
        }
        if (value >>> 28 == 0) {
            return 4;
        }
        return 5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int canReadInt(ByteBuf buffer) {
        int startIndex = buffer.readerIndex();
        try {
            int remaining = buffer.readableBytes();
            int offset = 0;
            int count = 1;
            while (offset < 32 && remaining > 0) {
                byte b = buffer.readByte();
                if ((b & 0x80) == 0) {
                    int n = count;
                    return n;
                }
                offset += 7;
                --remaining;
                ++count;
            }
            int n = 0;
            return n;
        }
        finally {
            buffer.readerIndex(startIndex);
        }
    }

    public static int readInt(ByteBuf buffer, boolean optimizePositive) {
        byte b = buffer.readByte();
        int result = b & 0x7F;
        if ((b & 0x80) != 0) {
            b = buffer.readByte();
            result |= (b & 0x7F) << 7;
            if ((b & 0x80) != 0) {
                b = buffer.readByte();
                result |= (b & 0x7F) << 14;
                if ((b & 0x80) != 0) {
                    b = buffer.readByte();
                    result |= (b & 0x7F) << 21;
                    if ((b & 0x80) != 0) {
                        b = buffer.readByte();
                        result |= (b & 0x7F) << 28;
                    }
                }
            }
        }
        return optimizePositive ? result : result >>> 1 ^ -(result & 1);
    }

    public static int writeInt(ByteBuf buffer, int value, boolean optimizePositive) {
        if (!optimizePositive) {
            value = value << 1 ^ value >> 31;
        }
        if (value >>> 7 == 0) {
            buffer.writeByte((int)((byte)value));
            return 1;
        }
        if (value >>> 14 == 0) {
            buffer.writeByte((int)((byte)(value & 0x7F | 0x80)));
            buffer.writeByte((int)((byte)(value >>> 7)));
            return 2;
        }
        if (value >>> 21 == 0) {
            buffer.writeByte((int)((byte)(value & 0x7F | 0x80)));
            buffer.writeByte((int)((byte)(value >>> 7 | 0x80)));
            buffer.writeByte((int)((byte)(value >>> 14)));
            return 3;
        }
        if (value >>> 28 == 0) {
            buffer.writeByte((int)((byte)(value & 0x7F | 0x80)));
            buffer.writeByte((int)((byte)(value >>> 7 | 0x80)));
            buffer.writeByte((int)((byte)(value >>> 14 | 0x80)));
            buffer.writeByte((int)((byte)(value >>> 21)));
            return 4;
        }
        buffer.writeByte((int)((byte)(value & 0x7F | 0x80)));
        buffer.writeByte((int)((byte)(value >>> 7 | 0x80)));
        buffer.writeByte((int)((byte)(value >>> 14 | 0x80)));
        buffer.writeByte((int)((byte)(value >>> 21 | 0x80)));
        buffer.writeByte((int)((byte)(value >>> 28)));
        return 5;
    }

    public static int longLength(long value, boolean optimizePositive) {
        if (!optimizePositive) {
            value = value << 1 ^ value >> 63;
        }
        if (value >>> 7 == 0L) {
            return 1;
        }
        if (value >>> 14 == 0L) {
            return 2;
        }
        if (value >>> 21 == 0L) {
            return 3;
        }
        if (value >>> 28 == 0L) {
            return 4;
        }
        if (value >>> 35 == 0L) {
            return 5;
        }
        if (value >>> 42 == 0L) {
            return 6;
        }
        if (value >>> 49 == 0L) {
            return 7;
        }
        if (value >>> 56 == 0L) {
            return 8;
        }
        return 9;
    }

    public static long readLong(ByteBuf buffer, boolean optimizePositive) {
        byte b = buffer.readByte();
        long result = b & 0x7F;
        if ((b & 0x80) != 0) {
            b = buffer.readByte();
            result |= (long)((b & 0x7F) << 7);
            if ((b & 0x80) != 0) {
                b = buffer.readByte();
                result |= (long)((b & 0x7F) << 14);
                if ((b & 0x80) != 0) {
                    b = buffer.readByte();
                    result |= (long)((b & 0x7F) << 21);
                    if ((b & 0x80) != 0) {
                        b = buffer.readByte();
                        result |= (long)(b & 0x7F) << 28;
                        if ((b & 0x80) != 0) {
                            b = buffer.readByte();
                            result |= (long)(b & 0x7F) << 35;
                            if ((b & 0x80) != 0) {
                                b = buffer.readByte();
                                result |= (long)(b & 0x7F) << 42;
                                if ((b & 0x80) != 0) {
                                    b = buffer.readByte();
                                    result |= (long)(b & 0x7F) << 49;
                                    if ((b & 0x80) != 0) {
                                        b = buffer.readByte();
                                        result |= (long)b << 56;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        if (!optimizePositive) {
            result = result >>> 1 ^ -(result & 1L);
        }
        return result;
    }

    public static int writeLong(ByteBuf buffer, long value, boolean optimizePositive) {
        if (!optimizePositive) {
            value = value << 1 ^ value >> 63;
        }
        if (value >>> 7 == 0L) {
            buffer.writeByte((int)((byte)value));
            return 1;
        }
        if (value >>> 14 == 0L) {
            buffer.writeByte((int)((byte)(value & 0x7FL | 0x80L)));
            buffer.writeByte((int)((byte)(value >>> 7)));
            return 2;
        }
        if (value >>> 21 == 0L) {
            buffer.writeByte((int)((byte)(value & 0x7FL | 0x80L)));
            buffer.writeByte((int)((byte)(value >>> 7 | 0x80L)));
            buffer.writeByte((int)((byte)(value >>> 14)));
            return 3;
        }
        if (value >>> 28 == 0L) {
            buffer.writeByte((int)((byte)(value & 0x7FL | 0x80L)));
            buffer.writeByte((int)((byte)(value >>> 7 | 0x80L)));
            buffer.writeByte((int)((byte)(value >>> 14 | 0x80L)));
            buffer.writeByte((int)((byte)(value >>> 21)));
            return 4;
        }
        if (value >>> 35 == 0L) {
            buffer.writeByte((int)((byte)(value & 0x7FL | 0x80L)));
            buffer.writeByte((int)((byte)(value >>> 7 | 0x80L)));
            buffer.writeByte((int)((byte)(value >>> 14 | 0x80L)));
            buffer.writeByte((int)((byte)(value >>> 21 | 0x80L)));
            buffer.writeByte((int)((byte)(value >>> 28)));
            return 5;
        }
        if (value >>> 42 == 0L) {
            buffer.writeByte((int)((byte)(value & 0x7FL | 0x80L)));
            buffer.writeByte((int)((byte)(value >>> 7 | 0x80L)));
            buffer.writeByte((int)((byte)(value >>> 14 | 0x80L)));
            buffer.writeByte((int)((byte)(value >>> 21 | 0x80L)));
            buffer.writeByte((int)((byte)(value >>> 28 | 0x80L)));
            buffer.writeByte((int)((byte)(value >>> 35)));
            return 6;
        }
        if (value >>> 49 == 0L) {
            buffer.writeByte((int)((byte)(value & 0x7FL | 0x80L)));
            buffer.writeByte((int)((byte)(value >>> 7 | 0x80L)));
            buffer.writeByte((int)((byte)(value >>> 14 | 0x80L)));
            buffer.writeByte((int)((byte)(value >>> 21 | 0x80L)));
            buffer.writeByte((int)((byte)(value >>> 28 | 0x80L)));
            buffer.writeByte((int)((byte)(value >>> 35 | 0x80L)));
            buffer.writeByte((int)((byte)(value >>> 42)));
            return 7;
        }
        if (value >>> 56 == 0L) {
            buffer.writeByte((int)((byte)(value & 0x7FL | 0x80L)));
            buffer.writeByte((int)((byte)(value >>> 7 | 0x80L)));
            buffer.writeByte((int)((byte)(value >>> 14 | 0x80L)));
            buffer.writeByte((int)((byte)(value >>> 21 | 0x80L)));
            buffer.writeByte((int)((byte)(value >>> 28 | 0x80L)));
            buffer.writeByte((int)((byte)(value >>> 35 | 0x80L)));
            buffer.writeByte((int)((byte)(value >>> 42 | 0x80L)));
            buffer.writeByte((int)((byte)(value >>> 49)));
            return 8;
        }
        buffer.writeByte((int)((byte)(value & 0x7FL | 0x80L)));
        buffer.writeByte((int)((byte)(value >>> 7 | 0x80L)));
        buffer.writeByte((int)((byte)(value >>> 14 | 0x80L)));
        buffer.writeByte((int)((byte)(value >>> 21 | 0x80L)));
        buffer.writeByte((int)((byte)(value >>> 28 | 0x80L)));
        buffer.writeByte((int)((byte)(value >>> 35 | 0x80L)));
        buffer.writeByte((int)((byte)(value >>> 42 | 0x80L)));
        buffer.writeByte((int)((byte)(value >>> 49 | 0x80L)));
        buffer.writeByte((int)((byte)(value >>> 56)));
        return 9;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int canReadLong(ByteBuf buffer) {
        int position = buffer.readerIndex();
        try {
            int remaining = buffer.readableBytes();
            int offset = 0;
            int count = 1;
            while (offset < 64 && remaining > 0) {
                byte b = buffer.readByte();
                if ((b & 0x80) == 0) {
                    int n = count;
                    return n;
                }
                offset += 7;
                --remaining;
                ++count;
            }
            int n = 0;
            return n;
        }
        finally {
            buffer.readerIndex(position);
        }
    }
}

