/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.util.serialization;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.reflectasm.FieldAccess;
import java.math.BigInteger;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.ec.CustomNamedCurves;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECPoint;

public class EccPrivateKeySerializer
extends Serializer<ECPrivateKeyParameters> {
    private static final FieldAccess ecCurveAccess = FieldAccess.get(ECCurve.class);
    private static final int ecCoordIndex = ecCurveAccess.getIndex("coord");
    private static final byte usesName = 1;
    private static final byte usesOid = 2;

    public static void write(Output output, ECPrivateKeyParameters key) {
        ECDomainParameters parameters = key.getParameters();
        ECCurve curve = parameters.getCurve();
        EccPrivateKeySerializer.serializeCurve(output, curve);
        BigInteger n = parameters.getN();
        ECPoint g = parameters.getG();
        byte[] bytes = n.toByteArray();
        int length = bytes.length;
        output.writeInt(length, true);
        output.writeBytes(bytes, 0, length);
        EccPrivateKeySerializer.serializeECPoint(g, output);
        bytes = key.getD().toByteArray();
        length = bytes.length;
        output.writeInt(length, true);
        output.writeBytes(bytes, 0, length);
    }

    public static ECPrivateKeyParameters read(Input input) {
        ECCurve curve = EccPrivateKeySerializer.deserializeCurve(input);
        int length = input.readInt(true);
        byte[] bytes = new byte[length];
        input.readBytes(bytes, 0, length);
        BigInteger n = new BigInteger(bytes);
        length = input.readInt(true);
        bytes = new byte[length];
        input.readBytes(bytes, 0, length);
        ECPoint g = curve.decodePoint(bytes);
        length = input.readInt(true);
        bytes = new byte[length];
        input.readBytes(bytes, 0, length);
        BigInteger D = new BigInteger(bytes);
        ECDomainParameters ecDomainParameters = new ECDomainParameters(curve, g, n);
        return new ECPrivateKeyParameters(D, ecDomainParameters);
    }

    static void serializeCurve(Output output, ECCurve curve) {
        ASN1ObjectIdentifier oid;
        String cleanedName;
        String curveName = curve.getClass().getSimpleName();
        if (CustomNamedCurves.getByName((String)curveName) != null) {
            output.writeInt(1, true);
            output.writeString(curveName);
            return;
        }
        if (curveName.endsWith("Curve") && !(cleanedName = curveName.substring(0, curveName.indexOf("Curve"))).isEmpty() && (oid = CustomNamedCurves.getOID((String)cleanedName)) != null) {
            output.writeInt(2, true);
            curveName = oid.getId();
            output.writeString(curveName);
            return;
        }
        BigInteger a = curve.getA().toBigInteger();
        BigInteger b = curve.getB().toBigInteger();
        BigInteger order = curve.getOrder();
        BigInteger cofactor = curve.getCofactor();
        BigInteger q = curve.getField().getCharacteristic();
        byte[] bytes = a.toByteArray();
        int length = bytes.length;
        output.writeInt(length, true);
        output.writeBytes(bytes, 0, length);
        bytes = b.toByteArray();
        length = bytes.length;
        output.writeInt(length, true);
        output.writeBytes(bytes, 0, length);
        bytes = order.toByteArray();
        length = bytes.length;
        output.writeInt(length, true);
        output.writeBytes(bytes, 0, length);
        bytes = cofactor.toByteArray();
        length = bytes.length;
        output.writeInt(length, true);
        output.writeBytes(bytes, 0, length);
        bytes = q.toByteArray();
        length = bytes.length;
        output.writeInt(length, true);
        output.writeBytes(bytes, 0, length);
        int coordinateSystem = curve.getCoordinateSystem();
        output.writeInt(coordinateSystem, true);
    }

    static ECCurve deserializeCurve(Input input) {
        ECCurve curve;
        int serializatioType = input.readInt(true);
        if (serializatioType == 1) {
            String curveName = input.readString();
            X9ECParameters x9Curve = CustomNamedCurves.getByName((String)curveName);
            curve = x9Curve.getCurve();
        } else if (serializatioType == 2) {
            String oid = input.readString();
            X9ECParameters x9Curve = CustomNamedCurves.getByOID((ASN1ObjectIdentifier)new ASN1ObjectIdentifier(oid));
            curve = x9Curve.getCurve();
        } else {
            int length = input.readInt(true);
            byte[] bytes = new byte[length];
            input.readBytes(bytes, 0, length);
            BigInteger a = new BigInteger(bytes);
            length = input.readInt(true);
            bytes = new byte[length];
            input.readBytes(bytes, 0, length);
            BigInteger b = new BigInteger(bytes);
            length = input.readInt(true);
            bytes = new byte[length];
            input.readBytes(bytes, 0, length);
            BigInteger order = new BigInteger(bytes);
            length = input.readInt(true);
            bytes = new byte[length];
            input.readBytes(bytes, 0, length);
            BigInteger cofactor = new BigInteger(bytes);
            length = input.readInt(true);
            bytes = new byte[length];
            input.readBytes(bytes, 0, length);
            BigInteger q = new BigInteger(bytes);
            int coordinateSystem = input.readInt(true);
            curve = new ECCurve.Fp(q, a, b, order, cofactor);
            ecCurveAccess.setInt((Object)curve, ecCoordIndex, coordinateSystem);
        }
        return curve;
    }

    static void serializeECPoint(ECPoint point, Output output) {
        if (point.isInfinity()) {
            return;
        }
        ECPoint normed = point.normalize();
        byte[] X = normed.getXCoord().getEncoded();
        byte[] Y = normed.getYCoord().getEncoded();
        int length = 1 + X.length + Y.length;
        output.writeInt(length, true);
        output.write(4);
        output.write(X);
        output.write(Y);
    }

    public void write(Kryo kryo, Output output, ECPrivateKeyParameters key) {
        EccPrivateKeySerializer.write(output, key);
    }

    public ECPrivateKeyParameters read(Kryo kryo, Input input, Class type) {
        return EccPrivateKeySerializer.read(input);
    }
}

