/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.util.serialization;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import dorkbox.util.serialization.EccPrivateKeySerializer;
import java.math.BigInteger;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECPoint;

public class EccPublicKeySerializer
extends Serializer<ECPublicKeyParameters> {
    public static void write(Output output, ECPublicKeyParameters key) {
        ECDomainParameters parameters = key.getParameters();
        ECCurve curve = parameters.getCurve();
        EccPrivateKeySerializer.serializeCurve(output, curve);
        BigInteger n = parameters.getN();
        ECPoint g = parameters.getG();
        byte[] bytes = n.toByteArray();
        int length = bytes.length;
        output.writeInt(length, true);
        output.writeBytes(bytes, 0, length);
        EccPrivateKeySerializer.serializeECPoint(g, output);
        EccPrivateKeySerializer.serializeECPoint(key.getQ(), output);
    }

    public static ECPublicKeyParameters read(Input input) {
        ECCurve curve = EccPrivateKeySerializer.deserializeCurve(input);
        int length = input.readInt(true);
        byte[] bytes = new byte[length];
        input.readBytes(bytes, 0, length);
        BigInteger n = new BigInteger(bytes);
        length = input.readInt(true);
        bytes = new byte[length];
        input.readBytes(bytes, 0, length);
        ECPoint g = curve.decodePoint(bytes);
        ECDomainParameters ecDomainParameters = new ECDomainParameters(curve, g, n);
        length = input.readInt(true);
        bytes = new byte[length];
        input.readBytes(bytes, 0, length);
        ECPoint Q = curve.decodePoint(bytes);
        return new ECPublicKeyParameters(Q, ecDomainParameters);
    }

    public void write(Kryo kryo, Output output, ECPublicKeyParameters key) {
        EccPublicKeySerializer.write(output, key);
    }

    public ECPublicKeyParameters read(Kryo kryo, Input input, Class type) {
        return EccPublicKeySerializer.read(input);
    }
}

