/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.util.serialization;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.math.BigInteger;
import org.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;

public class RsaPrivateKeySerializer
extends Serializer<RSAPrivateCrtKeyParameters> {
    public void write(Kryo kryo, Output output, RSAPrivateCrtKeyParameters key) {
        byte[] bytes = key.getDP().toByteArray();
        int length = bytes.length;
        output.writeInt(length, true);
        output.writeBytes(bytes, 0, length);
        bytes = key.getDQ().toByteArray();
        length = bytes.length;
        output.writeInt(length, true);
        output.writeBytes(bytes, 0, length);
        bytes = key.getExponent().toByteArray();
        length = bytes.length;
        output.writeInt(length, true);
        output.writeBytes(bytes, 0, length);
        bytes = key.getModulus().toByteArray();
        length = bytes.length;
        output.writeInt(length, true);
        output.writeBytes(bytes, 0, length);
        bytes = key.getP().toByteArray();
        length = bytes.length;
        output.writeInt(length, true);
        output.writeBytes(bytes, 0, length);
        bytes = key.getPublicExponent().toByteArray();
        length = bytes.length;
        output.writeInt(length, true);
        output.writeBytes(bytes, 0, length);
        bytes = key.getQ().toByteArray();
        length = bytes.length;
        output.writeInt(length, true);
        output.writeBytes(bytes, 0, length);
        bytes = key.getQInv().toByteArray();
        length = bytes.length;
        output.writeInt(length, true);
        output.writeBytes(bytes, 0, length);
    }

    public RSAPrivateCrtKeyParameters read(Kryo kryo, Input input, Class type) {
        int length = input.readInt(true);
        byte[] bytes = new byte[length];
        input.readBytes(bytes, 0, length);
        BigInteger DP = new BigInteger(bytes);
        length = input.readInt(true);
        bytes = new byte[length];
        input.readBytes(bytes, 0, length);
        BigInteger DQ = new BigInteger(bytes);
        length = input.readInt(true);
        bytes = new byte[length];
        input.readBytes(bytes, 0, length);
        BigInteger exponent = new BigInteger(bytes);
        length = input.readInt(true);
        bytes = new byte[length];
        input.readBytes(bytes, 0, length);
        BigInteger modulus = new BigInteger(bytes);
        length = input.readInt(true);
        bytes = new byte[length];
        input.readBytes(bytes, 0, length);
        BigInteger P = new BigInteger(bytes);
        length = input.readInt(true);
        bytes = new byte[length];
        input.readBytes(bytes, 0, length);
        BigInteger publicExponent = new BigInteger(bytes);
        length = input.readInt(true);
        bytes = new byte[length];
        input.readBytes(bytes, 0, length);
        BigInteger q = new BigInteger(bytes);
        length = input.readInt(true);
        bytes = new byte[length];
        input.readBytes(bytes, 0, length);
        BigInteger qInv = new BigInteger(bytes);
        return new RSAPrivateCrtKeyParameters(modulus, publicExponent, exponent, P, q, DP, DQ, qInv);
    }
}

