/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.util.serialization;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.math.BigInteger;
import org.bouncycastle.crypto.params.RSAKeyParameters;

public class RsaPublicKeySerializer
extends Serializer<RSAKeyParameters> {
    public void write(Kryo kryo, Output output, RSAKeyParameters key) {
        byte[] bytes = key.getModulus().toByteArray();
        int length = bytes.length;
        output.writeInt(length, true);
        output.writeBytes(bytes, 0, length);
        bytes = key.getExponent().toByteArray();
        length = bytes.length;
        output.writeInt(length, true);
        output.writeBytes(bytes, 0, length);
    }

    public RSAKeyParameters read(Kryo kryo, Input input, Class type) {
        int length = input.readInt(true);
        byte[] bytes = new byte[length];
        input.readBytes(bytes, 0, length);
        BigInteger modulus = new BigInteger(bytes);
        length = input.readInt(true);
        bytes = new byte[length];
        input.readBytes(bytes, 0, length);
        BigInteger exponent = new BigInteger(bytes);
        return new RSAKeyParameters(false, modulus, exponent);
    }
}

