/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.util.storage;

import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import dorkbox.util.SerializationManager;
import dorkbox.util.storage.StorageKey;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.ref.WeakReference;
import java.nio.channels.FileLock;

public class Metadata {
    private static final int KEY_SIZE = 32;
    private static final int POINTER_INFO_SIZE = 16;
    static final int INDEX_ENTRY_LENGTH = 48;
    final StorageKey key;
    volatile int indexPosition;
    volatile long dataPointer;
    volatile int dataCount;
    volatile int dataCapacity;
    volatile WeakReference<Object> objectReferenceCache;

    static long getMetaDataPointer(int position) {
        return 16L + 48L * (long)position;
    }

    private static long getDataPointer(int position) {
        return Metadata.getMetaDataPointer(position) + 32L;
    }

    private Metadata(StorageKey key) {
        this.key = key;
    }

    Metadata(StorageKey key, int recordIndex, long dataPointer) {
        this(key, recordIndex, dataPointer, 0);
    }

    private Metadata(StorageKey key, int recordIndex, long dataPointer, int dataCapacity) {
        if (key.getBytes().length > 32) {
            throw new IllegalArgumentException("Bad record key size: " + dataCapacity);
        }
        this.key = key;
        this.indexPosition = recordIndex;
        this.dataPointer = dataPointer;
        this.dataCapacity = dataCapacity;
        this.dataCount = dataCapacity;
    }

    int getFreeSpace() {
        return this.dataCapacity - this.dataCount;
    }

    static Metadata readHeader(RandomAccessFile file, int position) throws IOException {
        byte[] buf = new byte[32];
        long origHeaderKeyPointer = Metadata.getMetaDataPointer(position);
        FileLock lock = file.getChannel().lock(origHeaderKeyPointer, 48L, true);
        file.seek(origHeaderKeyPointer);
        file.readFully(buf);
        lock.release();
        Metadata r = new Metadata(new StorageKey(buf));
        r.indexPosition = position;
        long recordHeaderPointer = Metadata.getDataPointer(position);
        lock = file.getChannel().lock(origHeaderKeyPointer, 32L, true);
        file.seek(recordHeaderPointer);
        r.dataPointer = file.readLong();
        r.dataCapacity = file.readInt();
        r.dataCount = file.readInt();
        lock.release();
        if (r.dataPointer == 0L || (long)r.dataCapacity == 0L || (long)r.dataCount == 0L) {
            return null;
        }
        return r;
    }

    void writeMetaDataInfo(RandomAccessFile file) throws IOException {
        long recordKeyPointer = Metadata.getMetaDataPointer(this.indexPosition);
        FileLock lock = file.getChannel().lock(recordKeyPointer, 32L, false);
        file.seek(recordKeyPointer);
        file.write(this.key.getBytes());
        lock.release();
    }

    void writeDataInfo(RandomAccessFile file) throws IOException {
        long recordHeaderPointer = Metadata.getDataPointer(this.indexPosition);
        FileLock lock = file.getChannel().lock(recordHeaderPointer, 16L, false);
        file.seek(recordHeaderPointer);
        file.writeLong(this.dataPointer);
        file.writeInt(this.dataCapacity);
        file.writeInt(this.dataCount);
        lock.release();
    }

    void moveRecord(RandomAccessFile file, int newIndex) throws IOException {
        byte[] buf = new byte[32];
        long origHeaderKeyPointer = Metadata.getMetaDataPointer(this.indexPosition);
        FileLock lock = file.getChannel().lock(origHeaderKeyPointer, 48L, true);
        file.seek(origHeaderKeyPointer);
        file.readFully(buf);
        lock.release();
        long newHeaderKeyPointer = Metadata.getMetaDataPointer(newIndex);
        lock = file.getChannel().lock(newHeaderKeyPointer, 48L, false);
        file.seek(newHeaderKeyPointer);
        file.write(buf);
        lock.release();
        this.indexPosition = newIndex;
        this.writeDataInfo(file);
    }

    void moveData(RandomAccessFile file, long position) throws IOException {
        byte[] data = this.readDataRaw(file);
        this.dataPointer = position;
        this.dataCapacity = this.dataCount;
        FileLock lock = file.getChannel().lock(position, this.dataCount, false);
        file.setLength(position + (long)this.dataCount);
        file.seek(position);
        file.write(data);
        lock.release();
        this.writeDataInfo(file);
    }

    private byte[] readDataRaw(RandomAccessFile file) throws IOException {
        byte[] buf = new byte[this.dataCount];
        FileLock lock = file.getChannel().lock(this.dataPointer, this.dataCount, true);
        file.seek(this.dataPointer);
        file.readFully(buf);
        lock.release();
        return buf;
    }

    static <T> T readData(SerializationManager serializationManager, Input input) throws IOException {
        input.setInputStream(input.getInputStream());
        Object readObject = serializationManager.readFullClassAndObject(null, input);
        return (T)readObject;
    }

    static int writeData(SerializationManager serializationManager, Object data, Output output) throws IOException {
        output.clear();
        serializationManager.writeFullClassAndObject(null, output, data);
        output.flush();
        return (int)output.total();
    }

    void writeDataRaw(ByteArrayOutputStream byteArrayOutputStream, RandomAccessFile file) throws IOException {
        this.dataCount = byteArrayOutputStream.size();
        FileLock lock = file.getChannel().lock(this.dataPointer, this.dataCount, false);
        FileOutputStream out = new FileOutputStream(file.getFD());
        file.seek(this.dataPointer);
        byteArrayOutputStream.writeTo(out);
        lock.release();
    }

    public String toString() {
        return "RecordHeader [dataPointer=" + this.dataPointer + ", dataCount=" + this.dataCount + ", dataCapacity=" + this.dataCapacity + ", indexPosition=" + this.indexPosition + "]";
    }
}

