/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.util.storage;

import dorkbox.util.FileUtil;
import dorkbox.util.OS;
import dorkbox.util.SerializationManager;
import dorkbox.util.storage.DefaultStorageSerializationManager;
import dorkbox.util.storage.DiskStorage;
import dorkbox.util.storage.MemoryStorage;
import dorkbox.util.storage.Storage;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.helpers.NOPLogger;

public class StorageSystem {
    private static final Map<File, Storage> storages = new HashMap<File, Storage>(1);
    private static Thread shutdownHook = new Thread(new Runnable(){

        @Override
        public void run() {
            StorageSystem.shutdown();
        }
    });

    public static DiskMaker Disk() {
        return new DiskMaker();
    }

    public static MemoryMaker Memory() {
        return new MemoryMaker();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void close(File file) {
        Map<File, Storage> map = storages;
        synchronized (map) {
            DiskStorage diskStorage;
            boolean isLastOne;
            Storage storage = storages.get(file);
            if (storage != null && storage instanceof DiskStorage && (isLastOne = (diskStorage = (DiskStorage)storage).decrementReference())) {
                diskStorage.closeFully();
                storages.remove(file);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void close(Storage storage) {
        Map<File, Storage> map = storages;
        synchronized (map) {
            File file = storage.getFile();
            StorageSystem.close(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdown() {
        Map<File, Storage> map = storages;
        synchronized (map) {
            Collection<Storage> values = storages.values();
            for (Storage storage : values) {
                if (!(storage instanceof DiskStorage)) continue;
                DiskStorage diskStorage = (DiskStorage)storage;
                while (!diskStorage.decrementReference()) {
                }
                diskStorage.closeFully();
            }
            storages.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void delete(File file) {
        Map<File, Storage> map = storages;
        synchronized (map) {
            Storage remove = storages.remove(file);
            if (remove != null && remove instanceof DiskStorage) {
                ((DiskStorage)remove).closeFully();
            }
            file.delete();
        }
    }

    public static void delete(Storage storage) {
        File file = storage.getFile();
        StorageSystem.delete(file);
    }

    static {
        Runtime.getRuntime().addShutdownHook(shutdownHook);
    }

    public static class DiskMaker {
        private File file;
        private SerializationManager serializationManager;
        private boolean readOnly = false;
        private Logger logger = null;
        private long saveDelayInMilliseconds = 3000L;

        public DiskMaker file(File file) {
            this.file = FileUtil.normalize(file);
            return this;
        }

        public DiskMaker file(String file) {
            this.file = FileUtil.normalize(file);
            return this;
        }

        public DiskMaker serializer(SerializationManager serializationManager) {
            this.serializationManager = serializationManager;
            return this;
        }

        public DiskMaker readOnly() {
            this.readOnly = true;
            return this;
        }

        public DiskMaker setSaveDelay(long saveDelayInMilliseconds) {
            this.saveDelayInMilliseconds = saveDelayInMilliseconds;
            return this;
        }

        public DiskMaker logger(Logger logger) {
            this.logger = logger;
            return this;
        }

        public DiskMaker noLogger() {
            this.logger = NOPLogger.NOP_LOGGER;
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Storage build() {
            if (this.file == null) {
                throw new IllegalArgumentException("file cannot be null!");
            }
            if (this.serializationManager == null) {
                this.serializationManager = this.createDefaultSerializationManager();
            }
            Map map = storages;
            synchronized (map) {
                Storage storage = (Storage)storages.get(this.file);
                if (storage != null) {
                    if (!(storage instanceof DiskStorage)) throw new RuntimeException("Unable to change storage types for: " + this.file);
                    boolean waiting = storage.hasWriteWaiting();
                    if (waiting) {
                        storage.save();
                    }
                    ((DiskStorage)storage).increaseReference();
                } else {
                    try {
                        storage = new DiskStorage(this.file, this.serializationManager, this.readOnly, this.saveDelayInMilliseconds, this.logger);
                        storages.put(this.file, storage);
                    }
                    catch (IOException e) {
                        String message = e.getMessage();
                        int index = message.indexOf(OS.LINE_SEPARATOR);
                        if (index > -1) {
                            message = message.substring(0, index);
                        }
                        if (this.logger != null) {
                            this.logger.error("Unable to open storage file at {}. {}", (Object)this.file, (Object)message);
                        }
                        System.err.print("Unable to open storage file at " + this.file + ". " + message);
                    }
                }
                return storage;
            }
        }

        private SerializationManager createDefaultSerializationManager() {
            return new DefaultStorageSerializationManager();
        }
    }

    public static class MemoryMaker {
        public MemoryStorage build() {
            return new MemoryStorage();
        }
    }
}

