/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Map;

public class AdAssetLinkURL
extends APINode {
    @SerializedName(value="android_deeplink_url")
    private String mAndroidDeeplinkUrl = null;
    @SerializedName(value="carousel_see_more_url")
    private String mCarouselSeeMoreUrl = null;
    @SerializedName(value="deeplink_url")
    private String mDeeplinkUrl = null;
    @SerializedName(value="display_url")
    private String mDisplayUrl = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="ipad_deeplink_url")
    private String mIpadDeeplinkUrl = null;
    @SerializedName(value="iphone_deeplink_url")
    private String mIphoneDeeplinkUrl = null;
    @SerializedName(value="url_tags")
    private String mUrlTags = null;
    @SerializedName(value="website_url")
    private String mWebsiteUrl = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static AdAssetLinkURL loadJSON(String json, APIContext context, String header) {
        AdAssetLinkURL adAssetLinkURL = (AdAssetLinkURL)AdAssetLinkURL.getGson().fromJson(json, AdAssetLinkURL.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(adAssetLinkURL.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        adAssetLinkURL.context = context;
        adAssetLinkURL.rawValue = json;
        adAssetLinkURL.header = header;
        return adAssetLinkURL;
    }

    public static APINodeList<AdAssetLinkURL> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AdAssetLinkURL> adAssetLinkURLs = new APINodeList<AdAssetLinkURL>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        adAssetLinkURLs.add(AdAssetLinkURL.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return adAssetLinkURLs;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            adAssetLinkURLs.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        adAssetLinkURLs.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            adAssetLinkURLs.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            adAssetLinkURLs.add(AdAssetLinkURL.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                adAssetLinkURLs.add(AdAssetLinkURL.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            adAssetLinkURLs.add(AdAssetLinkURL.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return adAssetLinkURLs;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        adAssetLinkURLs.add(AdAssetLinkURL.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return adAssetLinkURLs;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        adAssetLinkURLs.add(AdAssetLinkURL.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return adAssetLinkURLs;
                }
                adAssetLinkURLs.clear();
                adAssetLinkURLs.add(AdAssetLinkURL.loadJSON(json, context, header));
                return adAssetLinkURLs;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AdAssetLinkURL.getGson().toJson((Object)this);
    }

    public String getFieldAndroidDeeplinkUrl() {
        return this.mAndroidDeeplinkUrl;
    }

    public AdAssetLinkURL setFieldAndroidDeeplinkUrl(String value) {
        this.mAndroidDeeplinkUrl = value;
        return this;
    }

    public String getFieldCarouselSeeMoreUrl() {
        return this.mCarouselSeeMoreUrl;
    }

    public AdAssetLinkURL setFieldCarouselSeeMoreUrl(String value) {
        this.mCarouselSeeMoreUrl = value;
        return this;
    }

    public String getFieldDeeplinkUrl() {
        return this.mDeeplinkUrl;
    }

    public AdAssetLinkURL setFieldDeeplinkUrl(String value) {
        this.mDeeplinkUrl = value;
        return this;
    }

    public String getFieldDisplayUrl() {
        return this.mDisplayUrl;
    }

    public AdAssetLinkURL setFieldDisplayUrl(String value) {
        this.mDisplayUrl = value;
        return this;
    }

    public String getFieldId() {
        return this.mId;
    }

    public AdAssetLinkURL setFieldId(String value) {
        this.mId = value;
        return this;
    }

    public String getFieldIpadDeeplinkUrl() {
        return this.mIpadDeeplinkUrl;
    }

    public AdAssetLinkURL setFieldIpadDeeplinkUrl(String value) {
        this.mIpadDeeplinkUrl = value;
        return this;
    }

    public String getFieldIphoneDeeplinkUrl() {
        return this.mIphoneDeeplinkUrl;
    }

    public AdAssetLinkURL setFieldIphoneDeeplinkUrl(String value) {
        this.mIphoneDeeplinkUrl = value;
        return this;
    }

    public String getFieldUrlTags() {
        return this.mUrlTags;
    }

    public AdAssetLinkURL setFieldUrlTags(String value) {
        this.mUrlTags = value;
        return this;
    }

    public String getFieldWebsiteUrl() {
        return this.mWebsiteUrl;
    }

    public AdAssetLinkURL setFieldWebsiteUrl(String value) {
        this.mWebsiteUrl = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AdAssetLinkURL copyFrom(AdAssetLinkURL instance) {
        this.mAndroidDeeplinkUrl = instance.mAndroidDeeplinkUrl;
        this.mCarouselSeeMoreUrl = instance.mCarouselSeeMoreUrl;
        this.mDeeplinkUrl = instance.mDeeplinkUrl;
        this.mDisplayUrl = instance.mDisplayUrl;
        this.mId = instance.mId;
        this.mIpadDeeplinkUrl = instance.mIpadDeeplinkUrl;
        this.mIphoneDeeplinkUrl = instance.mIphoneDeeplinkUrl;
        this.mUrlTags = instance.mUrlTags;
        this.mWebsiteUrl = instance.mWebsiteUrl;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AdAssetLinkURL> getParser() {
        return new APIRequest.ResponseParser<AdAssetLinkURL>(){

            @Override
            public APINodeList<AdAssetLinkURL> parseResponse(String response, APIContext context, APIRequest<AdAssetLinkURL> request, String header) throws APIException.MalformedResponseException {
                return AdAssetLinkURL.parseResponse(response, context, request, header);
            }
        };
    }
}

