/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Map;

public class AdConversions
extends APINode {
    @SerializedName(value="account_id")
    private String mAccountId = null;
    @SerializedName(value="adgroup_id")
    private String mAdgroupId = null;
    @SerializedName(value="campaign_id")
    private String mCampaignId = null;
    @SerializedName(value="values")
    private JsonArray mValues = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return null;
    }

    public static AdConversions loadJSON(String json, APIContext context, String header) {
        AdConversions adConversions = (AdConversions)AdConversions.getGson().fromJson(json, AdConversions.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(adConversions.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        adConversions.context = context;
        adConversions.rawValue = json;
        adConversions.header = header;
        return adConversions;
    }

    public static APINodeList<AdConversions> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AdConversions> adConversionss = new APINodeList<AdConversions>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        adConversionss.add(AdConversions.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return adConversionss;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            adConversionss.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        adConversionss.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            adConversionss.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            adConversionss.add(AdConversions.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                adConversionss.add(AdConversions.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            adConversionss.add(AdConversions.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return adConversionss;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        adConversionss.add(AdConversions.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return adConversionss;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        adConversionss.add(AdConversions.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return adConversionss;
                }
                adConversionss.clear();
                adConversionss.add(AdConversions.loadJSON(json, context, header));
                return adConversionss;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AdConversions.getGson().toJson((Object)this);
    }

    public String getFieldAccountId() {
        return this.mAccountId;
    }

    public AdConversions setFieldAccountId(String value) {
        this.mAccountId = value;
        return this;
    }

    public String getFieldAdgroupId() {
        return this.mAdgroupId;
    }

    public AdConversions setFieldAdgroupId(String value) {
        this.mAdgroupId = value;
        return this;
    }

    public String getFieldCampaignId() {
        return this.mCampaignId;
    }

    public AdConversions setFieldCampaignId(String value) {
        this.mCampaignId = value;
        return this;
    }

    public JsonArray getFieldValues() {
        return this.mValues;
    }

    public AdConversions setFieldValues(JsonArray value) {
        this.mValues = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AdConversions copyFrom(AdConversions instance) {
        this.mAccountId = instance.mAccountId;
        this.mAdgroupId = instance.mAdgroupId;
        this.mCampaignId = instance.mCampaignId;
        this.mValues = instance.mValues;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AdConversions> getParser() {
        return new APIRequest.ResponseParser<AdConversions>(){

            @Override
            public APINodeList<AdConversions> parseResponse(String response, APIContext context, APIRequest<AdConversions> request, String header) throws APIException.MalformedResponseException {
                return AdConversions.parseResponse(response, context, request, header);
            }
        };
    }
}

