/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.Comment;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;

public class AdgroupFacebookFeedback
extends APINode {
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="preview")
    private String mPreview = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static AdgroupFacebookFeedback loadJSON(String json, APIContext context, String header) {
        AdgroupFacebookFeedback adgroupFacebookFeedback = (AdgroupFacebookFeedback)AdgroupFacebookFeedback.getGson().fromJson(json, AdgroupFacebookFeedback.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(adgroupFacebookFeedback.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        adgroupFacebookFeedback.context = context;
        adgroupFacebookFeedback.rawValue = json;
        adgroupFacebookFeedback.header = header;
        return adgroupFacebookFeedback;
    }

    public static APINodeList<AdgroupFacebookFeedback> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AdgroupFacebookFeedback> adgroupFacebookFeedbacks = new APINodeList<AdgroupFacebookFeedback>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        adgroupFacebookFeedbacks.add(AdgroupFacebookFeedback.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return adgroupFacebookFeedbacks;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            adgroupFacebookFeedbacks.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        adgroupFacebookFeedbacks.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            adgroupFacebookFeedbacks.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            adgroupFacebookFeedbacks.add(AdgroupFacebookFeedback.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                adgroupFacebookFeedbacks.add(AdgroupFacebookFeedback.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            adgroupFacebookFeedbacks.add(AdgroupFacebookFeedback.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return adgroupFacebookFeedbacks;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        adgroupFacebookFeedbacks.add(AdgroupFacebookFeedback.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return adgroupFacebookFeedbacks;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        adgroupFacebookFeedbacks.add(AdgroupFacebookFeedback.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return adgroupFacebookFeedbacks;
                }
                adgroupFacebookFeedbacks.clear();
                adgroupFacebookFeedbacks.add(AdgroupFacebookFeedback.loadJSON(json, context, header));
                return adgroupFacebookFeedbacks;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AdgroupFacebookFeedback.getGson().toJson((Object)this);
    }

    public APIRequestGetComments getComments() {
        return new APIRequestGetComments(this.getId(), this.context);
    }

    public String getFieldId() {
        return this.mId;
    }

    public AdgroupFacebookFeedback setFieldId(String value) {
        this.mId = value;
        return this;
    }

    public String getFieldPreview() {
        return this.mPreview;
    }

    public AdgroupFacebookFeedback setFieldPreview(String value) {
        this.mPreview = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AdgroupFacebookFeedback copyFrom(AdgroupFacebookFeedback instance) {
        this.mId = instance.mId;
        this.mPreview = instance.mPreview;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AdgroupFacebookFeedback> getParser() {
        return new APIRequest.ResponseParser<AdgroupFacebookFeedback>(){

            @Override
            public APINodeList<AdgroupFacebookFeedback> parseResponse(String response, APIContext context, APIRequest<AdgroupFacebookFeedback> request, String header) throws APIException.MalformedResponseException {
                return AdgroupFacebookFeedback.parseResponse(response, context, request, header);
            }
        };
    }

    public static class APIRequestGetComments
    extends APIRequest<Comment> {
        APINodeList<Comment> lastResponse = null;
        public static final String[] PARAMS = new String[]{"order"};
        public static final String[] FIELDS = new String[]{"admin_creator", "application", "attachment", "can_comment", "can_hide", "can_like", "can_remove", "can_reply_privately", "comment_count", "created_time", "from", "id", "is_hidden", "is_private", "like_count", "live_broadcast_timestamp", "message", "message_tags", "object", "parent", "permalink_url", "private_reply_conversation", "user_likes"};

        @Override
        public APINodeList<Comment> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<Comment> parseResponse(String response, String header) throws APIException {
            return Comment.parseResponse(response, this.getContext(), (APIRequest)this, header);
        }

        @Override
        public APINodeList<Comment> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<Comment> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<Comment>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<Comment>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<Comment>>(){

                public APINodeList<Comment> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGetComments(String nodeId, APIContext context) {
            super(context, nodeId, "/comments", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetComments setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetComments setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetComments setOrder(Comment.EnumOrder order) {
            this.setParam("order", (Object)order);
            return this;
        }

        public APIRequestGetComments setOrder(String order) {
            this.setParam("order", order);
            return this;
        }

        public APIRequestGetComments requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetComments requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetComments requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetComments requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetComments requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetComments requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetComments requestAdminCreatorField() {
            return this.requestAdminCreatorField(true);
        }

        public APIRequestGetComments requestAdminCreatorField(boolean value) {
            this.requestField("admin_creator", value);
            return this;
        }

        public APIRequestGetComments requestApplicationField() {
            return this.requestApplicationField(true);
        }

        public APIRequestGetComments requestApplicationField(boolean value) {
            this.requestField("application", value);
            return this;
        }

        public APIRequestGetComments requestAttachmentField() {
            return this.requestAttachmentField(true);
        }

        public APIRequestGetComments requestAttachmentField(boolean value) {
            this.requestField("attachment", value);
            return this;
        }

        public APIRequestGetComments requestCanCommentField() {
            return this.requestCanCommentField(true);
        }

        public APIRequestGetComments requestCanCommentField(boolean value) {
            this.requestField("can_comment", value);
            return this;
        }

        public APIRequestGetComments requestCanHideField() {
            return this.requestCanHideField(true);
        }

        public APIRequestGetComments requestCanHideField(boolean value) {
            this.requestField("can_hide", value);
            return this;
        }

        public APIRequestGetComments requestCanLikeField() {
            return this.requestCanLikeField(true);
        }

        public APIRequestGetComments requestCanLikeField(boolean value) {
            this.requestField("can_like", value);
            return this;
        }

        public APIRequestGetComments requestCanRemoveField() {
            return this.requestCanRemoveField(true);
        }

        public APIRequestGetComments requestCanRemoveField(boolean value) {
            this.requestField("can_remove", value);
            return this;
        }

        public APIRequestGetComments requestCanReplyPrivatelyField() {
            return this.requestCanReplyPrivatelyField(true);
        }

        public APIRequestGetComments requestCanReplyPrivatelyField(boolean value) {
            this.requestField("can_reply_privately", value);
            return this;
        }

        public APIRequestGetComments requestCommentCountField() {
            return this.requestCommentCountField(true);
        }

        public APIRequestGetComments requestCommentCountField(boolean value) {
            this.requestField("comment_count", value);
            return this;
        }

        public APIRequestGetComments requestCreatedTimeField() {
            return this.requestCreatedTimeField(true);
        }

        public APIRequestGetComments requestCreatedTimeField(boolean value) {
            this.requestField("created_time", value);
            return this;
        }

        public APIRequestGetComments requestFromField() {
            return this.requestFromField(true);
        }

        public APIRequestGetComments requestFromField(boolean value) {
            this.requestField("from", value);
            return this;
        }

        public APIRequestGetComments requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetComments requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetComments requestIsHiddenField() {
            return this.requestIsHiddenField(true);
        }

        public APIRequestGetComments requestIsHiddenField(boolean value) {
            this.requestField("is_hidden", value);
            return this;
        }

        public APIRequestGetComments requestIsPrivateField() {
            return this.requestIsPrivateField(true);
        }

        public APIRequestGetComments requestIsPrivateField(boolean value) {
            this.requestField("is_private", value);
            return this;
        }

        public APIRequestGetComments requestLikeCountField() {
            return this.requestLikeCountField(true);
        }

        public APIRequestGetComments requestLikeCountField(boolean value) {
            this.requestField("like_count", value);
            return this;
        }

        public APIRequestGetComments requestLiveBroadcastTimestampField() {
            return this.requestLiveBroadcastTimestampField(true);
        }

        public APIRequestGetComments requestLiveBroadcastTimestampField(boolean value) {
            this.requestField("live_broadcast_timestamp", value);
            return this;
        }

        public APIRequestGetComments requestMessageField() {
            return this.requestMessageField(true);
        }

        public APIRequestGetComments requestMessageField(boolean value) {
            this.requestField("message", value);
            return this;
        }

        public APIRequestGetComments requestMessageTagsField() {
            return this.requestMessageTagsField(true);
        }

        public APIRequestGetComments requestMessageTagsField(boolean value) {
            this.requestField("message_tags", value);
            return this;
        }

        public APIRequestGetComments requestObjectField() {
            return this.requestObjectField(true);
        }

        public APIRequestGetComments requestObjectField(boolean value) {
            this.requestField("object", value);
            return this;
        }

        public APIRequestGetComments requestParentField() {
            return this.requestParentField(true);
        }

        public APIRequestGetComments requestParentField(boolean value) {
            this.requestField("parent", value);
            return this;
        }

        public APIRequestGetComments requestPermalinkUrlField() {
            return this.requestPermalinkUrlField(true);
        }

        public APIRequestGetComments requestPermalinkUrlField(boolean value) {
            this.requestField("permalink_url", value);
            return this;
        }

        public APIRequestGetComments requestPrivateReplyConversationField() {
            return this.requestPrivateReplyConversationField(true);
        }

        public APIRequestGetComments requestPrivateReplyConversationField(boolean value) {
            this.requestField("private_reply_conversation", value);
            return this;
        }

        public APIRequestGetComments requestUserLikesField() {
            return this.requestUserLikesField(true);
        }

        public APIRequestGetComments requestUserLikesField(boolean value) {
            this.requestField("user_likes", value);
            return this;
        }
    }
}

