/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;

public class AdsNamingTemplate
extends APINode {
    @SerializedName(value="api_fields")
    private List<List<Map<String, List<Map<String, String>>>>> mApiFields = null;
    @SerializedName(value="api_version")
    private String mApiVersion = null;
    @SerializedName(value="field_order")
    private List<String> mFieldOrder = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="level")
    private EnumLevel mLevel = null;
    @SerializedName(value="separator")
    private String mSeparator = null;
    @SerializedName(value="template_version")
    private String mTemplateVersion = null;
    @SerializedName(value="user_defined_fields")
    private List<List<Map<String, List<String>>>> mUserDefinedFields = null;
    @SerializedName(value="value_separator")
    private String mValueSeparator = null;
    protected static Gson gson = null;

    AdsNamingTemplate() {
    }

    public AdsNamingTemplate(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public AdsNamingTemplate(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public AdsNamingTemplate fetch() throws APIException {
        AdsNamingTemplate newInstance = AdsNamingTemplate.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static AdsNamingTemplate fetchById(Long id, APIContext context) throws APIException {
        return AdsNamingTemplate.fetchById(id.toString(), context);
    }

    public static ListenableFuture<AdsNamingTemplate> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return AdsNamingTemplate.fetchByIdAsync(id.toString(), context);
    }

    public static AdsNamingTemplate fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<AdsNamingTemplate> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<AdsNamingTemplate> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<AdsNamingTemplate>(context, "", "/", "GET", AdsNamingTemplate.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<AdsNamingTemplate>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<AdsNamingTemplate>(context, "", "/", "GET", AdsNamingTemplate.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static AdsNamingTemplate loadJSON(String json, APIContext context, String header) {
        AdsNamingTemplate adsNamingTemplate = (AdsNamingTemplate)AdsNamingTemplate.getGson().fromJson(json, AdsNamingTemplate.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(adsNamingTemplate.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        adsNamingTemplate.context = context;
        adsNamingTemplate.rawValue = json;
        adsNamingTemplate.header = header;
        return adsNamingTemplate;
    }

    public static APINodeList<AdsNamingTemplate> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AdsNamingTemplate> adsNamingTemplates = new APINodeList<AdsNamingTemplate>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        adsNamingTemplates.add(AdsNamingTemplate.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return adsNamingTemplates;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            adsNamingTemplates.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        adsNamingTemplates.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            adsNamingTemplates.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            adsNamingTemplates.add(AdsNamingTemplate.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                adsNamingTemplates.add(AdsNamingTemplate.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            adsNamingTemplates.add(AdsNamingTemplate.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return adsNamingTemplates;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        adsNamingTemplates.add(AdsNamingTemplate.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return adsNamingTemplates;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        adsNamingTemplates.add(AdsNamingTemplate.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return adsNamingTemplates;
                }
                adsNamingTemplates.clear();
                adsNamingTemplates.add(AdsNamingTemplate.loadJSON(json, context, header));
                return adsNamingTemplates;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AdsNamingTemplate.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public List<List<Map<String, List<Map<String, String>>>>> getFieldApiFields() {
        return this.mApiFields;
    }

    public String getFieldApiVersion() {
        return this.mApiVersion;
    }

    public List<String> getFieldFieldOrder() {
        return this.mFieldOrder;
    }

    public String getFieldId() {
        return this.mId;
    }

    public EnumLevel getFieldLevel() {
        return this.mLevel;
    }

    public String getFieldSeparator() {
        return this.mSeparator;
    }

    public String getFieldTemplateVersion() {
        return this.mTemplateVersion;
    }

    public List<List<Map<String, List<String>>>> getFieldUserDefinedFields() {
        return this.mUserDefinedFields;
    }

    public String getFieldValueSeparator() {
        return this.mValueSeparator;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AdsNamingTemplate copyFrom(AdsNamingTemplate instance) {
        this.mApiFields = instance.mApiFields;
        this.mApiVersion = instance.mApiVersion;
        this.mFieldOrder = instance.mFieldOrder;
        this.mId = instance.mId;
        this.mLevel = instance.mLevel;
        this.mSeparator = instance.mSeparator;
        this.mTemplateVersion = instance.mTemplateVersion;
        this.mUserDefinedFields = instance.mUserDefinedFields;
        this.mValueSeparator = instance.mValueSeparator;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AdsNamingTemplate> getParser() {
        return new APIRequest.ResponseParser<AdsNamingTemplate>(){

            @Override
            public APINodeList<AdsNamingTemplate> parseResponse(String response, APIContext context, APIRequest<AdsNamingTemplate> request, String header) throws APIException.MalformedResponseException {
                return AdsNamingTemplate.parseResponse(response, context, request, header);
            }
        };
    }

    public static enum EnumLevel {
        VALUE_ADGROUP("ADGROUP"),
        VALUE_AD_ACCOUNT("AD_ACCOUNT"),
        VALUE_CAMPAIGN("CAMPAIGN"),
        VALUE_CAMPAIGN_GROUP("CAMPAIGN_GROUP"),
        VALUE_OPPORTUNITIES("OPPORTUNITIES"),
        VALUE_PRIVACY_INFO_CENTER("PRIVACY_INFO_CENTER"),
        VALUE_TOPLINE("TOPLINE"),
        VALUE_UNIQUE_ADCREATIVE("UNIQUE_ADCREATIVE");

        private String value;

        private EnumLevel(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static class APIRequestGet
    extends APIRequest<AdsNamingTemplate> {
        AdsNamingTemplate lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"api_fields", "api_version", "field_order", "id", "level", "separator", "template_version", "user_defined_fields", "value_separator"};

        @Override
        public AdsNamingTemplate getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AdsNamingTemplate parseResponse(String response, String header) throws APIException {
            return AdsNamingTemplate.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public AdsNamingTemplate execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AdsNamingTemplate execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<AdsNamingTemplate> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<AdsNamingTemplate> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, AdsNamingTemplate>(){

                public AdsNamingTemplate apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestApiFieldsField() {
            return this.requestApiFieldsField(true);
        }

        public APIRequestGet requestApiFieldsField(boolean value) {
            this.requestField("api_fields", value);
            return this;
        }

        public APIRequestGet requestApiVersionField() {
            return this.requestApiVersionField(true);
        }

        public APIRequestGet requestApiVersionField(boolean value) {
            this.requestField("api_version", value);
            return this;
        }

        public APIRequestGet requestFieldOrderField() {
            return this.requestFieldOrderField(true);
        }

        public APIRequestGet requestFieldOrderField(boolean value) {
            this.requestField("field_order", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestLevelField() {
            return this.requestLevelField(true);
        }

        public APIRequestGet requestLevelField(boolean value) {
            this.requestField("level", value);
            return this;
        }

        public APIRequestGet requestSeparatorField() {
            return this.requestSeparatorField(true);
        }

        public APIRequestGet requestSeparatorField(boolean value) {
            this.requestField("separator", value);
            return this;
        }

        public APIRequestGet requestTemplateVersionField() {
            return this.requestTemplateVersionField(true);
        }

        public APIRequestGet requestTemplateVersionField(boolean value) {
            this.requestField("template_version", value);
            return this;
        }

        public APIRequestGet requestUserDefinedFieldsField() {
            return this.requestUserDefinedFieldsField(true);
        }

        public APIRequestGet requestUserDefinedFieldsField(boolean value) {
            this.requestField("user_defined_fields", value);
            return this;
        }

        public APIRequestGet requestValueSeparatorField() {
            return this.requestValueSeparatorField(true);
        }

        public APIRequestGet requestValueSeparatorField(boolean value) {
            this.requestField("value_separator", value);
            return this;
        }
    }
}

