/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.List;
import java.util.Map;

public class AnalyticsConfig
extends APINode {
    @SerializedName(value="analytics_access_for_authorized_ad_account")
    private Boolean mAnalyticsAccessForAuthorizedAdAccount = null;
    @SerializedName(value="breakdowns_config")
    private List<Object> mBreakdownsConfig = null;
    @SerializedName(value="builtin_fields_config")
    private List<Object> mBuiltinFieldsConfig = null;
    @SerializedName(value="deprecated_events_config")
    private List<Object> mDeprecatedEventsConfig = null;
    @SerializedName(value="events_config")
    private List<Object> mEventsConfig = null;
    @SerializedName(value="ios_purchase_validation_secret")
    private String mIosPurchaseValidationSecret = null;
    @SerializedName(value="is_any_role_able_to_see_restricted_insights")
    private Boolean mIsAnyRoleAbleToSeeRestrictedInsights = null;
    @SerializedName(value="is_implicit_purchase_logging_on_android_supported")
    private Boolean mIsImplicitPurchaseLoggingOnAndroidSupported = null;
    @SerializedName(value="is_implicit_purchase_logging_on_ios_supported")
    private Boolean mIsImplicitPurchaseLoggingOnIosSupported = null;
    @SerializedName(value="is_track_ios_app_uninstall_supported")
    private Boolean mIsTrackIosAppUninstallSupported = null;
    @SerializedName(value="journey_backfill_status")
    private String mJourneyBackfillStatus = null;
    @SerializedName(value="journey_conversion_events")
    private List<String> mJourneyConversionEvents = null;
    @SerializedName(value="journey_enabled")
    private Boolean mJourneyEnabled = null;
    @SerializedName(value="journey_impacting_change_time")
    private String mJourneyImpactingChangeTime = null;
    @SerializedName(value="journey_timeout")
    private String mJourneyTimeout = null;
    @SerializedName(value="latest_sdk_versions")
    private Map<String, String> mLatestSdkVersions = null;
    @SerializedName(value="log_android_implicit_purchase_events")
    private Boolean mLogAndroidImplicitPurchaseEvents = null;
    @SerializedName(value="log_automatic_analytics_events")
    private Boolean mLogAutomaticAnalyticsEvents = null;
    @SerializedName(value="log_implicit_purchase_events")
    private Boolean mLogImplicitPurchaseEvents = null;
    @SerializedName(value="prev_journey_conversion_events")
    private List<String> mPrevJourneyConversionEvents = null;
    @SerializedName(value="query_approximation_accuracy_level")
    private String mQueryApproximationAccuracyLevel = null;
    @SerializedName(value="query_currency")
    private String mQueryCurrency = null;
    @SerializedName(value="query_timezone")
    private String mQueryTimezone = null;
    @SerializedName(value="recent_events_update_time")
    private String mRecentEventsUpdateTime = null;
    @SerializedName(value="session_timeout_interval")
    private Long mSessionTimeoutInterval = null;
    @SerializedName(value="track_ios_app_uninstall")
    private Boolean mTrackIosAppUninstall = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return null;
    }

    public static AnalyticsConfig loadJSON(String json, APIContext context, String header) {
        AnalyticsConfig analyticsConfig = (AnalyticsConfig)AnalyticsConfig.getGson().fromJson(json, AnalyticsConfig.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(analyticsConfig.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        analyticsConfig.context = context;
        analyticsConfig.rawValue = json;
        analyticsConfig.header = header;
        return analyticsConfig;
    }

    public static APINodeList<AnalyticsConfig> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AnalyticsConfig> analyticsConfigs = new APINodeList<AnalyticsConfig>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        analyticsConfigs.add(AnalyticsConfig.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return analyticsConfigs;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            analyticsConfigs.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        analyticsConfigs.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            analyticsConfigs.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            analyticsConfigs.add(AnalyticsConfig.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                analyticsConfigs.add(AnalyticsConfig.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            analyticsConfigs.add(AnalyticsConfig.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return analyticsConfigs;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        analyticsConfigs.add(AnalyticsConfig.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return analyticsConfigs;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        analyticsConfigs.add(AnalyticsConfig.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return analyticsConfigs;
                }
                analyticsConfigs.clear();
                analyticsConfigs.add(AnalyticsConfig.loadJSON(json, context, header));
                return analyticsConfigs;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AnalyticsConfig.getGson().toJson((Object)this);
    }

    public Boolean getFieldAnalyticsAccessForAuthorizedAdAccount() {
        return this.mAnalyticsAccessForAuthorizedAdAccount;
    }

    public AnalyticsConfig setFieldAnalyticsAccessForAuthorizedAdAccount(Boolean value) {
        this.mAnalyticsAccessForAuthorizedAdAccount = value;
        return this;
    }

    public List<Object> getFieldBreakdownsConfig() {
        return this.mBreakdownsConfig;
    }

    public AnalyticsConfig setFieldBreakdownsConfig(List<Object> value) {
        this.mBreakdownsConfig = value;
        return this;
    }

    public List<Object> getFieldBuiltinFieldsConfig() {
        return this.mBuiltinFieldsConfig;
    }

    public AnalyticsConfig setFieldBuiltinFieldsConfig(List<Object> value) {
        this.mBuiltinFieldsConfig = value;
        return this;
    }

    public List<Object> getFieldDeprecatedEventsConfig() {
        return this.mDeprecatedEventsConfig;
    }

    public AnalyticsConfig setFieldDeprecatedEventsConfig(List<Object> value) {
        this.mDeprecatedEventsConfig = value;
        return this;
    }

    public List<Object> getFieldEventsConfig() {
        return this.mEventsConfig;
    }

    public AnalyticsConfig setFieldEventsConfig(List<Object> value) {
        this.mEventsConfig = value;
        return this;
    }

    public String getFieldIosPurchaseValidationSecret() {
        return this.mIosPurchaseValidationSecret;
    }

    public AnalyticsConfig setFieldIosPurchaseValidationSecret(String value) {
        this.mIosPurchaseValidationSecret = value;
        return this;
    }

    public Boolean getFieldIsAnyRoleAbleToSeeRestrictedInsights() {
        return this.mIsAnyRoleAbleToSeeRestrictedInsights;
    }

    public AnalyticsConfig setFieldIsAnyRoleAbleToSeeRestrictedInsights(Boolean value) {
        this.mIsAnyRoleAbleToSeeRestrictedInsights = value;
        return this;
    }

    public Boolean getFieldIsImplicitPurchaseLoggingOnAndroidSupported() {
        return this.mIsImplicitPurchaseLoggingOnAndroidSupported;
    }

    public AnalyticsConfig setFieldIsImplicitPurchaseLoggingOnAndroidSupported(Boolean value) {
        this.mIsImplicitPurchaseLoggingOnAndroidSupported = value;
        return this;
    }

    public Boolean getFieldIsImplicitPurchaseLoggingOnIosSupported() {
        return this.mIsImplicitPurchaseLoggingOnIosSupported;
    }

    public AnalyticsConfig setFieldIsImplicitPurchaseLoggingOnIosSupported(Boolean value) {
        this.mIsImplicitPurchaseLoggingOnIosSupported = value;
        return this;
    }

    public Boolean getFieldIsTrackIosAppUninstallSupported() {
        return this.mIsTrackIosAppUninstallSupported;
    }

    public AnalyticsConfig setFieldIsTrackIosAppUninstallSupported(Boolean value) {
        this.mIsTrackIosAppUninstallSupported = value;
        return this;
    }

    public String getFieldJourneyBackfillStatus() {
        return this.mJourneyBackfillStatus;
    }

    public AnalyticsConfig setFieldJourneyBackfillStatus(String value) {
        this.mJourneyBackfillStatus = value;
        return this;
    }

    public List<String> getFieldJourneyConversionEvents() {
        return this.mJourneyConversionEvents;
    }

    public AnalyticsConfig setFieldJourneyConversionEvents(List<String> value) {
        this.mJourneyConversionEvents = value;
        return this;
    }

    public Boolean getFieldJourneyEnabled() {
        return this.mJourneyEnabled;
    }

    public AnalyticsConfig setFieldJourneyEnabled(Boolean value) {
        this.mJourneyEnabled = value;
        return this;
    }

    public String getFieldJourneyImpactingChangeTime() {
        return this.mJourneyImpactingChangeTime;
    }

    public AnalyticsConfig setFieldJourneyImpactingChangeTime(String value) {
        this.mJourneyImpactingChangeTime = value;
        return this;
    }

    public String getFieldJourneyTimeout() {
        return this.mJourneyTimeout;
    }

    public AnalyticsConfig setFieldJourneyTimeout(String value) {
        this.mJourneyTimeout = value;
        return this;
    }

    public Map<String, String> getFieldLatestSdkVersions() {
        return this.mLatestSdkVersions;
    }

    public AnalyticsConfig setFieldLatestSdkVersions(Map<String, String> value) {
        this.mLatestSdkVersions = value;
        return this;
    }

    public Boolean getFieldLogAndroidImplicitPurchaseEvents() {
        return this.mLogAndroidImplicitPurchaseEvents;
    }

    public AnalyticsConfig setFieldLogAndroidImplicitPurchaseEvents(Boolean value) {
        this.mLogAndroidImplicitPurchaseEvents = value;
        return this;
    }

    public Boolean getFieldLogAutomaticAnalyticsEvents() {
        return this.mLogAutomaticAnalyticsEvents;
    }

    public AnalyticsConfig setFieldLogAutomaticAnalyticsEvents(Boolean value) {
        this.mLogAutomaticAnalyticsEvents = value;
        return this;
    }

    public Boolean getFieldLogImplicitPurchaseEvents() {
        return this.mLogImplicitPurchaseEvents;
    }

    public AnalyticsConfig setFieldLogImplicitPurchaseEvents(Boolean value) {
        this.mLogImplicitPurchaseEvents = value;
        return this;
    }

    public List<String> getFieldPrevJourneyConversionEvents() {
        return this.mPrevJourneyConversionEvents;
    }

    public AnalyticsConfig setFieldPrevJourneyConversionEvents(List<String> value) {
        this.mPrevJourneyConversionEvents = value;
        return this;
    }

    public String getFieldQueryApproximationAccuracyLevel() {
        return this.mQueryApproximationAccuracyLevel;
    }

    public AnalyticsConfig setFieldQueryApproximationAccuracyLevel(String value) {
        this.mQueryApproximationAccuracyLevel = value;
        return this;
    }

    public String getFieldQueryCurrency() {
        return this.mQueryCurrency;
    }

    public AnalyticsConfig setFieldQueryCurrency(String value) {
        this.mQueryCurrency = value;
        return this;
    }

    public String getFieldQueryTimezone() {
        return this.mQueryTimezone;
    }

    public AnalyticsConfig setFieldQueryTimezone(String value) {
        this.mQueryTimezone = value;
        return this;
    }

    public String getFieldRecentEventsUpdateTime() {
        return this.mRecentEventsUpdateTime;
    }

    public AnalyticsConfig setFieldRecentEventsUpdateTime(String value) {
        this.mRecentEventsUpdateTime = value;
        return this;
    }

    public Long getFieldSessionTimeoutInterval() {
        return this.mSessionTimeoutInterval;
    }

    public AnalyticsConfig setFieldSessionTimeoutInterval(Long value) {
        this.mSessionTimeoutInterval = value;
        return this;
    }

    public Boolean getFieldTrackIosAppUninstall() {
        return this.mTrackIosAppUninstall;
    }

    public AnalyticsConfig setFieldTrackIosAppUninstall(Boolean value) {
        this.mTrackIosAppUninstall = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AnalyticsConfig copyFrom(AnalyticsConfig instance) {
        this.mAnalyticsAccessForAuthorizedAdAccount = instance.mAnalyticsAccessForAuthorizedAdAccount;
        this.mBreakdownsConfig = instance.mBreakdownsConfig;
        this.mBuiltinFieldsConfig = instance.mBuiltinFieldsConfig;
        this.mDeprecatedEventsConfig = instance.mDeprecatedEventsConfig;
        this.mEventsConfig = instance.mEventsConfig;
        this.mIosPurchaseValidationSecret = instance.mIosPurchaseValidationSecret;
        this.mIsAnyRoleAbleToSeeRestrictedInsights = instance.mIsAnyRoleAbleToSeeRestrictedInsights;
        this.mIsImplicitPurchaseLoggingOnAndroidSupported = instance.mIsImplicitPurchaseLoggingOnAndroidSupported;
        this.mIsImplicitPurchaseLoggingOnIosSupported = instance.mIsImplicitPurchaseLoggingOnIosSupported;
        this.mIsTrackIosAppUninstallSupported = instance.mIsTrackIosAppUninstallSupported;
        this.mJourneyBackfillStatus = instance.mJourneyBackfillStatus;
        this.mJourneyConversionEvents = instance.mJourneyConversionEvents;
        this.mJourneyEnabled = instance.mJourneyEnabled;
        this.mJourneyImpactingChangeTime = instance.mJourneyImpactingChangeTime;
        this.mJourneyTimeout = instance.mJourneyTimeout;
        this.mLatestSdkVersions = instance.mLatestSdkVersions;
        this.mLogAndroidImplicitPurchaseEvents = instance.mLogAndroidImplicitPurchaseEvents;
        this.mLogAutomaticAnalyticsEvents = instance.mLogAutomaticAnalyticsEvents;
        this.mLogImplicitPurchaseEvents = instance.mLogImplicitPurchaseEvents;
        this.mPrevJourneyConversionEvents = instance.mPrevJourneyConversionEvents;
        this.mQueryApproximationAccuracyLevel = instance.mQueryApproximationAccuracyLevel;
        this.mQueryCurrency = instance.mQueryCurrency;
        this.mQueryTimezone = instance.mQueryTimezone;
        this.mRecentEventsUpdateTime = instance.mRecentEventsUpdateTime;
        this.mSessionTimeoutInterval = instance.mSessionTimeoutInterval;
        this.mTrackIosAppUninstall = instance.mTrackIosAppUninstall;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AnalyticsConfig> getParser() {
        return new APIRequest.ResponseParser<AnalyticsConfig>(){

            @Override
            public APINodeList<AnalyticsConfig> parseResponse(String response, APIContext context, APIRequest<AnalyticsConfig> request, String header) throws APIException.MalformedResponseException {
                return AnalyticsConfig.parseResponse(response, context, request, header);
            }
        };
    }
}

