/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.List;
import java.util.Map;

public class BusinessTrafficAnalysisReport
extends APINode {
    @SerializedName(value="audience_location")
    private List<Object> mAudienceLocation = null;
    @SerializedName(value="event_category")
    private List<Object> mEventCategory = null;
    @SerializedName(value="traffic_analysis_impressions")
    private List<Object> mTrafficAnalysisImpressions = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return null;
    }

    public static BusinessTrafficAnalysisReport loadJSON(String json, APIContext context, String header) {
        BusinessTrafficAnalysisReport businessTrafficAnalysisReport = (BusinessTrafficAnalysisReport)BusinessTrafficAnalysisReport.getGson().fromJson(json, BusinessTrafficAnalysisReport.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(businessTrafficAnalysisReport.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        businessTrafficAnalysisReport.context = context;
        businessTrafficAnalysisReport.rawValue = json;
        businessTrafficAnalysisReport.header = header;
        return businessTrafficAnalysisReport;
    }

    public static APINodeList<BusinessTrafficAnalysisReport> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<BusinessTrafficAnalysisReport> businessTrafficAnalysisReports = new APINodeList<BusinessTrafficAnalysisReport>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        businessTrafficAnalysisReports.add(BusinessTrafficAnalysisReport.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return businessTrafficAnalysisReports;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            businessTrafficAnalysisReports.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        businessTrafficAnalysisReports.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            businessTrafficAnalysisReports.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            businessTrafficAnalysisReports.add(BusinessTrafficAnalysisReport.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                businessTrafficAnalysisReports.add(BusinessTrafficAnalysisReport.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            businessTrafficAnalysisReports.add(BusinessTrafficAnalysisReport.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return businessTrafficAnalysisReports;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        businessTrafficAnalysisReports.add(BusinessTrafficAnalysisReport.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return businessTrafficAnalysisReports;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        businessTrafficAnalysisReports.add(BusinessTrafficAnalysisReport.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return businessTrafficAnalysisReports;
                }
                businessTrafficAnalysisReports.clear();
                businessTrafficAnalysisReports.add(BusinessTrafficAnalysisReport.loadJSON(json, context, header));
                return businessTrafficAnalysisReports;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return BusinessTrafficAnalysisReport.getGson().toJson((Object)this);
    }

    public List<Object> getFieldAudienceLocation() {
        return this.mAudienceLocation;
    }

    public BusinessTrafficAnalysisReport setFieldAudienceLocation(List<Object> value) {
        this.mAudienceLocation = value;
        return this;
    }

    public List<Object> getFieldEventCategory() {
        return this.mEventCategory;
    }

    public BusinessTrafficAnalysisReport setFieldEventCategory(List<Object> value) {
        this.mEventCategory = value;
        return this;
    }

    public List<Object> getFieldTrafficAnalysisImpressions() {
        return this.mTrafficAnalysisImpressions;
    }

    public BusinessTrafficAnalysisReport setFieldTrafficAnalysisImpressions(List<Object> value) {
        this.mTrafficAnalysisImpressions = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public BusinessTrafficAnalysisReport copyFrom(BusinessTrafficAnalysisReport instance) {
        this.mAudienceLocation = instance.mAudienceLocation;
        this.mEventCategory = instance.mEventCategory;
        this.mTrafficAnalysisImpressions = instance.mTrafficAnalysisImpressions;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<BusinessTrafficAnalysisReport> getParser() {
        return new APIRequest.ResponseParser<BusinessTrafficAnalysisReport>(){

            @Override
            public APINodeList<BusinessTrafficAnalysisReport> parseResponse(String response, APIContext context, APIRequest<BusinessTrafficAnalysisReport> request, String header) throws APIException.MalformedResponseException {
                return BusinessTrafficAnalysisReport.parseResponse(response, context, request, header);
            }
        };
    }
}

