/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Map;

public class ContentDeliveryReport
extends APINode {
    @SerializedName(value="content_name")
    private String mContentName = null;
    @SerializedName(value="content_url")
    private String mContentUrl = null;
    @SerializedName(value="creator_name")
    private String mCreatorName = null;
    @SerializedName(value="creator_url")
    private String mCreatorUrl = null;
    @SerializedName(value="estimated_impressions")
    private Long mEstimatedImpressions = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return null;
    }

    public static ContentDeliveryReport loadJSON(String json, APIContext context, String header) {
        ContentDeliveryReport contentDeliveryReport = (ContentDeliveryReport)ContentDeliveryReport.getGson().fromJson(json, ContentDeliveryReport.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(contentDeliveryReport.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        contentDeliveryReport.context = context;
        contentDeliveryReport.rawValue = json;
        contentDeliveryReport.header = header;
        return contentDeliveryReport;
    }

    public static APINodeList<ContentDeliveryReport> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<ContentDeliveryReport> contentDeliveryReports = new APINodeList<ContentDeliveryReport>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        contentDeliveryReports.add(ContentDeliveryReport.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return contentDeliveryReports;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            contentDeliveryReports.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        contentDeliveryReports.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            contentDeliveryReports.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            contentDeliveryReports.add(ContentDeliveryReport.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                contentDeliveryReports.add(ContentDeliveryReport.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            contentDeliveryReports.add(ContentDeliveryReport.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return contentDeliveryReports;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        contentDeliveryReports.add(ContentDeliveryReport.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return contentDeliveryReports;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        contentDeliveryReports.add(ContentDeliveryReport.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return contentDeliveryReports;
                }
                contentDeliveryReports.clear();
                contentDeliveryReports.add(ContentDeliveryReport.loadJSON(json, context, header));
                return contentDeliveryReports;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return ContentDeliveryReport.getGson().toJson((Object)this);
    }

    public String getFieldContentName() {
        return this.mContentName;
    }

    public ContentDeliveryReport setFieldContentName(String value) {
        this.mContentName = value;
        return this;
    }

    public String getFieldContentUrl() {
        return this.mContentUrl;
    }

    public ContentDeliveryReport setFieldContentUrl(String value) {
        this.mContentUrl = value;
        return this;
    }

    public String getFieldCreatorName() {
        return this.mCreatorName;
    }

    public ContentDeliveryReport setFieldCreatorName(String value) {
        this.mCreatorName = value;
        return this;
    }

    public String getFieldCreatorUrl() {
        return this.mCreatorUrl;
    }

    public ContentDeliveryReport setFieldCreatorUrl(String value) {
        this.mCreatorUrl = value;
        return this;
    }

    public Long getFieldEstimatedImpressions() {
        return this.mEstimatedImpressions;
    }

    public ContentDeliveryReport setFieldEstimatedImpressions(Long value) {
        this.mEstimatedImpressions = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public ContentDeliveryReport copyFrom(ContentDeliveryReport instance) {
        this.mContentName = instance.mContentName;
        this.mContentUrl = instance.mContentUrl;
        this.mCreatorName = instance.mCreatorName;
        this.mCreatorUrl = instance.mCreatorUrl;
        this.mEstimatedImpressions = instance.mEstimatedImpressions;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<ContentDeliveryReport> getParser() {
        return new APIRequest.ResponseParser<ContentDeliveryReport>(){

            @Override
            public APINodeList<ContentDeliveryReport> parseResponse(String response, APIContext context, APIRequest<ContentDeliveryReport> request, String header) throws APIException.MalformedResponseException {
                return ContentDeliveryReport.parseResponse(response, context, request, header);
            }
        };
    }
}

