/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;

public class CreatorAssetCreative
extends APINode {
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="image_url")
    private String mImageUrl = null;
    @SerializedName(value="moderation_status")
    private String mModerationStatus = null;
    @SerializedName(value="product_item_retailer_id")
    private String mProductItemRetailerId = null;
    @SerializedName(value="product_url")
    private String mProductUrl = null;
    @SerializedName(value="retailer_id")
    private String mRetailerId = null;
    @SerializedName(value="video_url")
    private String mVideoUrl = null;
    protected static Gson gson = null;

    CreatorAssetCreative() {
    }

    public CreatorAssetCreative(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public CreatorAssetCreative(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public CreatorAssetCreative fetch() throws APIException {
        CreatorAssetCreative newInstance = CreatorAssetCreative.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static CreatorAssetCreative fetchById(Long id, APIContext context) throws APIException {
        return CreatorAssetCreative.fetchById(id.toString(), context);
    }

    public static ListenableFuture<CreatorAssetCreative> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return CreatorAssetCreative.fetchByIdAsync(id.toString(), context);
    }

    public static CreatorAssetCreative fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<CreatorAssetCreative> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<CreatorAssetCreative> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<CreatorAssetCreative>(context, "", "/", "GET", CreatorAssetCreative.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<CreatorAssetCreative>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<CreatorAssetCreative>(context, "", "/", "GET", CreatorAssetCreative.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static CreatorAssetCreative loadJSON(String json, APIContext context, String header) {
        CreatorAssetCreative creatorAssetCreative = (CreatorAssetCreative)CreatorAssetCreative.getGson().fromJson(json, CreatorAssetCreative.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(creatorAssetCreative.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        creatorAssetCreative.context = context;
        creatorAssetCreative.rawValue = json;
        creatorAssetCreative.header = header;
        return creatorAssetCreative;
    }

    public static APINodeList<CreatorAssetCreative> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<CreatorAssetCreative> creatorAssetCreatives = new APINodeList<CreatorAssetCreative>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        creatorAssetCreatives.add(CreatorAssetCreative.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return creatorAssetCreatives;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            creatorAssetCreatives.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        creatorAssetCreatives.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            creatorAssetCreatives.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            creatorAssetCreatives.add(CreatorAssetCreative.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                creatorAssetCreatives.add(CreatorAssetCreative.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            creatorAssetCreatives.add(CreatorAssetCreative.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return creatorAssetCreatives;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        creatorAssetCreatives.add(CreatorAssetCreative.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return creatorAssetCreatives;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        creatorAssetCreatives.add(CreatorAssetCreative.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return creatorAssetCreatives;
                }
                creatorAssetCreatives.clear();
                creatorAssetCreatives.add(CreatorAssetCreative.loadJSON(json, context, header));
                return creatorAssetCreatives;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return CreatorAssetCreative.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldId() {
        return this.mId;
    }

    public String getFieldImageUrl() {
        return this.mImageUrl;
    }

    public String getFieldModerationStatus() {
        return this.mModerationStatus;
    }

    public String getFieldProductItemRetailerId() {
        return this.mProductItemRetailerId;
    }

    public String getFieldProductUrl() {
        return this.mProductUrl;
    }

    public String getFieldRetailerId() {
        return this.mRetailerId;
    }

    public String getFieldVideoUrl() {
        return this.mVideoUrl;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public CreatorAssetCreative copyFrom(CreatorAssetCreative instance) {
        this.mId = instance.mId;
        this.mImageUrl = instance.mImageUrl;
        this.mModerationStatus = instance.mModerationStatus;
        this.mProductItemRetailerId = instance.mProductItemRetailerId;
        this.mProductUrl = instance.mProductUrl;
        this.mRetailerId = instance.mRetailerId;
        this.mVideoUrl = instance.mVideoUrl;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<CreatorAssetCreative> getParser() {
        return new APIRequest.ResponseParser<CreatorAssetCreative>(){

            @Override
            public APINodeList<CreatorAssetCreative> parseResponse(String response, APIContext context, APIRequest<CreatorAssetCreative> request, String header) throws APIException.MalformedResponseException {
                return CreatorAssetCreative.parseResponse(response, context, request, header);
            }
        };
    }

    public static enum EnumModerationStatus {
        VALUE_ARCHIVED("ARCHIVED"),
        VALUE_ELIGIBLE("ELIGIBLE"),
        VALUE_EXPIRED("EXPIRED"),
        VALUE_INELIGIBLE("INELIGIBLE"),
        VALUE_IN_REVIEW("IN_REVIEW"),
        VALUE_PAUSED("PAUSED"),
        VALUE_UNKNOWN("UNKNOWN");

        private String value;

        private EnumModerationStatus(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static class APIRequestGet
    extends APIRequest<CreatorAssetCreative> {
        CreatorAssetCreative lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"id", "image_url", "moderation_status", "product_item_retailer_id", "product_url", "retailer_id", "video_url"};

        @Override
        public CreatorAssetCreative getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public CreatorAssetCreative parseResponse(String response, String header) throws APIException {
            return CreatorAssetCreative.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public CreatorAssetCreative execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public CreatorAssetCreative execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<CreatorAssetCreative> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<CreatorAssetCreative> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, CreatorAssetCreative>(){

                public CreatorAssetCreative apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestImageUrlField() {
            return this.requestImageUrlField(true);
        }

        public APIRequestGet requestImageUrlField(boolean value) {
            this.requestField("image_url", value);
            return this;
        }

        public APIRequestGet requestModerationStatusField() {
            return this.requestModerationStatusField(true);
        }

        public APIRequestGet requestModerationStatusField(boolean value) {
            this.requestField("moderation_status", value);
            return this;
        }

        public APIRequestGet requestProductItemRetailerIdField() {
            return this.requestProductItemRetailerIdField(true);
        }

        public APIRequestGet requestProductItemRetailerIdField(boolean value) {
            this.requestField("product_item_retailer_id", value);
            return this;
        }

        public APIRequestGet requestProductUrlField() {
            return this.requestProductUrlField(true);
        }

        public APIRequestGet requestProductUrlField(boolean value) {
            this.requestField("product_url", value);
            return this;
        }

        public APIRequestGet requestRetailerIdField() {
            return this.requestRetailerIdField(true);
        }

        public APIRequestGet requestRetailerIdField(boolean value) {
            this.requestField("retailer_id", value);
            return this;
        }

        public APIRequestGet requestVideoUrlField() {
            return this.requestVideoUrlField(true);
        }

        public APIRequestGet requestVideoUrlField(boolean value) {
            this.requestField("video_url", value);
            return this;
        }
    }
}

