/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;

public class GeoGatingPolicy
extends APINode {
    @SerializedName(value="after_schedule")
    private String mAfterSchedule = null;
    @SerializedName(value="exclude_country")
    private List<String> mExcludeCountry = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="include_country")
    private List<String> mIncludeCountry = null;
    @SerializedName(value="name")
    private String mName = null;
    @SerializedName(value="valid_from")
    private String mValidFrom = null;
    @SerializedName(value="valid_until")
    private String mValidUntil = null;
    protected static Gson gson = null;

    GeoGatingPolicy() {
    }

    public GeoGatingPolicy(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public GeoGatingPolicy(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public GeoGatingPolicy fetch() throws APIException {
        GeoGatingPolicy newInstance = GeoGatingPolicy.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static GeoGatingPolicy fetchById(Long id, APIContext context) throws APIException {
        return GeoGatingPolicy.fetchById(id.toString(), context);
    }

    public static ListenableFuture<GeoGatingPolicy> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return GeoGatingPolicy.fetchByIdAsync(id.toString(), context);
    }

    public static GeoGatingPolicy fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<GeoGatingPolicy> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<GeoGatingPolicy> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<GeoGatingPolicy>(context, "", "/", "GET", GeoGatingPolicy.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<GeoGatingPolicy>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<GeoGatingPolicy>(context, "", "/", "GET", GeoGatingPolicy.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static GeoGatingPolicy loadJSON(String json, APIContext context, String header) {
        GeoGatingPolicy geoGatingPolicy = (GeoGatingPolicy)GeoGatingPolicy.getGson().fromJson(json, GeoGatingPolicy.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(geoGatingPolicy.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        geoGatingPolicy.context = context;
        geoGatingPolicy.rawValue = json;
        geoGatingPolicy.header = header;
        return geoGatingPolicy;
    }

    public static APINodeList<GeoGatingPolicy> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<GeoGatingPolicy> geoGatingPolicys = new APINodeList<GeoGatingPolicy>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        geoGatingPolicys.add(GeoGatingPolicy.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return geoGatingPolicys;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            geoGatingPolicys.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        geoGatingPolicys.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            geoGatingPolicys.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            geoGatingPolicys.add(GeoGatingPolicy.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                geoGatingPolicys.add(GeoGatingPolicy.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            geoGatingPolicys.add(GeoGatingPolicy.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return geoGatingPolicys;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        geoGatingPolicys.add(GeoGatingPolicy.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return geoGatingPolicys;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        geoGatingPolicys.add(GeoGatingPolicy.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return geoGatingPolicys;
                }
                geoGatingPolicys.clear();
                geoGatingPolicys.add(GeoGatingPolicy.loadJSON(json, context, header));
                return geoGatingPolicys;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return GeoGatingPolicy.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldAfterSchedule() {
        return this.mAfterSchedule;
    }

    public List<String> getFieldExcludeCountry() {
        return this.mExcludeCountry;
    }

    public String getFieldId() {
        return this.mId;
    }

    public List<String> getFieldIncludeCountry() {
        return this.mIncludeCountry;
    }

    public String getFieldName() {
        return this.mName;
    }

    public String getFieldValidFrom() {
        return this.mValidFrom;
    }

    public String getFieldValidUntil() {
        return this.mValidUntil;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public GeoGatingPolicy copyFrom(GeoGatingPolicy instance) {
        this.mAfterSchedule = instance.mAfterSchedule;
        this.mExcludeCountry = instance.mExcludeCountry;
        this.mId = instance.mId;
        this.mIncludeCountry = instance.mIncludeCountry;
        this.mName = instance.mName;
        this.mValidFrom = instance.mValidFrom;
        this.mValidUntil = instance.mValidUntil;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<GeoGatingPolicy> getParser() {
        return new APIRequest.ResponseParser<GeoGatingPolicy>(){

            @Override
            public APINodeList<GeoGatingPolicy> parseResponse(String response, APIContext context, APIRequest<GeoGatingPolicy> request, String header) throws APIException.MalformedResponseException {
                return GeoGatingPolicy.parseResponse(response, context, request, header);
            }
        };
    }

    public static class APIRequestGet
    extends APIRequest<GeoGatingPolicy> {
        GeoGatingPolicy lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"after_schedule", "exclude_country", "id", "include_country", "name", "valid_from", "valid_until"};

        @Override
        public GeoGatingPolicy getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public GeoGatingPolicy parseResponse(String response, String header) throws APIException {
            return GeoGatingPolicy.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public GeoGatingPolicy execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public GeoGatingPolicy execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<GeoGatingPolicy> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<GeoGatingPolicy> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, GeoGatingPolicy>(){

                public GeoGatingPolicy apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestAfterScheduleField() {
            return this.requestAfterScheduleField(true);
        }

        public APIRequestGet requestAfterScheduleField(boolean value) {
            this.requestField("after_schedule", value);
            return this;
        }

        public APIRequestGet requestExcludeCountryField() {
            return this.requestExcludeCountryField(true);
        }

        public APIRequestGet requestExcludeCountryField(boolean value) {
            this.requestField("exclude_country", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestIncludeCountryField() {
            return this.requestIncludeCountryField(true);
        }

        public APIRequestGet requestIncludeCountryField(boolean value) {
            this.requestField("include_country", value);
            return this;
        }

        public APIRequestGet requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGet requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGet requestValidFromField() {
            return this.requestValidFromField(true);
        }

        public APIRequestGet requestValidFromField(boolean value) {
            this.requestField("valid_from", value);
            return this;
        }

        public APIRequestGet requestValidUntilField() {
            return this.requestValidUntilField(true);
        }

        public APIRequestGet requestValidUntilField(boolean value) {
            this.requestField("valid_until", value);
            return this;
        }
    }
}

