/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Map;

public class HasLeadAccess
extends APINode {
    @SerializedName(value="app_has_leads_permission")
    private Boolean mAppHasLeadsPermission = null;
    @SerializedName(value="can_access_lead")
    private Boolean mCanAccessLead = null;
    @SerializedName(value="enabled_lead_access_manager")
    private Boolean mEnabledLeadAccessManager = null;
    @SerializedName(value="failure_reason")
    private String mFailureReason = null;
    @SerializedName(value="failure_resolution")
    private String mFailureResolution = null;
    @SerializedName(value="is_page_admin")
    private Boolean mIsPageAdmin = null;
    @SerializedName(value="page_id")
    private String mPageId = null;
    @SerializedName(value="user_has_leads_permission")
    private Boolean mUserHasLeadsPermission = null;
    @SerializedName(value="user_id")
    private String mUserId = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return null;
    }

    public static HasLeadAccess loadJSON(String json, APIContext context, String header) {
        HasLeadAccess hasLeadAccess = (HasLeadAccess)HasLeadAccess.getGson().fromJson(json, HasLeadAccess.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(hasLeadAccess.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        hasLeadAccess.context = context;
        hasLeadAccess.rawValue = json;
        hasLeadAccess.header = header;
        return hasLeadAccess;
    }

    public static APINodeList<HasLeadAccess> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<HasLeadAccess> hasLeadAccesss = new APINodeList<HasLeadAccess>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        hasLeadAccesss.add(HasLeadAccess.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return hasLeadAccesss;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            hasLeadAccesss.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        hasLeadAccesss.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            hasLeadAccesss.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            hasLeadAccesss.add(HasLeadAccess.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                hasLeadAccesss.add(HasLeadAccess.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            hasLeadAccesss.add(HasLeadAccess.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return hasLeadAccesss;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        hasLeadAccesss.add(HasLeadAccess.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return hasLeadAccesss;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        hasLeadAccesss.add(HasLeadAccess.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return hasLeadAccesss;
                }
                hasLeadAccesss.clear();
                hasLeadAccesss.add(HasLeadAccess.loadJSON(json, context, header));
                return hasLeadAccesss;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return HasLeadAccess.getGson().toJson((Object)this);
    }

    public Boolean getFieldAppHasLeadsPermission() {
        return this.mAppHasLeadsPermission;
    }

    public HasLeadAccess setFieldAppHasLeadsPermission(Boolean value) {
        this.mAppHasLeadsPermission = value;
        return this;
    }

    public Boolean getFieldCanAccessLead() {
        return this.mCanAccessLead;
    }

    public HasLeadAccess setFieldCanAccessLead(Boolean value) {
        this.mCanAccessLead = value;
        return this;
    }

    public Boolean getFieldEnabledLeadAccessManager() {
        return this.mEnabledLeadAccessManager;
    }

    public HasLeadAccess setFieldEnabledLeadAccessManager(Boolean value) {
        this.mEnabledLeadAccessManager = value;
        return this;
    }

    public String getFieldFailureReason() {
        return this.mFailureReason;
    }

    public HasLeadAccess setFieldFailureReason(String value) {
        this.mFailureReason = value;
        return this;
    }

    public String getFieldFailureResolution() {
        return this.mFailureResolution;
    }

    public HasLeadAccess setFieldFailureResolution(String value) {
        this.mFailureResolution = value;
        return this;
    }

    public Boolean getFieldIsPageAdmin() {
        return this.mIsPageAdmin;
    }

    public HasLeadAccess setFieldIsPageAdmin(Boolean value) {
        this.mIsPageAdmin = value;
        return this;
    }

    public String getFieldPageId() {
        return this.mPageId;
    }

    public HasLeadAccess setFieldPageId(String value) {
        this.mPageId = value;
        return this;
    }

    public Boolean getFieldUserHasLeadsPermission() {
        return this.mUserHasLeadsPermission;
    }

    public HasLeadAccess setFieldUserHasLeadsPermission(Boolean value) {
        this.mUserHasLeadsPermission = value;
        return this;
    }

    public String getFieldUserId() {
        return this.mUserId;
    }

    public HasLeadAccess setFieldUserId(String value) {
        this.mUserId = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public HasLeadAccess copyFrom(HasLeadAccess instance) {
        this.mAppHasLeadsPermission = instance.mAppHasLeadsPermission;
        this.mCanAccessLead = instance.mCanAccessLead;
        this.mEnabledLeadAccessManager = instance.mEnabledLeadAccessManager;
        this.mFailureReason = instance.mFailureReason;
        this.mFailureResolution = instance.mFailureResolution;
        this.mIsPageAdmin = instance.mIsPageAdmin;
        this.mPageId = instance.mPageId;
        this.mUserHasLeadsPermission = instance.mUserHasLeadsPermission;
        this.mUserId = instance.mUserId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<HasLeadAccess> getParser() {
        return new APIRequest.ResponseParser<HasLeadAccess>(){

            @Override
            public APINodeList<HasLeadAccess> parseResponse(String response, APIContext context, APIRequest<HasLeadAccess> request, String header) throws APIException.MalformedResponseException {
                return HasLeadAccess.parseResponse(response, context, request, header);
            }
        };
    }
}

