/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;

public class IGUserExportForCAM
extends APINode {
    @SerializedName(value="email")
    private String mEmail = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="is_paid_partnership_messages_enabled")
    private Boolean mIsPaidPartnershipMessagesEnabled = null;
    @SerializedName(value="messaging_id")
    private String mMessagingId = null;
    @SerializedName(value="portfolio_url")
    private String mPortfolioUrl = null;
    @SerializedName(value="username")
    private String mUsername = null;
    protected static Gson gson = null;

    IGUserExportForCAM() {
    }

    public IGUserExportForCAM(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public IGUserExportForCAM(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public IGUserExportForCAM fetch() throws APIException {
        IGUserExportForCAM newInstance = IGUserExportForCAM.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static IGUserExportForCAM fetchById(Long id, APIContext context) throws APIException {
        return IGUserExportForCAM.fetchById(id.toString(), context);
    }

    public static ListenableFuture<IGUserExportForCAM> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return IGUserExportForCAM.fetchByIdAsync(id.toString(), context);
    }

    public static IGUserExportForCAM fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<IGUserExportForCAM> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<IGUserExportForCAM> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<IGUserExportForCAM>(context, "", "/", "GET", IGUserExportForCAM.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<IGUserExportForCAM>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<IGUserExportForCAM>(context, "", "/", "GET", IGUserExportForCAM.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static IGUserExportForCAM loadJSON(String json, APIContext context, String header) {
        IGUserExportForCAM igUserExportForCAM = (IGUserExportForCAM)IGUserExportForCAM.getGson().fromJson(json, IGUserExportForCAM.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(igUserExportForCAM.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        igUserExportForCAM.context = context;
        igUserExportForCAM.rawValue = json;
        igUserExportForCAM.header = header;
        return igUserExportForCAM;
    }

    public static APINodeList<IGUserExportForCAM> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<IGUserExportForCAM> igUserExportForCAMs = new APINodeList<IGUserExportForCAM>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        igUserExportForCAMs.add(IGUserExportForCAM.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return igUserExportForCAMs;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            igUserExportForCAMs.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        igUserExportForCAMs.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            igUserExportForCAMs.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            igUserExportForCAMs.add(IGUserExportForCAM.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                igUserExportForCAMs.add(IGUserExportForCAM.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            igUserExportForCAMs.add(IGUserExportForCAM.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return igUserExportForCAMs;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        igUserExportForCAMs.add(IGUserExportForCAM.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return igUserExportForCAMs;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        igUserExportForCAMs.add(IGUserExportForCAM.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return igUserExportForCAMs;
                }
                igUserExportForCAMs.clear();
                igUserExportForCAMs.add(IGUserExportForCAM.loadJSON(json, context, header));
                return igUserExportForCAMs;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return IGUserExportForCAM.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldEmail() {
        return this.mEmail;
    }

    public String getFieldId() {
        return this.mId;
    }

    public Boolean getFieldIsPaidPartnershipMessagesEnabled() {
        return this.mIsPaidPartnershipMessagesEnabled;
    }

    public String getFieldMessagingId() {
        return this.mMessagingId;
    }

    public String getFieldPortfolioUrl() {
        return this.mPortfolioUrl;
    }

    public String getFieldUsername() {
        return this.mUsername;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public IGUserExportForCAM copyFrom(IGUserExportForCAM instance) {
        this.mEmail = instance.mEmail;
        this.mId = instance.mId;
        this.mIsPaidPartnershipMessagesEnabled = instance.mIsPaidPartnershipMessagesEnabled;
        this.mMessagingId = instance.mMessagingId;
        this.mPortfolioUrl = instance.mPortfolioUrl;
        this.mUsername = instance.mUsername;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<IGUserExportForCAM> getParser() {
        return new APIRequest.ResponseParser<IGUserExportForCAM>(){

            @Override
            public APINodeList<IGUserExportForCAM> parseResponse(String response, APIContext context, APIRequest<IGUserExportForCAM> request, String header) throws APIException.MalformedResponseException {
                return IGUserExportForCAM.parseResponse(response, context, request, header);
            }
        };
    }

    public static class APIRequestGet
    extends APIRequest<IGUserExportForCAM> {
        IGUserExportForCAM lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"email", "id", "is_paid_partnership_messages_enabled", "messaging_id", "portfolio_url", "username"};

        @Override
        public IGUserExportForCAM getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public IGUserExportForCAM parseResponse(String response, String header) throws APIException {
            return IGUserExportForCAM.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public IGUserExportForCAM execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public IGUserExportForCAM execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<IGUserExportForCAM> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<IGUserExportForCAM> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, IGUserExportForCAM>(){

                public IGUserExportForCAM apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestEmailField() {
            return this.requestEmailField(true);
        }

        public APIRequestGet requestEmailField(boolean value) {
            this.requestField("email", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestIsPaidPartnershipMessagesEnabledField() {
            return this.requestIsPaidPartnershipMessagesEnabledField(true);
        }

        public APIRequestGet requestIsPaidPartnershipMessagesEnabledField(boolean value) {
            this.requestField("is_paid_partnership_messages_enabled", value);
            return this;
        }

        public APIRequestGet requestMessagingIdField() {
            return this.requestMessagingIdField(true);
        }

        public APIRequestGet requestMessagingIdField(boolean value) {
            this.requestField("messaging_id", value);
            return this;
        }

        public APIRequestGet requestPortfolioUrlField() {
            return this.requestPortfolioUrlField(true);
        }

        public APIRequestGet requestPortfolioUrlField(boolean value) {
            this.requestField("portfolio_url", value);
            return this;
        }

        public APIRequestGet requestUsernameField() {
            return this.requestUsernameField(true);
        }

        public APIRequestGet requestUsernameField(boolean value) {
            this.requestField("username", value);
            return this;
        }
    }
}

