/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.LeadGenCustomDisclaimer;
import com.facebook.ads.sdk.LeadGenPrivacyPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Map;

public class LeadGenLegalContent
extends APINode {
    @SerializedName(value="custom_disclaimer")
    private LeadGenCustomDisclaimer mCustomDisclaimer = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="privacy_policy")
    private LeadGenPrivacyPolicy mPrivacyPolicy = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static LeadGenLegalContent loadJSON(String json, APIContext context, String header) {
        LeadGenLegalContent leadGenLegalContent = (LeadGenLegalContent)LeadGenLegalContent.getGson().fromJson(json, LeadGenLegalContent.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(leadGenLegalContent.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        leadGenLegalContent.context = context;
        leadGenLegalContent.rawValue = json;
        leadGenLegalContent.header = header;
        return leadGenLegalContent;
    }

    public static APINodeList<LeadGenLegalContent> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<LeadGenLegalContent> leadGenLegalContents = new APINodeList<LeadGenLegalContent>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        leadGenLegalContents.add(LeadGenLegalContent.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return leadGenLegalContents;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            leadGenLegalContents.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        leadGenLegalContents.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            leadGenLegalContents.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            leadGenLegalContents.add(LeadGenLegalContent.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                leadGenLegalContents.add(LeadGenLegalContent.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            leadGenLegalContents.add(LeadGenLegalContent.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return leadGenLegalContents;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        leadGenLegalContents.add(LeadGenLegalContent.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return leadGenLegalContents;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        leadGenLegalContents.add(LeadGenLegalContent.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return leadGenLegalContents;
                }
                leadGenLegalContents.clear();
                leadGenLegalContents.add(LeadGenLegalContent.loadJSON(json, context, header));
                return leadGenLegalContents;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return LeadGenLegalContent.getGson().toJson((Object)this);
    }

    public LeadGenCustomDisclaimer getFieldCustomDisclaimer() {
        return this.mCustomDisclaimer;
    }

    public LeadGenLegalContent setFieldCustomDisclaimer(LeadGenCustomDisclaimer value) {
        this.mCustomDisclaimer = value;
        return this;
    }

    public LeadGenLegalContent setFieldCustomDisclaimer(String value) {
        Type type = new TypeToken<LeadGenCustomDisclaimer>(){}.getType();
        this.mCustomDisclaimer = (LeadGenCustomDisclaimer)LeadGenCustomDisclaimer.getGson().fromJson(value, type);
        return this;
    }

    public String getFieldId() {
        return this.mId;
    }

    public LeadGenLegalContent setFieldId(String value) {
        this.mId = value;
        return this;
    }

    public LeadGenPrivacyPolicy getFieldPrivacyPolicy() {
        return this.mPrivacyPolicy;
    }

    public LeadGenLegalContent setFieldPrivacyPolicy(LeadGenPrivacyPolicy value) {
        this.mPrivacyPolicy = value;
        return this;
    }

    public LeadGenLegalContent setFieldPrivacyPolicy(String value) {
        Type type = new TypeToken<LeadGenPrivacyPolicy>(){}.getType();
        this.mPrivacyPolicy = (LeadGenPrivacyPolicy)LeadGenPrivacyPolicy.getGson().fromJson(value, type);
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public LeadGenLegalContent copyFrom(LeadGenLegalContent instance) {
        this.mCustomDisclaimer = instance.mCustomDisclaimer;
        this.mId = instance.mId;
        this.mPrivacyPolicy = instance.mPrivacyPolicy;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<LeadGenLegalContent> getParser() {
        return new APIRequest.ResponseParser<LeadGenLegalContent>(){

            @Override
            public APINodeList<LeadGenLegalContent> parseResponse(String response, APIContext context, APIRequest<LeadGenLegalContent> request, String header) throws APIException.MalformedResponseException {
                return LeadGenLegalContent.parseResponse(response, context, request, header);
            }
        };
    }
}

