/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Map;

public class PaymentRequestDetails
extends APINode {
    @SerializedName(value="amount")
    private Object mAmount = null;
    @SerializedName(value="creation_time")
    private Long mCreationTime = null;
    @SerializedName(value="note")
    private String mNote = null;
    @SerializedName(value="payment_request_id")
    private String mPaymentRequestId = null;
    @SerializedName(value="receiver_id")
    private String mReceiverId = null;
    @SerializedName(value="reference_number")
    private String mReferenceNumber = null;
    @SerializedName(value="sender_id")
    private String mSenderId = null;
    @SerializedName(value="status")
    private String mStatus = null;
    @SerializedName(value="transaction_time")
    private Long mTransactionTime = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return null;
    }

    public static PaymentRequestDetails loadJSON(String json, APIContext context, String header) {
        PaymentRequestDetails paymentRequestDetails = (PaymentRequestDetails)PaymentRequestDetails.getGson().fromJson(json, PaymentRequestDetails.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(paymentRequestDetails.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        paymentRequestDetails.context = context;
        paymentRequestDetails.rawValue = json;
        paymentRequestDetails.header = header;
        return paymentRequestDetails;
    }

    public static APINodeList<PaymentRequestDetails> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<PaymentRequestDetails> paymentRequestDetailss = new APINodeList<PaymentRequestDetails>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        paymentRequestDetailss.add(PaymentRequestDetails.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return paymentRequestDetailss;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            paymentRequestDetailss.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        paymentRequestDetailss.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            paymentRequestDetailss.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            paymentRequestDetailss.add(PaymentRequestDetails.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                paymentRequestDetailss.add(PaymentRequestDetails.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            paymentRequestDetailss.add(PaymentRequestDetails.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return paymentRequestDetailss;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        paymentRequestDetailss.add(PaymentRequestDetails.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return paymentRequestDetailss;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        paymentRequestDetailss.add(PaymentRequestDetails.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return paymentRequestDetailss;
                }
                paymentRequestDetailss.clear();
                paymentRequestDetailss.add(PaymentRequestDetails.loadJSON(json, context, header));
                return paymentRequestDetailss;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return PaymentRequestDetails.getGson().toJson((Object)this);
    }

    public Object getFieldAmount() {
        return this.mAmount;
    }

    public PaymentRequestDetails setFieldAmount(Object value) {
        this.mAmount = value;
        return this;
    }

    public Long getFieldCreationTime() {
        return this.mCreationTime;
    }

    public PaymentRequestDetails setFieldCreationTime(Long value) {
        this.mCreationTime = value;
        return this;
    }

    public String getFieldNote() {
        return this.mNote;
    }

    public PaymentRequestDetails setFieldNote(String value) {
        this.mNote = value;
        return this;
    }

    public String getFieldPaymentRequestId() {
        return this.mPaymentRequestId;
    }

    public PaymentRequestDetails setFieldPaymentRequestId(String value) {
        this.mPaymentRequestId = value;
        return this;
    }

    public String getFieldReceiverId() {
        return this.mReceiverId;
    }

    public PaymentRequestDetails setFieldReceiverId(String value) {
        this.mReceiverId = value;
        return this;
    }

    public String getFieldReferenceNumber() {
        return this.mReferenceNumber;
    }

    public PaymentRequestDetails setFieldReferenceNumber(String value) {
        this.mReferenceNumber = value;
        return this;
    }

    public String getFieldSenderId() {
        return this.mSenderId;
    }

    public PaymentRequestDetails setFieldSenderId(String value) {
        this.mSenderId = value;
        return this;
    }

    public String getFieldStatus() {
        return this.mStatus;
    }

    public PaymentRequestDetails setFieldStatus(String value) {
        this.mStatus = value;
        return this;
    }

    public Long getFieldTransactionTime() {
        return this.mTransactionTime;
    }

    public PaymentRequestDetails setFieldTransactionTime(Long value) {
        this.mTransactionTime = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public PaymentRequestDetails copyFrom(PaymentRequestDetails instance) {
        this.mAmount = instance.mAmount;
        this.mCreationTime = instance.mCreationTime;
        this.mNote = instance.mNote;
        this.mPaymentRequestId = instance.mPaymentRequestId;
        this.mReceiverId = instance.mReceiverId;
        this.mReferenceNumber = instance.mReferenceNumber;
        this.mSenderId = instance.mSenderId;
        this.mStatus = instance.mStatus;
        this.mTransactionTime = instance.mTransactionTime;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<PaymentRequestDetails> getParser() {
        return new APIRequest.ResponseParser<PaymentRequestDetails>(){

            @Override
            public APINodeList<PaymentRequestDetails> parseResponse(String response, APIContext context, APIRequest<PaymentRequestDetails> request, String header) throws APIException.MalformedResponseException {
                return PaymentRequestDetails.parseResponse(response, context, request, header);
            }
        };
    }
}

